#include <string.h>
#include "decpress.h"
#include "type.h"

sint cpifstream::decompress(uchar *inbuff, uint inbuff_len, uchar *outbuff)
	{
uint ctrl_bits;
uint ctrl_mask=0;
uchar *inbuff_idx=inbuff;
uchar *outbuff_idx=outbuff;
uchar *inbuff_end=inbuff+inbuff_len;
uint cmd;
uint cnt;
uint ofs;
//uint len;

	while (inbuff_idx < inbuff_end)
		{
        if ((ctrl_mask>>=1)==0)
			{
            ctrl_bits = *(uint*)inbuff_idx;
            inbuff_idx += sizeof(uint);
            ctrl_mask = (uint)0x8000;
			}

		if ((ctrl_bits & ctrl_mask)==0)
			{
            *outbuff_idx++ = *inbuff_idx++;
			continue;
			}

        cmd=((*inbuff_idx>>4) & (uchar)0x0F);
        cnt=(*inbuff_idx++ & (uchar)0x0F);

		switch(cmd)
			{
			case 0:
				cnt+=3;
				memset(outbuff_idx,*inbuff_idx++,cnt);
                outbuff_idx += cnt;
				break;
			case 1:
                cnt += (*inbuff_idx++ << 4);
                cnt += 19;
                memset(outbuff_idx, *inbuff_idx++, cnt);
                outbuff_idx += cnt;
				break;
			case 2:
                ofs = cnt+3;
                ofs += (*inbuff_idx++ << 4);
                cnt = *inbuff_idx++;
                cnt += 16;
				memcpy(outbuff_idx, outbuff_idx-ofs, cnt);
                outbuff_idx += cnt;
				break;
			default:
                ofs = cnt+3;
                ofs += (*inbuff_idx++ << 4);
                memcpy(outbuff_idx, outbuff_idx-ofs, cmd);
                outbuff_idx += cmd;
				break;
			}
		}
    return (sint)(outbuff_idx-outbuff);
	}


