// comclass. h -- definition for the base communication class

#define CHATTYPE 0
#define TRANSFERTYPE 1

class CCommunication;

class 
/*#ifdef CLASSES
DllExport
#else
DllImport
#endif
*/CProtocol: public CFile
{
  protected:
   CCommunication *m_cInBound;
   CCommunication *m_cOutBound;

  int m_bIsCommunicationEstablished;
  public:
  CProtocol();
  ~CProtocol();
  virtual BOOL Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError = NULL)=0;
//  static BOOL PASCAL GetStatus(const char* pszFileName,
//				CFileStatus& rStatus);
//  static void PASCAL SetStatus(const char* pszFileName,
//				const CFileStatus& status);
  virtual UINT Read(void FAR* lpBuf, UINT nCount)=0;
  virtual void Write(const void FAR* lpBuf, UINT nCount)=0;
  virtual void Close()=0;

  BOOL CheckOnResponse(void);
  void Acknowledge();
  void Reject();


// members related to the communication as such
};


class 
/*#ifdef CLASSES
DllExport
#else
DllImport
#endif
*/CChatProtocol: public CProtocol
{private: 
// helper functions

 public:
  CChatProtocol(CCommunication *cInBound, CCommunication *cOutBound);
  ~CChatProtocol();
  BOOL Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError = NULL);

  UINT Read(void FAR* lpBuf, UINT nCount);
  void Write(const void FAR* lpBuf, UINT nCount);
  void Close();
// protocol functions
  BOOL InitiateConversationAsServer(CString **csArg);
  BOOL InitiateConversationAsClient(const char *szMachineName, int iMachineName);

// members related to the transmission of data
//  BOOL SendTypedData(void *cBuf,int iType,int iSize);
//  BOOL ReceiveTypedData(void *cBuf, unsigned long *piType, unsigned long *piSize);
};

class 
/*#ifdef CLASSES
DllExport
#else
DllImport
#endif
*/CFileTransferProtocol: public CProtocol
{private: 
// helper functions
 DWORD dwFileLength;
 BOOL m_bWeAreServer;
 CFile *cfFile;
 public:
  CFileTransferProtocol(CCommunication *cInBound, CCommunication *cOutBound);
  ~CFileTransferProtocol();
  BOOL Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError = NULL);

  UINT Read(void FAR* lpBuf, UINT nCount);
  UINT ReadHelper(void FAR* lpBuf, UINT nCount);
  void Write(const void FAR* lpBuf, UINT nCount);
  void WriteHelper(const void FAR* lpBuf, UINT nCount);

  void Close();
  DWORD GetLength();
  void SetLength(DWORD dwNewLen);

  BOOL LastMinuteCheckReceiver(BOOL);
  BOOL LastMinuteCheckSender(BOOL);

};

class CSelectorProtocol: public CProtocol
{ public:
  CSelectorProtocol(CCommunication *cInBound, CCommunication *cOutBound);

  int GetCommunicationType(void);
  void SetCommunicationType(int);

// dummies to avoid error 2259
  BOOL Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError = NULL);
  UINT Read(void FAR* lpBuf, UINT nCount);
  void Write(const void FAR* lpBuf, UINT nCount);
  void Close();

};
