#include "stdafx.h"
#include "comclass.h"
#include "sockets.h"

#include <windows.h>

#define READ_PORT 5001
#define WRITE_PORT 5002

// Buffers and pipe symbolic constants.
#define MAX_PENDING_CONNECTS 4  /* The backlog allowed for listen() */

int iObjectCount = 0;
BOOL bAreWeInitialized = FALSE;

CSocket::CSocket() : CCommunication()
{WSADATA WSAData;
 m_bWeAreDuplicated = FALSE;
 if (iObjectCount == 0 && WSAStartup(MAKEWORD(1,1), &WSAData) == 0)
   bAreWeInitialized = TRUE;
   iObjectCount++;


};

CSocket::~CSocket()
{
iObjectCount--;
if (!iObjectCount)
 {WSACleanup();
  bAreWeInitialized = FALSE;
 };

};



BOOL CSocket::Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError)
// currently we only support the READ and WRITE open flags...
  {	 BOOL bReturn;
     if (!bAreWeInitialized) return FALSE;
       m_theSocket = socket( AF_INET, SOCK_STREAM, 0);
	    if (m_theSocket == INVALID_SOCKET)
		  {WSAGetLastError();
		   return FALSE;
		  };
        if (!pszFileName)         // NULL means we want to be the server
          {char szBuf[80];
		   gethostname(szBuf,80);
		   m_phe = gethostbyname(szBuf);
		   m_bWeAreServer = TRUE;
		  }
        else      // we want to be the client...
          {m_phe = gethostbyname(pszFileName);
	        m_bWeAreServer = FALSE;
          };
		   if (m_phe == NULL)
		     WSAGetLastError();

		bReturn = (m_phe != NULL);
	  if (!bReturn)
	   { closesocket(m_theSocket);
	     return FALSE;
	   };
	  SOCKADDR_IN saTemp;
      saTemp.sin_family = AF_INET;
      memcpy((char FAR *)&(saTemp.sin_addr), m_phe->h_addr,
      m_phe->h_length);
      saTemp.sin_port =
        m_bWeAreServer?
          (nOpenFlags&modeWrite?htons(WRITE_PORT):htons(READ_PORT))
          :(nOpenFlags&modeWrite?htons(READ_PORT):htons(WRITE_PORT));
	  if (m_bWeAreServer)
	   {if (bind(m_theSocket,(PSOCKADDR)&saTemp, sizeof(saTemp)) == SOCKET_ERROR)
	     {WSAGetLastError();
	      closesocket(m_theSocket);
          return FALSE;
         };
        if (listen(m_theSocket, MAX_PENDING_CONNECTS ) == SOCKET_ERROR)
         {WSAGetLastError();
          closesocket(m_theSocket);
		  return FALSE;
		 };
	   m_bIsCommunicationEstablished = FALSE;
	   return TRUE;
       }
	   else  // we are client
	   { if (connect(m_theSocket,(PSOCKADDR)&saTemp,sizeof(saTemp)) == SOCKET_ERROR)
	      { WSAGetLastError();
		    closesocket(m_theSocket);
			return FALSE;
		  };
         m_bIsCommunicationEstablished = TRUE;
		 m_CommSocket = m_theSocket;          // here we'll get in trouble when closing...
         return TRUE;
	   };
  };


  // we need to fix this as well...

CCommunication *CSocket::Duplicate()
{
CSocket *csResult = new CSocket();
csResult->m_theSocket = m_theSocket;   // let's take the preventively allocated socket...
csResult->m_CommSocket = m_CommSocket;
csResult->m_bWeAreServer = m_bWeAreServer;
csResult->m_sa = m_sa;
csResult->m_bWeAreDuplicated = TRUE;
csResult->m_bIsCommunicationEstablished = m_bIsCommunicationEstablished;
return csResult;
}

BOOL CSocket::AwaitCommunicationAttempt(void)
{ m_CommSocket = accept(m_theSocket,&m_sa,0);  // Block until a client connects.
  if (m_CommSocket == INVALID_SOCKET)
     {WSAGetLastError();
      return FALSE;
	 };
  m_bIsCommunicationEstablished = TRUE;
  return TRUE;
};

void CSocket::Close(void)
{
if (m_bIsCommunicationEstablished)
//   closesocket(m_CommSocket);
closesocket(m_CommSocket);
if (!m_bWeAreDuplicated)
  closesocket(m_theSocket);
};


void CSocket::Write(const void FAR* pBuf, UINT iCount)
{
if (send(m_CommSocket,(const char *)pBuf,iCount,0) == SOCKET_ERROR)
     WSAGetLastError();
};

UINT CSocket::Read(void FAR* lpBuf, UINT nCount)
{ UINT iResult;
  iResult = recv(m_CommSocket,(char *)lpBuf,nCount,0);
  if (iResult == 0 || iResult == SOCKET_ERROR)
         {WSAGetLastError();
		  return 0;
		 };
  return iResult;
};

BOOL CSocket::ReConnect(void)
{	return FALSE;
};



