#include "stdafx.h"
#include "comclass.h"
#include "npipe.h"

#include <windows.h>


// Buffers and pipe symbolic constants.
#define IN_BUF_SIZE        4096
#define OUT_BUF_SIZE       4096
#define TIME_OUT           INFINITE


  CNamedPipe::CNamedPipe() : CCommunication()
  {};
  CNamedPipe::~CNamedPipe()
  {
  };


//  BOOL AwaitCommunicationAttempt();
//  BOOL ReConnect();

  BOOL CNamedPipe::Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError)
// currently we only support the READ and WRITE open flags...
  {     if (!pszFileName)         // NULL means we want to be the server
      {SECURITY_ATTRIBUTES sa;
       SECURITY_DESCRIPTOR sd;
       InitializeSecurityDescriptor(&sd,SECURITY_DESCRIPTOR_REVISION);
       SetSecurityDescriptorDacl(&sd,TRUE,(PACL)NULL,FALSE);
       sa.nLength = sizeof(sa);
       sa.lpSecurityDescriptor = &sd;
       sa.bInheritHandle = TRUE;  
       m_hFile = (UINT)CreateNamedPipe (
               nOpenFlags&modeWrite?"\\\\.\\PIPE\\chatwrit"
                                  :"\\\\.\\PIPE\\chatread", 
//PIPE_ACCESS_DUPLEX|FILE_FLAG_WRITE_THROUGH,
               nOpenFlags&modeWrite?
                PIPE_ACCESS_OUTBOUND//| FILE_FLAG_WRITE_THROUGH
               :PIPE_ACCESS_INBOUND,//| FILE_FLAG_WRITE_THROUGH,                
               PIPE_WAIT                         // Wait on messages.
               | PIPE_READMODE_MESSAGE           // Specify byte pipe.
               | PIPE_TYPE_MESSAGE,
               1,               // Maximum instance limit.
               OUT_BUF_SIZE,                     // Buffer sizes.
               IN_BUF_SIZE,
               TIME_OUT,                         // Specify time out.
               &sa);                            // to let everybody connect...

                                       // Check Errors.
       if ((HANDLE)m_hFile == INVALID_HANDLE_VALUE)
       {GetLastError();
        return FALSE;                          // flag is not set here. 
       };
	   m_bWeAreServer = TRUE;
      }
      else      // we want to be the client... 
      { char fileName[50];    // beautify this...
       wsprintf (fileName, "%s%s%s", "\\\\", pszFileName, 
               nOpenFlags&modeWrite?"\\PIPE\\chatread"
                                  :"\\PIPE\\chatwrit");

                                       // Do CreateFile() to connect to the
                                       // named pipe.
       m_hFile = (UINT)CreateFile (fileName,              // Pipe name.
						           nOpenFlags&modeWrite?GENERIC_WRITE
						           :GENERIC_READ, 
//GENERIC_READ|GENERIC_WRITE,
                             FILE_SHARE_READ        // Share both read and write.
                           | FILE_SHARE_WRITE ,
                           NULL,                  // No security.
                           OPEN_EXISTING,         // Fail if not existing.
                           FILE_ATTRIBUTE_NORMAL,  //
                           NULL);                 // No template.

                                       // Do some error checking.
       if ((HANDLE)m_hFile == INVALID_HANDLE_VALUE)
         {
		 GetLastError();
         return FALSE;
		 };
	   m_bWeAreServer = FALSE;
      };



  m_bIsCommunicationEstablished = TRUE;
  return TRUE;
  };


CCommunication *CNamedPipe::Duplicate()
{ HANDLE hNewHandle;
CNamedPipe *cnpReturn = new(CNamedPipe);
if (DuplicateHandle(GetCurrentProcess(),(HANDLE)m_hFile,
                    GetCurrentProcess(),&hNewHandle,NULL,FALSE,DUPLICATE_SAME_ACCESS))
   {cnpReturn->m_hFile = (UINT) hNewHandle;
    cnpReturn->m_bIsCommunicationEstablished = m_bIsCommunicationEstablished;
    cnpReturn->m_bWeAreServer = m_bWeAreServer;
    cnpReturn->cOtherMachineName = cOtherMachineName;
    cnpReturn->m_iMode = m_iMode;
	return cnpReturn;
   };
return (CNamedPipe *)NULL;

}

  BOOL CNamedPipe::AwaitCommunicationAttempt(void)
  {
                                          // Block until a client connects.
   return ConnectNamedPipe((HANDLE)m_hFile, NULL);

  };

  void CNamedPipe::Close(void)
  {	if (m_bIsCommunicationEstablished)
    {
	 m_bIsCommunicationEstablished = FALSE;
     if (m_bWeAreServer) 
        {
        FlushFileBuffers((HANDLE)m_hFile);
        DisconnectNamedPipe((HANDLE)m_hFile);
		};
	 CloseHandle((HANDLE)m_hFile);
	};
  };


  void CNamedPipe::Write(const void FAR* pBuf, UINT iCount)
  {
    unsigned long bytesSent;
    if (!WriteFile ((HANDLE)m_hFile, pBuf, iCount,&bytesSent, NULL))
      { DWORD dwErrorCode = GetLastError();
	    if (dwErrorCode != ERROR_PIPE_NOT_CONNECTED)
         RaiseException(dwErrorCode,0,0,NULL);
	  };
  };

  UINT CNamedPipe::Read(void FAR* pBuf, UINT iCount)
  {	unsigned long uReturn;
    BOOL bRetCode;
    bRetCode = ReadFile((HANDLE)m_hFile,pBuf,iCount,&uReturn,NULL);
      if (!bRetCode)
      	{ DWORD dwErrorCode = GetLastError();  
          if (dwErrorCode != ERROR_PIPE_NOT_CONNECTED)
		   RaiseException(dwErrorCode,0,0,NULL);
		   return 0;   // to shut the compiler up
	    }
	  else return uReturn;
  };

  BOOL CNamedPipe::ReConnect(void)
  {	return FALSE;
  };



