#include "stdafx.h"
#include "comclass.h"
#include "netbios.h"

#include <windows.h>

char achLocalMachineName[MAXMACHINENAME];
int iNBObjectCount = 0;
BOOL bAddNameWorked = TRUE;

// helper functions				   

void MakeNetBIOSName(PSTR pszName, PSTR pszPaddedName)
{ 
  if (pszName) strcpy(pszPaddedName,pszName);  
  unsigned int iLoop;
  for (iLoop=strlen(pszPaddedName);iLoop<MAXMACHINENAME;iLoop++)
    pszPaddedName[iLoop]=' ';
  pszPaddedName[MAXMACHINENAME-1]='\0';
 };

//idfeally, this would go into DllEntry, once we implement the class libraries as DLLs...

CNetBIOS::CNetBIOS() : CCommunication()
{
};

CNetBIOS::~CNetBIOS()
{
};



BOOL CNetBIOS::Open(const char* pszFileName, UINT nOpenFlags,
		CFileException* pError)
  {
  // first of all, register the new NetBIOS name and fail for good if this doesn't work
    if (!bAddNameWorked) return FALSE;
	if (iNBObjectCount == 0)
// the first object to be created initializes the machine name string...
// this way, we won't have to do it every time...
 {unsigned long iMachineNameLength;
   GetComputerName(achLocalMachineName,&iMachineNameLength);
  achLocalMachineName[iMachineNameLength]='!';
 
  MakeNetBIOSName((char *)0,achLocalMachineName);
  strupr(achLocalMachineName);
  CNCB ncbNameAdder;
  ncbNameAdder.Reset(0,0);
  if (ncbNameAdder.AddName(achLocalMachineName) != NRC_GOODRET)
      {bAddNameWorked = FALSE;
	   return FALSE;
	  };

 };
iNBObjectCount++; 

      	 
    if (!pszFileName)
	 {	  // we are server
	      // nothing to do here, believe it or not!!! :-)
		  // the name table already contains the entry for our machine...
	 }	  
	 else
	 {int iLen = strlen(pszFileName);
	  MakeNetBIOSName((char *)pszFileName,m_pszPaddedFileName); 
	  _strupr(m_pszPaddedFileName);
	  m_pszPaddedFileName[iLen]='!';
	  m_thisNCB.Call(achLocalMachineName,m_pszPaddedFileName,(UCHAR)0,(UCHAR)0);
	  m_lsn = m_thisNCB.GetLSN();

	 };
	 return TRUE;
 
  };


  // we need to fix this as well...
  // try copy constructor?
CCommunication *CNetBIOS::Duplicate()
{
CNetBIOS *cNew;
cNew = new(CNetBIOS);
// we won't need to set an LSN here because that one will be determined
// later on...
cNew->m_lsn = m_lsn;
cNew->m_thisNCB.Fill(m_thisNCB);
//strcpy(cNew->m_pszPaddedFileName,m_pszPaddedFileName);
iNBObjectCount++; 
return cNew; 
}

BOOL CNetBIOS::AwaitCommunicationAttempt(void)
{
if (m_thisNCB.Listen(achLocalMachineName,"*              \0",(UCHAR)0,(UCHAR)0)
   !=NRC_GOODRET) return FALSE;

//when listen returns, we'll need to store the lsn...
m_lsn = m_thisNCB.GetLSN();
 
return TRUE;
};

void CNetBIOS::Close(void)
{
m_thisNCB.Hangup(m_lsn);

// this code invoked to clean up after the last object...

iNBObjectCount--;
if (!iNBObjectCount)
  {CNCB ncbNameDeleter;
   ncbNameDeleter.DeleteName(achLocalMachineName);
  };

};


void CNetBIOS::Write(const void FAR* pBuf, UINT iCount)
{ 
  m_thisNCB.Send(m_lsn,(char *)pBuf,iCount);
};

UINT CNetBIOS::Read(void FAR* lpBuf, UINT nCount)
{ 
  if (m_thisNCB.Receive(m_lsn,(char *)lpBuf,nCount) != NRC_GOODRET)
      return 0;
   return (UINT)m_thisNCB.GetLength();
};

BOOL CNetBIOS::ReConnect(void)
{	return FALSE;
};



