#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "comm.h"

/* See the COMM.H file for documentation on functions */

/*  M_I86 is predefined in Microsoft C, but not Turbo, with this information
**  we can use the following code to create portable code
*/
#ifdef M_I86
     /*  For MicroSoft C  */
	#include <malloc.h>
   #define SetVect(x,y) _dos_setvect(x,y)
   #define GetVect(x)   _dos_getvect(x)
   #define Enable()     _enable()
   #define Disable()    _disable()
#else
	/*   For Turbo C */
	#include <alloc.h>
   #define SetVect(x,y) setvect(x,y)
   #define GetVect(x)   getvect(x)
   #define Enable()     enable()
   #define Disable()    disable()
#endif


int _int_port;  /* 1 for COM1, 2 for COM2, etc...  */
int BufSize=4096;

volatile char *_icbuffer, *HeadP, *TailP, *BuffEnd, *BufBeg;

/****************************************/
/*  Serial interupt data & declarations */
/****************************************/
struct _COMPORT_ {
		int BasePort, IntMask, Intr;
		} ComPort[]={ 
			0x3F8, 0xEF, 0x0C,
			0x2F8, 0xF7, 0x0B
			};
	/* Input and output Ports */
#define InPort(x)    (ComPort[x].BasePort)
#define OutPort(x)   (ComPort[x].BasePort)
	/* Baud rate divisors */
#define BaudL(x)     (ComPort[x].BasePort)
#define BaudH(x)     (ComPort[x].BasePort+1)
	/* Interrupt enable, and ID ports */
#define IntEnable(x) (ComPort[x].BasePort+1)
#define IntID(x)     (ComPort[x].BasePort+2)
	/* Lince Control register, and Modem Control Register */
#define LCReg(x)     (ComPort[x].BasePort+3)
#define MCReg(x)     (ComPort[x].BasePort+4)
	/* Lines Status and Modem Status registers */
#define LStatus(x)   (ComPort[x].BasePort+5)
#define MStatus(x)   (ComPort[x].BasePort+6)
	/* Interrupt mask and number */
#define IntMask(x)   (ComPort[x].IntMask)
#define Intr(x)      (ComPort[x].Intr)

void (interrupt far *Serial)();  /* for origninal serial int. */

void interrupt far Handler(void);

/****************************************/
/*  The actual serial interface driver  */
/****************************************/
void interrupt far Handler()
{
	Disable();

	*TailP++=(char)inp(InPort(_int_port));
	if (TailP==BuffEnd)
	   TailP=BufBeg;
	if (TailP==HeadP) {
	   HeadP++;
	   if (HeadP==BuffEnd)
	      HeadP=BufBeg;
	   }

	Enable();
	outp(0x20, 0x20);   /* send an end of interrupt signal to hardare */
}
/******END OF SERIAL INTERUPT***************/


/*****************************************/
/*     SET & RESET SERIAL INTERUPT       */
/*****************************************/
int SetIntr(int cport)
{
	unsigned i;
	if((_icbuffer=malloc(BufSize))==NULL)
		return(-1);
	BufBeg=_icbuffer;
	BuffEnd=_icbuffer+BufSize;
	TailP=HeadP=BufBeg;
	if (inp(InPort(cport))==0xFF && inp(LStatus(cport))==0xFF && inp(LCReg(cport))==0xFF)
	   return(-1);   /* no UART found at port address */

     /* install the handler  */
	_int_port=cport;
	Serial=GetVect(Intr(cport));
	SetVect(Intr(cport), Handler);    /* point to our handler  */
	
             /*  set up the interupt controller  */

	outp(MCReg(cport), 0xB);   /* set OUT2, DTR, & RTS on UART  */
	outp(IntEnable(cport), 1);     /* set interupt enable reg on UART to data ready */
	i=inp(0x21);                  /* setup interupt controller chip  */
	i= (i & IntMask(cport));
	outp(0x21, i);
	return(0);
}


void ResetIntr(int cport)
{
	int i,j;
	/* first disable the interupts via interrupt mask on PIC chip */

	free(_icbuffer);
	i=~IntMask(cport);
	j=inp(0x21);
	j=j | i;
	/* outp(0x21, j); */

	/*  then restore the original serial intr pointer  */

	SetVect(Intr(cport), Serial);
}

/*******************************************/
/*         recieve to COM? functions       */
/*******************************************/
int GetSer()
{
	int ch;

	ch=*HeadP++;
	if (HeadP==BuffEnd)
	   HeadP=BufBeg;
	return(ch);
}


/******************************************/
/* func to init COM? to correct settings  */
/* returns a -1 if port not there,        */
/*           -2 if invalid parameter      */
/*            0 if ok                     */
/******************************************/

int PortInit(int cport, int baud, int parity, int data, int stop)
{

	unsigned char attrib=0;
	char temp;
	int cbaud;


	/* these items setup the attribute bits for the byte to be sent
	   to the UART (data bits, stop bits, etc.)  */

	if (inp(InPort(cport))==0xFF && inp(LStatus(cport))==0xFF && inp(LCReg(cport))==0xFF)
	   return(-1);   /* no UART found at port address */


	if (cport>0x0001|| parity>2 || data>8 || stop>2)
	   return(-2);
	if (parity != 0) {
	   if (parity==1)
	      attrib=8;
	   else
	      attrib=24;
	   }
	if (stop>1)
	   attrib=attrib+4;
	attrib+= (unsigned char)(data-5);
	cbaud=0;
	if (baud==19200)
	   cbaud=6;
	else
	 if (baud==9600)
	    cbaud=0xC;
	 else
	   if (baud==4800)
	      cbaud=0x18;
	   else
	      if (baud==2400)
	         cbaud=0x30;
	      else
	         if (baud==1200)
	            cbaud=0x60;
	         else
	            if (baud==300)
	               cbaud=0x180;
	            else
	               return(-2);
	
	outp(LCReg(cport), (unsigned) 0x80);
	outp(BaudL(cport), cbaud%0x100);
	outp(BaudH(cport), cbaud/0x100);
	outp(LCReg(cport), attrib);
	
	return(0);
}

void ClearBuffer()       /* clear communications buffer */
{
	HeadP=TailP=BufBeg;
}


void Xmit(char ch)
{
  while ( ((inp(LStatus(_int_port))) & 0x20 ) ==0)
		;
  outp(OutPort(_int_port), ch);
}

void SendStr(char *str)
{
	while (*str)  {
	   if (*str == '|')
	      Xmit(13);
	   else if (*str=='~')  {
	      OneSec();
	      }
	   else
	      Xmit(*str);
	   str++;
	   }
}

int SerAvl()
{
	return(HeadP-TailP);
}

int IsCarrier(int cport)
{
	int i;

	i=inp(MStatus(cport));
	return(i&0x80);
}

void OneSec()
{
	union REGS regin, regout;

	unsigned int dest;

	regin.h.ah=0;
	int86(0x1A, &regin, &regout);
	dest=regout.x.dx+18;
	while( (unsigned) regout.x.dx < dest) {
	   regin.h.ah=0;
	   int86( 0x1A, &regin, &regout);
	  }
}
	
void Delay(int len)
{
	union REGS regin, regout;

	unsigned int dest;

	regin.h.ah=0;
	int86(0x1A, &regin, &regout);
	dest=regout.x.dx+len;
	while( (unsigned) regout.x.dx < dest) {
	   regin.h.ah=0;
	   int86( 0x1A, &regin, &regout);
	   }
}

int ModemStatus()
{
	return(MStatus(_int_port));
}

void HWHangup()
{
	int i;
	i=inp(MCReg(_int_port));
	i=i&0xFE;
	outp(MCReg(_int_port), 0);  /* all bits off, then on, then normal */
	inp(MCReg(_int_port));
	outp(MCReg(_int_port), 0xFF);
	inp(MCReg(_int_port));
	outp(MCReg(_int_port), i);
	OneSec();
	i=i|1;
	outp(MCReg(_int_port), i);
}
