/***********************************************************************
 *                         COMLIBMD.H                                  *
 *                                                                     *
 * This file contains compiler specific code.                          *
 *                                                                     *
 ***********************************************************************/


#if TURBOC                 /* TurboC specific code starts here. */

#ifndef DEF_COM_INFO
#define DEF_COM_INFO

typedef struct
  {
    unsigned int    baud_divisor;        /* Mult by MAXBAUD to get baud rate  */
    unsigned int        data_len;
    unsigned int          parity;
    unsigned int        stopbits;
    unsigned int             lcr;        /* Addr of Line Control Register     */
    unsigned int             lsr;        /* Addr of Line Status Register      */
    unsigned int             mcr;        /* Addr of Modem Control Register    */
    unsigned int             msr;        /* Addr of Modem Status Register     */
    unsigned int             ior;        /* Addr of I/O Register              */
    unsigned int             iir;        /* Addr of Interrupt ID Register     */
    unsigned int             ier;        /* Addr of Interupt Enable Register  */
    unsigned int     com_int_vec;        /* Interupt vector number            */
    unsigned int    com_irq_mask;        /* IRQ mask                          */
    void interrupt (*old_com_intr) ();   /* Pointer to old com interupt vector*/
    unsigned int    flw_ctrl_flg;        /* XON/XOFF flow control on/off flag */
    unsigned int    xoff_in_stat;        /* Status flag for Incomming XON/XOFF*/
    unsigned int   xoff_out_stat;        /* Status flag for Outgoing XON/OFF  */
    unsigned int      flw_hi_lim;        /* Char level at which XOFF gets sent*/
    unsigned int      flw_lo_lim;        /* Char level at which XON gets sent */
    unsigned int            tail;        /* index to last comm char received  */
    unsigned int            head;        /* index to next available char      */
    unsigned int         buf_siz;        /* Size of circular com_buf          */
    char *                combuf;        /* Pointer to the circular buffer    */
  } COM_INFO;

#endif

/*
 * These are functions used by the high level communications routines.
 * They should not be used directly.
 */

void interrupt        com1int (void);
void interrupt        com2int (void);

#endif                        /* TurboC specific code ends */

#if MSC                       /* MSC specific code starts here */

/*
 * These are defines to convert the TurboC source code to the equiv. MSC
 * code.
 */

#define outportb    outp         /* Microsoft Equivalent function to */
                                 /* output a byte to a port.         */
#define inportb     inp          /* Microsoft Equivalent function to */
                                 /* input a byte from a port.        */

#define getvect     _dos_getvect /* MSC equivs to TurboC function.   */
#define setvect     _dos_setvect /* MSC equivs to TurboC function.   */

#define enable      _enable      /* MSC equivs to TurboC function.   */
#define disable     _disable     /* MSC equivs to TurboC function.   */

#ifndef DEF_COM_INFO
#define DEF_COM_INFO

typedef struct
  {
    unsigned int    baud_divisor;        /* Mult by MAXBAUD to get baud rate  */
    unsigned int        data_len;
    unsigned int          parity;
    unsigned int        stopbits;
    unsigned int             lcr;        /* Addr of Line Control Register     */
    unsigned int             lsr;        /* Addr of Line Status Register      */
    unsigned int             mcr;        /* Addr of Modem Control Register    */
    unsigned int             msr;        /* Addr of Modem Status Register     */
    unsigned int             ior;        /* Addr of I/O Register              */
    unsigned int             iir;        /* Addr of Interrupt ID Register     */
    unsigned int             ier;        /* Addr of Interupt Enable Register  */
    unsigned int     com_int_vec;        /* Interupt vector number            */
    unsigned int    com_irq_mask;        /* IRQ mask                          */
    void     far *  old_com_intr;        /* Pointer to old com interupt vector*/
    unsigned int    flw_ctrl_flg;        /* XON/XOFF flow control on/off flag */
    unsigned int    xoff_in_stat;        /* Status flag for Incomming XON/XOFF*/
    unsigned int   xoff_out_stat;        /* Status flag for Outgoing XON/OFF  */
    unsigned int      flw_hi_lim;        /* Char level at which XOFF gets sent*/
    unsigned int      flw_lo_lim;        /* Char level at which XON gets sent */
    unsigned int            tail;        /* index to last comm char received  */
    unsigned int            head;        /* index to next available char      */
    unsigned int         buf_siz;        /* Size of circular com_buf          */
    char *                combuf;        /* Pointer to the circular buffer    */
  } COM_INFO;

#endif

/*
 * These are functions used by the high level communications routines.
 * They should not be used directly.
 */

void far interrupt com1int (void);
void far interrupt com2int (void);

#endif
