#include "cl.h"

void checkName (CmdLn &CL,int no)
{
	char *p = CL.getName (no);
	if (p)
	{
		cout << "Name value check failed " << p
			  << "Any key to continue ";
		cin.get ();
	}
}

void checkOption (CmdLn &CL,int no)
{
	char *p;
	char c = CL.getOption (no,p);
	if (c != CL_ENDOFLIST)
	{
		cout << "Option value check failed " << c << "Any key to continue ";
		cin.get ();
	}
}

void checkError (CmdLn &CL,int no)
{
	char c = CL.getError (no);
	if (c != CL_ENDOFLIST)
	{
		cout << "Error value check failed " << c << "Any key to continue ";
		cin.get ();
	}
}

int main ()
{
	int i;
	char *p;
	char c;
	char s [81];


// Parse the command line

	CmdLn CL ("cCe:E:gGhHl:L:o:O:P:p:vVxX");
	clrscr ();
	cout << "Command Line Parser Test - version " << CL.version () << endl;
	cout << "Any key to continue "; cin.get ();

// Get additional user input

	cout << "Command Line Parsed" << endl;
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Enter additional test fields (Names or Options) - ";
	cin.getline (s,80);
	CL.add (s);
	cout << "User input parsed" << endl;
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

// Check invalid values

	clrscr ();
	cout << "Checking invalid values" << endl;
	checkName (CL,-1);
	checkName (CL,999);
	checkOption (CL,-1);
	checkOption (CL,999);
	checkError (CL,-1);
	checkError (CL,999);
	cout << "Any key to continue "; cin.get ();

// Examine the Name entries

	clrscr ();
	cout << "Sequential Name Test" << endl;

	for (i = 0; i < CL.numNames (); i++)
	{
		p = CL.getName (i);
		cout << "No " << i <<  " " << p << endl;
	}
	cout << "Any key to continue "; cin.get ();

// Examine the Option entries

	clrscr ();
	cout << "Sequential Option Test" << endl;
	for (i = 0; i < CL.numOptions (); i++)
	{
		c = CL.getOption (i,p);
		cout << "No " << i <<  " Option " << c << ":" << p << endl;
	}
	cout << "Any key to continue "; cin.get ();

// Examine the Error entries

	clrscr ();
	cout << "Sequential Error Test" << endl;
	for (i = 0; i < CL.numErrors (); i++)
	{
		c = CL.getError (i);
		cout << "No " << i <<  " Option " << c << endl;
	}
	cout << "Any key to continue "; cin.get ();

// Clear name entries

	clrscr ();
	cout << "Clear Names Test" << endl;
	CL.clearNames ();
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

// Clear option entries

	clrscr ();
	cout << "Clear Options Test" << endl;
	CL.clearOptions ();
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

// Clear error entries

	clrscr ();
	cout << "Clear Errors Test" << endl;
	CL.clearErrors ();
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

// Clear all entries and reparse the command line

	clrscr ();
	cout << "Reparse Command Line Test" << endl;
	CL.reset ();
	CL.printContentsOn (cout);
	cout << "Any key to continue "; cin.get ();

// Get Last Name Test

	clrscr ();
	cout << "Get Last Name Test" << endl;
	p = CL.getLastName ();
	cout << p << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get First Name Test" << endl;
	p = CL.getFirstName ();
	cout << p << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Next Name Test" << endl;
	while ((p = CL.getNextName ()) != NULL)
	{
		cout << p << endl;
	}
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Previous Name Test" << endl;
	p = CL.getLastName ();
	while ((p = CL.getPrevName ()) != NULL)
	{
		cout << p << endl;
	}
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Last Option Test" << endl;
	c = CL.getLastOption (p);
	cout << "Option " << c << ":" << p << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get First Option Test" << endl;
	c = CL.getFirstOption (p);
	cout << "Option " << c << ":" << p << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Next Option Test" << endl;
	while ((c = CL.getNextOption (p)) != CL_ENDOFLIST)
	{
		cout << "Option " << c << ":" << p << endl;
	}
	cout << "Any key to continue "; cin.get ();
	clrscr ();
	cout << "Get Previous Option Test" << endl;
	c = CL.getLastOption (p);
	while ((c = CL.getPrevOption (p)) != CL_ENDOFLIST)
	{
		cout << "Option " << c << ":" << p << endl;
	}
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Last Error Test" << endl;
	c = CL.getLastError ();
	cout << "Error : " << c << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get First Error Test" << endl;
	c = CL.getFirstError ();
	cout << "Error : " << c << endl;
	cout << "Any key to continue "; cin.get ();

	clrscr ();
	cout << "Get Next Error Test" << endl;
	while ((c = CL.getNextError ()) != CL_ENDOFLIST)
	{
		cout << "Error : " << c << endl;
	}
	cout << "Any key to continue "; cin.get ();
	clrscr ();
	cout << "Get Previous Error Test" << endl;
	c = CL.getLastError ();
	while ((c = CL.getPrevError ()) != CL_ENDOFLIST)
	{
		cout << "Error : " << c << endl;
	}
	cout << "Any key to continue "; cin.get ();
	return 0;
}
