#ifndef _CL_H
#define _CL_H

#include <dir.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <array.h>

_CLASSDEF(oclass)
_CLASSDEF(nclass)

#define oClass	__firstUserClass
#define nClass (oClass+1)
#define CL_ENDOFLIST -1

class _CLASSTYPE nclass : public Object
{
private :
	char *name;
public :
	nclass () { name = NULL; }
	nclass (char *Aname) { name = strdup (Aname); }
	~nclass () { if (name) delete [strlen (name) + 1] name; name = NULL; }
	char *getName () { return name; }
	virtual hashValueType   hashValue() const { return hashValueType(0); }
	virtual int             isEqual( RCObject ) const { return 1; }
	virtual void printOn( Rostream os) const
	{
		os << "Name " << name << endl;
	}
	char *nameOf () const { return "nClass"; }
	classType isA() const { return nClass; }
};

class _CLASSTYPE oclass : public Object
{
private :
	char SwitchChar;
	char *OptionArg;
public :
	oclass (char a) { SwitchChar = a; OptionArg = NULL; }
	oclass () { SwitchChar = 0; OptionArg = NULL; }
	~oclass () { if (OptionArg) delete [strlen (OptionArg) + 1] OptionArg; OptionArg = NULL; }
	void setOptionArg (char *a) { OptionArg = strdup (a); }
	int getOption (char *&optarg ) { optarg = OptionArg; return SwitchChar; }
	virtual hashValueType   hashValue() const { return hashValueType(0); }
	virtual int             isEqual( RCObject ) const { return 1; }
	virtual void printOn( Rostream os) const
	{
		os << "Option " << SwitchChar << ":" << OptionArg << endl;
	}
	char *nameOf () const { return "oClass"; }
	classType isA() const { return oClass; }
};

class _CLASSTYPE CmdLn
{
private :
	Array *Options;
	Array *Names;
	Array *Errors;
	oclass *coption;
	char *options,*opt;
	int nameindex,optionindex,errorindex;

	void pCluster ();
	void pOption (char *lookup);
	void expand ();
	void pName ();
	void clear (Array *);
	char gOpt (Array *p,int no,char *&optarg);
public:
	CmdLn (char *);
	~CmdLn ();
	void printContentsOn (Rostream);
	int  numOptions () { return Options->getItemsInContainer (); }
	char getOption (int,char *&);
	char getFirstOption (char *&optarg) { return getOption (optionindex = 0,optarg); }
	char getLastOption  (char *&optarg)
		{ return getOption (optionindex = Options->getItemsInContainer () - 1,optarg); }
	char getNextOption  (char *&optarg) { return getOption (++optionindex,optarg); }
	char getPrevOption  (char *&optarg) { return getOption (--optionindex,optarg); }

	int  numErrors () { return Errors->getItemsInContainer (); }
	char getError (int no);
	char getFirstError () { return getError (errorindex = 0); }
	char getLastError  ()
		{ return getError (errorindex = Errors->getItemsInContainer () - 1); }
	char getNextError  () { return getError (++errorindex); }
	char getPrevError  () { return getError (--errorindex); }

	int  numNames () { return Names->getItemsInContainer (); }
	char *getName (int);
	char *getFirstName () { return getName (nameindex = 0); }
	char *getLastName  ()
		{ return getName (nameindex = Names->getItemsInContainer () - 1); }
	char *getNextName  () { return getName (++nameindex); }
	char *getPrevName  () { return getName (--nameindex); }
	void add (char *);
	void clearNames ();
	void clearOptions ();
	void clearErrors ();
	void clearAll ();
	void reset ();
	char *version () { return "1.1";}
};

#endif
