/* C Easy Program Example: forms.c */

/* DECLARE USER FIELD EDIT ROUTINES */
   int ext_amt();
   int get_code();

/* DECLARE EVENT DRIVEN FUNCTION KEY ROUTINES */
   int F3_key();
   int F4_key();
   int F5_key();

double atof();
#include <ceasy1.h>    /* 1st standard header */

/* USER FORM HEADERS, GENERATED BY mfm.exe */

#include <forms.h>
#include <forms2.h>
#include <forms3.h>
#include <forms4.h>

#include <ceasy2.h>   /* 2nd standard header */

unsigned char *form3, *form4; /* global pointers forms */

/* PROGRAM STARTS HERE */

unsigned char far * SAVPTR;

char buffer[24*80];
   main()
    {
/*   char buffer[24*80]; */
     FILE *fptr;

     start_program();

if(GRAPHICS_MODE) set_graphics_mode(OFF);

     enable_time('C',SL,66); /* suppress display SL+2 */

     /* CLEAR SCREEN AND SET UP COLORS */

        init_screen();

     /* INITIALIZE DATA ENTRY TABLE FOR ALL FORMS */

        init_table();

     /* READ AND DISPLAY forms.frm */

        FORM_PTR=DEFAULT_FORM_PTR;

        FPTR=&FIELD[0];

        read_form("_forms");   /* read forms.frm from system directory */
        define_fields(FPTR);   /* update FORM field locations and types */
        display_form();        /* display forms.frm */

     /* LOAD DATA INTO forms.frm */

        if((fptr=xopen("record.rcd","r+"))==NULL)  /* LOCAL record */
         {
          erase(buffer,sizeof(buffer));
         }
        else
         {
          read_record(fptr,0,buffer,sizeof(buffer));
          load_fields(buffer,FPTR);   /* load form data fields from buffer */
         }
     /* DISPLAY DATE AND DATA FIELDS IN forms.frm */

        set_field("DATE",FPTR);  /* set AL and AC from DATE line and column */
        see_date(AL,AC);         /* display todays date */

        display_fields(FPTR);    /* display FORM data fields */

     /* ENTER DATA INTO forms.frm, until Esc Key is pressed */

        while(!ESCAPE_KEY) enter_form(FPTR);

     /* SAVE DATA BACK INTO RECORD */

        erase(buffer,sizeof(buffer));  /* erase buffer */
        store_fields(buffer,FPTR);     /* store data fields from forms.frm */
        write_record(fptr,0,buffer,sizeof(buffer)); /* save new data */
        fclose(fptr);

     stop_program();
    }

/* F3 FUNCTION CODE ROUTINE */

   int F3_key()
    {
     event_F[3].function=NULL; /* temporarily inhibit F3 and F5 functions */
     event_F[5].function=NULL;

     keep_window(3,78,22,2,2); /* keep screen contents */

     FORM_PTR=form3; /* set FORM pointer to form3.frm */

     /* set FIELD ENTRY POINTER to first field in form3.frm */
     FPTR=locate_field("FORM3 NAME",&FIELD[0]);
     define_fields(FPTR);

     FAST_DISPLAY=ON;       /* to display w/o disturbing existing screen */

     display_form();        /* display forms3.frm */
     display_fields(FPTR);  /* display data fields in forms3.frm */

     while(!ESCAPE_KEY) enter_form(FPTR); /* enter form until Esc key */

     restore_window(3,78,22,2,2); /* restore screen, removing form */
     event_F[3].function=F3_key;    /* enable F3 and F5 functions */
     event_F[5].function=F5_key;
     return(0);
    }

/* F4 FUNCTION CODE ROUTINE - SIMILAR to F3_key  */

   int F4_key()
    {
     event_F[4].function=NULL;   /* temporarily inhibit F4 */
     event_F[5].function=NULL;
     keep_window(4,78,22,2,2);   /* keep screen contents */

     FORM_PTR=form4;
     FPTR=locate_field("FORM4 NAME",&FIELD[0]);
     define_fields(FPTR);

     FAST_DISPLAY=ON;       /* to display w/o disturbing existing screen */
     display_form();        /* display forms4.frm */
     display_fields(FPTR);  /* display data fields in forms4.frm */

     while(!ESCAPE_KEY) enter_form(FPTR); /* enter form until Esc key */

     restore_window(4,78,22,2,2);   /* restore screen, removing form */
     event_F[4].function=F4_key;    /* re-enable F4_key function */
     event_F[5].function=F5_key;
     return(0);
   }

/* F5 FUNCTION CODE ROUTINE, TO PROCESS MULTI-LINE forms2.frm */

   /* USES DEFAULT FORM (forms.frm) */
   int F5_key()
    {
     int x;
     form_entry *baseptr;

     event_F[3].function=NULL;
     event_F[4].function=NULL;
     event_F[5].function=NULL;

     FPTR=locate_field("ITEM CODE",&FIELD[0]);
     FORM_PTR=DEFAULT_FORM_PTR;

     MAX_FIELDS=5;    /* number of fields to display for each line */

     for(AL=11,x=9;x;x--,AL++)  /* start at line 11, repeat for 9 lines */
      {
       display_fields(FPTR);    /* display 'repeated' forms2.frm form */
      }
     AL=11;                     /* start floating form line at 11 for entry */
     baseptr=FPTR;              /* baseptr set to first field in form */
     while(!ESCAPE_KEY)
      {
       resume_form(baseptr,FPTR); /* resume entry at field last terminated */
       FPTR=LAST_FIELD_PTR;       /* save pointer to last field terminated */

       if(UP AND AL>11)
         AL--;                    /* move up one line */
       if((DOWN OR ENTER OR FILLED OR TAB OR FORWARD) && AL<19)
         AL++;                    /* move down one line */
       if(ENTER OR FILLED OR TAB OR FORWARD)
         FPTR=baseptr;            /* if Enter Key, resume from first field */
      }
     event_F[3].function=F3_key;
     event_F[4].function=F4_key;
     event_F[5].function=F5_key;

     return(0);
    }

/* USER FIELD EDIT ROUTINE FOR ITEM CODE ENTRY IN forms2.frm */

   int get_code()
    {
     char *codes;
     int keepbkgnd, keepfgnd, keepbkgndbar;

     /* CHANGE COLORS FOR POP-UP WINDOW */

        keepbkgnd=BKGND_WINDOW;    /* save window colors */
        keepfgnd=FGND_WINDOW;
        keepbkgndbar=BKGND_BAR;

        BKGND_WINDOW=BKGND_BLACK;  /* select pop-up browse window colors */
        FGND_WINDOW=FGND_WHITE;
        BKGND_BAR=BKGND_MAGENTA;

        show_cursor();

     /* TEST KEYS BEFORE DISPLAYING BROWSE WINDOW */

        if(UP OR BACK) return(FORM_CONTINUE); /* if Up or Back Arrow */

        if(APTR[0] != SPACE) return(FORM_CONTINUE); /* if first not space */

     /* CREATE MEMORY AREA FOR CODES */

        if((codes=Malloc(100*51))==NULL)  /* malloc ITEM CODE browse area */
         {
          display_error("Cannot Malloc for codes",NULL);
          stop_program(-1);
         }
        erase(codes,100*51);

     /* LOAD AND BROWSE CODES */

        keep_window(1,51,10,4,20);         /* keep screen area */
        read_text("_codes",codes,51,100);  /* load codes into browse area */
        browse_select(codes,100*51,51,10,4,20); /* browse and select a code */
        restore_window(1,51,10,4,20);     /* restore previous screen area */

     /* MOVE SELECTED CODE, DESCRIPTION AND PRICE INTO FORM */

        move(LAST_LINE_PTR,APTR,SIZE);    /* move ITEM CODE to form */
        cursor(AL,AC);
        see_(APTR,SIZE);                  /* display ITEM CODE in form */

        move(LAST_LINE_PTR+10+1,APTR+10+1,30); /* move DESCRIPTION to form */
        cursor(AL,AC+10+1);
        see_(APTR+10+1,30);               /* display DESCRIPTION in form */

        move(LAST_LINE_PTR+10+1+30+2,APTR+10+1+30+2,8); /* move PRICE to form */        cursor(AL,AC+10+1+30+2);
        see_(APTR+10+1+30+1,8);           /* display PRICE in form

     /* RESTORE COLORS */

        BKGND_WINDOW=keepbkgnd;  /* restore window colors */
        FGND_WINDOW=keepfgnd;
        BKGND_BAR=keepbkgndbar;

     return(FORM_CONTINUE);
    }

/* USER FIELD EDIT TO EXTENDED AMOUNT, FIELD ENTRY IS NOT PERMITED */

   int ext_amt()
    {
     char *price, *qty;
     double dprice, extended;
     int iqty;
     char *ptr;

     qty=fld_str("QUANTITY",&FIELD[0]);     /* convert QUANTITY to string */
     price=fld_str("UNIT PRICE",&FIELD[0]); /* convert UNIT PRICE to string */

     iqty=atoi(qty);                        /* convert QUANTITY to integer */
     dprice=atof(price);                    /* convert UNIT PRICE to float */
     extended=dprice*iqty;                  /* multiply QUANTITY by PRICE */

     set_field("EXTENDED AMOUNT",&FIELD[0]); /* set APTR to EXTENDED AMOUNT */

     sprintf(APTR,"%10.2f",extended);        /* move EXTENDED AMOUNT to form */

     cursor(AL,AC);     /* AL and AC were set above by set_field */
     see_(APTR,SIZE);   /* display EXTENTED AMOUNT in form */

     return(FORM_EXIT);
    }

/* INITIALIZE TABLE FOR ALL FORMS, ENABLE FUNCTION KEY EVENTS */

   int init_table()
    {
     /* UPDATE forms.frm FIELD LOCATIONS AND TYPE */

/*      FPTR=&FIELD[0];      */
        read_form("_forms");
        define_fields(FPTR);

     /* UPDATE forms2.frm FIELD LOCATIONS AND TYPE */

        FPTR=locate_field("ITEM CODE",&FIELD[0]);
        read_form("_forms2");
        define_fields(TPTR);

     /* UPDATE forms3.frm FIELD LOCATIONS AND TYPE */

        form3=new_form();
        FPTR=locate_field("FORM3 NAME",&FIELD[0]);
        read_form("_forms3");
        define_fields(TPTR);

     /* UPDATE forms4.frm FIELD LOCATIONS AND ATTRIBUTES */

        form4=new_form();
        FPTR=locate_field("FORM4 NAME",&FIELD[0]);
        read_form("_forms4");
        define_fields(FPTR);

     /* ENABLE FUNCTION KEY EVENTS */

        event_F[3].function=F3_key;
        event_F[4].function=F4_key;
        event_F[5].function=F5_key;

     return(0);
   }

/* CLEAR SCREEN AND SET UP COLORS */

   int init_screen()
    {
     clear_screen(BKGND_BLUE,FGND_YELLOW);
     BKGND_FORM=BKGND_BLUE;
     FGND_FORM=FGND_MAGENTA;
     BKGND_TIME=BKGND_BLUE;
     FGND_TIME=FGND_YELLOW;
     BKGND_DATE=BKGND_BLUE;
     FGND_DATE=FGND_YELLOW;
     return(0);
   }
