////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Testspin.cpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class to demonstarte Spin Control
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "testspin.hpp"
#include <ccckit.hpp>
#include <stdio.h>

void PaintInactiveTitle( HWND hWnd );

TestSpin::TestSpin( HWND w, HINSTANCE inst, int id )
			:	Dialog( w, inst, id )
{
}


TestSpin::~TestSpin()
{
}


BOOL TestSpin::WmInitDialog(HWND hwnd, HWND cw, LPARAM lp )
{
	Dialog::WmInitDialog( hwnd, cw, lp );
	_v1Wnd = GetDlgItem( hwnd, IDC_VAL1SPIN );
	_v2Wnd = GetDlgItem( hwnd, IDC_VAL2SPIN );
	RegisterUserMsg( SPIN_CLICK );

	float l, u, s, v;
	l = -24.0;
	u = 24.0;
	s = 0.25;
	v = 1.0;
	::SendMessage( _v1Wnd, SPIN_SETUVALUE, (WPARAM)0, (LPARAM)&u );
	::SendMessage( _v1Wnd, SPIN_SETLVALUE, (WPARAM)0, (LPARAM)&l );
	::SendMessage( _v1Wnd, SPIN_SETSTEP, (WPARAM)0, (LPARAM)&s );
	::SendMessage( _v1Wnd, SPIN_SETVALUE, (WPARAM)0, (LPARAM)&v );

	::SendMessage( _v2Wnd, SPIN_SETUVALUE, (WPARAM)0, (LPARAM)&u );
	::SendMessage( _v2Wnd, SPIN_SETLVALUE, (WPARAM)0, (LPARAM)&l );
	::SendMessage( _v2Wnd, SPIN_SETSTEP, (WPARAM)0, (LPARAM)&s );
	::SendMessage( _v2Wnd, SPIN_SETVALUE, (WPARAM)0, (LPARAM)&v );

	EDITMSG editMsg;
	lstrcpy( editMsg.editTxt, "1.0\"" );
	SendMessage( GetDlgItem(hwnd, IDC_VAL1), EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
	SendMessage( GetDlgItem(hwnd, IDC_VAL2), EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );

	return TRUE;
}


BOOL TestSpin::HandleUserMsg( HWND hwnd, UINT m, WPARAM, LPARAM lp )
{
	EDITMSG editMsg;
	if( m == SPIN_CLICK )
	{
		char tmp[ 8 ];
		LPSPINMSG sp = (LPSPINMSG)lp;
		if( sp )
		{
#if defined(__WIN32__) || defined(__FLAT__)
			if( (HWND)sp->hWnd == _v1Wnd )
#else
			if( (HWND)LOWORD(sp->hWnd) == _v1Wnd )
#endif
			{
				sprintf( tmp, "%.2f\"", sp->nVal );
				lstrcpy( editMsg.editTxt, tmp );
				SendMessage( GetDlgItem(hwnd, IDC_VAL1), EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
				SetFocus( GetDlgItem(hwnd, IDC_VAL1) );
			}

#if defined(__WIN32__) || defined(__FLAT__)
			if( (HWND)sp->hWnd == _v2Wnd )
#else
			if( (HWND)LOWORD(sp->hWnd) == _v2Wnd )
#endif
			{
				sprintf( tmp, "%.2f\"", sp->nVal );
				lstrcpy( editMsg.editTxt, tmp );
				SendMessage( GetDlgItem(hwnd, IDC_VAL2), EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
				SetFocus( GetDlgItem(hwnd, IDC_VAL2) );
			}
		}
		return TRUE;
	}

	return FALSE;
}


void TestSpin::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_SPIN, (WPARAM)0, (LPARAM)0 );
}



