////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: ResLoad.hpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class Manager to Manage Tab Dialogs
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////#include "resload.hpp"

#ifndef	RESLOAD_HPP
#define	RESLOAD_HPP

#include <windows.h>

#define	MAXDLGS		16

struct _ctrlTag {
	HWND	cHwnd;
	DWORD	dwExStyle;
	char  className[ 16 ];
	char	windowText[ 32 ];
	DWORD	windowStyle;
	int		id;
	int		x;
	int		y;
	int		w;
	int		h;
	_ctrlTag far *nextCtrl;
};
typedef _ctrlTag DLGCTRLS;
typedef _ctrlTag far *LPDLGCTRLS;


class ResourceLoader {
	int					_numDlgs;
	int					_currDlg;
	HWND				_parentWnd;
	HWND				_centerWnd;
	HINSTANCE		_hInst;
	LPDLGCTRLS	_dlgList[ MAXDLGS ];
	BOOL				_dlgStat[ MAXDLGS ];
	BOOL				_useCtl3d;
	
public:
	ResourceLoader( HWND pWnd, HINSTANCE hInst, BOOL ctl3d = FALSE );
	~ResourceLoader();
	// Ctl3d support
	void EnableCtl3d( HINSTANCE ctl3dInst );
	// Adding resources
	BOOL	AddDlg( LPCSTR resId, HINSTANCE resInst, BOOL hide = FALSE );
	BOOL	AddDlg( int resId, HINSTANCE resInst, BOOL hide = FALSE );

	// Query
	int		CurrDlg() const { return _currDlg; }

	// Settings
	void	SetOffSets( HWND center );
	BOOL	HideDlg( BOOL cDestroy = FALSE );
	BOOL	ShowDlg( int nDlg, BOOL hide = FALSE );

protected:
	ResourceLoader( const ResourceLoader& );
	const ResourceLoader& operator=( const ResourceLoader& );

	// Memory allocations
	LPDLGCTRLS	MakeNode();
	BOOL				DestroyDlg( int nDlg );
	BOOL				LoadControls( HWND );
	void				CreateDlgControls( int nDlg, BOOL hide );
};



#endif