////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Data.cpp
//	Date				: March 14, 1995
//	Remarks			: Sample File Handler
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include "data.hpp"
#include <fstream.h>


DATAREC sample[ 15 ] = {
	{ "Anthony", "Smith", "123 Owl Lane, Suite 101", "CampTown", "AL", "12345" },
	{ "Brendon", "Lee", "4545 Timber Lane, Rm 420", "RichTown", "AZ", "43342" },
	{ "Christopher", "Lambert", "355 Bluehazel Drive", "Bumsville", "CA", "21311" },
	{ "Diana", "Joans", "567 Tiffiny Box, Rm 111", "Stickville", "FL", "33211" },
	{ "Edith", "Bianca", "11th Street 234 Square", "Notown", "DC", "34567" },
	{ "Figgs", "Nuts", "345 Just a Lane", "Hicksville", "WV", "58585" },
	{ "George", "Fowler", "919 Tin Town Street", "BlueTown", "NY", "39393" },
	{ "Helen", "Trot", "349 Sea Lane, Apt 107", "MoTown", "NC", "93933" },
	{ "Issac", "Square", "929 Bowling Lane", "WaterTown", "NH", "82822" },
	{ "Jack", "McGraw", "636 Green Sky Blvd.", "LandTown", "NM", "73209" },
	{ "King", "James", "282 Downing Street", "LeesTown", "SD", "84523" },
	{ "Luke", "Walker", "12 Sky High Lane", "VillaTown", "YS", "72947" },
	{ "Mike", "Rudyard", "250 Ying Ting Lane", "CarpsTown", "ZT", "60024" },
	{ "Norma", "King", "111 Some Hotel Room", "FishTown", "FT", "01910" },
	{ "Opera", "Screams", "958 Arti Land", "RiverTown", "TV", "72008" }
};


static char dbName[] = "sample.db";
static ifstream ifh;

DataBase::DataBase()
{
	_fileOk = FALSE;
	_currRec = 0;
	_recCount = 0;
}


DataBase::~DataBase()
{
	ifh.close();
}


BOOL DataBase::InitDb()
{
	OpenFile();
	return _fileOk;
}


LPDATAREC DataBase::dbGoTop()
{
	if( Read( 1 ) )
		return &_buffer;
	return NULL;
}


LPDATAREC DataBase::dbGoBottom()
{
	if( Read( 15 ) )
		return &_buffer;
	return NULL;
}


LPDATAREC DataBase::dbGetRec()
{
	if( _fileOk && _currRec )
		return &_buffer;
	return NULL;
}


LPDATAREC DataBase::dbGetRec( int rec )
{
	if( rec > 0 && rec < 16 )
	{
		if( Read( rec ) )
			return &_buffer;
	}
	return NULL;
}



LPDATAREC DataBase::dbGoNext()
{
	if( _currRec < 15 )
	{
		if( Read( _currRec+1 )  )
			return &_buffer;
		else
			return NULL;
	}
	return NULL;
}


LPDATAREC DataBase::dbGoPrev()
{
	if( _currRec > 1 )
	{
		if( Read( _currRec-1 )  )
			return &_buffer;
		else
			return NULL;
	}
	return NULL;
}


void DataBase::CreateFile()
{
	ofstream fh( dbName, ios::trunc|ios::binary );
	if( fh )
		fh.write( (char *)&sample, sizeof( DATAREC ) * 15 );
	fh.close();
}


void DataBase::OpenFile()
{
	ifh.open( dbName, ios::binary );
	if( ifh )
	{
		_fileOk = TRUE;
		_recCount = 15;
		Read( 1 );
	}
	else
	{
  	ifh.close();
		CreateFile();
		ifh.open( dbName );
		if( ifh )
		{
			_fileOk = TRUE;
			_recCount = 15;
			Read( 1 );
		}
	}
}


BOOL DataBase::Read( int rec )
{
	if( !_fileOk )
		return FALSE;

	long size = (rec-1) * sizeof( DATAREC );
	ifh.seekg( size, ios::beg );
	if( ifh )
	{
		ifh.read( (char *)&_buffer, sizeof( DATAREC ) );
		if( ifh.eof() )
			ifh.clear();
		if( ifh && ifh.gcount() == sizeof( DATAREC ) )
			_currRec = rec;
		else
			return FALSE;
	}
	else
		return FALSE;

	return TRUE;
}


// Miscellaneous functions
BOOL ReadColWidth( LPVLBCOLUMNS data )
{
	BOOL ret = FALSE;
	ifstream ifh( "colwidth.vlb", ios::binary );
	if( ifh )
	{
		ifh.read( (char *)data, sizeof(VLBCOLUMNS) );
		if( !ifh.fail() )
			ret = TRUE;
	}
	ifh.close();
	return ret;
}


BOOL WriteColWidth( LPVLBCOLUMNS data )
{
	BOOL ret = FALSE;
	ofstream ofh( "colwidth.vlb", ios::binary );
	if( ofh )
	{
		ofh.write( (char *)data, sizeof(VLBCOLUMNS) );
		if( ofh )
			ret = TRUE;
	}
	ofh.close();
	return ret;
}


