///////////////////////////////////////////////////////////////////////////
// 									CUSTOM CONTROL COLLECTION KIT
//
//	File Name	: Ccckit.hpp
// 	Author		: Ravi Prakash
//	Date			: September 1994
//	Purpose		: CCCKit API
//
//	1994-95 Sapient Technology, Inc. All Rights Reserved
//
///////////////////////////////////////////////////////////////////////////
#ifndef CCCKIT_HPP
#define	CCCKIT_HPP


// Needed by Resource Workshop

// Virtual List Box Defines
#define VLB_DISPTITLE			1
#define VLB_NOTITLE				0
#define VLB_COLUMNS( x )   ((x) << 1)  // Do not exceed 64
#define VLB_PAGEBUF( x )	((x) << 8)  // Do not exceed 3
#define VLB_SETMULTI( x )	((x) << 10)	// v1.51
// Virtual Scroll Bar Defines
#define	EX_SB_VERTICAL		1
#define	EX_SB_HORIZONTAL	0
// Edit Control Defines
#define EDIT_RAISED				1
#define EDIT_NOTRAISED		0
#define EDIT_REDMINUS			(1 << 1)
#define EDIT_NOREDMINUS		(0 << 1)
#define EDIT_PASSWORD			(1 << 2)
#define EDIT_NOPASSWORD		(0 << 2)
#define EDIT_LENGTH( x )	((x) << 3)	// Not to exceed 64
#define EDIT_TYPETEXT			(0 << 9)
#define EDIT_TYPENUMB			(1 << 9)
#define EDIT_TYPEFLOAT		(2 << 9)
#define EDIT_TYPEDATE			(3 << 9)
#define EDIT_PRECISION( x )	((x) << 11)
#define EDIT_DATEUSLONG		(0 << 13)
#define EDIT_DATEUSSHORT	(1 << 13)
#define EDIT_DATEEUROLONG	(2 << 13)
#define EDIT_DATEEUROSHORT	(3 << 13)
#define EDIT_ALIGNLEFT		(0 << 15)
#define EDIT_ALIGNRIGHT		(1 << 15)
// TAB Control
#define TAB_TOTAL( x )		((x))
#define TAB_TEXTLEN( x )	((x) << 5)
#define	TAB_ONTOP					(0 << 10)
#define	TAB_ONLEFT				(1 << 10)
#define	TAB_ONBOTTOM			(2 << 10)
#define	TAB_ONRIGHT				(3 << 10)
// Static Control
#define STATICDEPRESSED  	0
#define STATICRAISED    	1
#define STATICFLAT	    	2
#define STATICBUMP	    	3
#define STATICBLACK       (0 << 2)
#define STATICWHITE       (1 << 2)
#define STATICRED		      (2 << 2)
#define STATICGREEN       (3 << 2)
#define STATICBLUE				(4 << 2)
#define STATICDKBLUE			(5 << 2)
#define STATICYELLOW			(6 << 2)
#define STATICLEFTALIGN		(0 << 5)
#define STATICCENTERALIGN	(1 << 5)
#define STATICRIGHTALIGN 	(2 << 5)
#define	BOXSTATIC					(0 << 7)
#define	TEXTSTATIC				(1 << 7)
#define	GROUPSTATIC				(2 << 7)
// Button Controls
#define BUTTONBLACK       0
#define BUTTONWHITE       1
#define BUTTONRED		      2
#define BUTTONGREEN       3
#define BUTTONBLUE				4
#define BUTTONDKBLUE			5
#define BUTTONYELLOW			6
#define BUTTONLEFTALIGN		(0 << 3)
#define BUTTONRIGHTALIGN 	(1 << 3)
#define RADIOBUTTON				(0 << 4)
#define CHECKBOXBUTTON		(1 << 4)
#define BUTTONBUTTON			(2 << 4)
#define BDEFPUSHBUTTON		(3 << 4)
#define DIAMONDSHAPE			(0 << 6)
#define ROUNDSHAPE				(1 << 6)
#define CHECKDEPRESS			(0 << 7)
#define CHECKRAISED				(1 << 7)



#ifndef RC_INVOKED

// Functions
#ifdef	__cplusplus
extern "C" {
#endif

WORD CALLBACK _export CCCKitVersion( void ); // HIWORD = major version LOWORD = minor version

#ifdef	__cplusplus
}
#endif


#define	CCCKBASE		WM_USER + 100

/********************  SPIN BOX API  ********************/
#ifdef	__cplusplus
extern "C" {
#endif
// The following structure is passed to the parent window
typedef struct {
	DWORD	hWnd;								// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	float	nVal;								// New value
}SPINMSG, far *LPSPINMSG;
#ifdef	__cplusplus
}
#endif


#define	SPIN_CLICK	CCCKBASE
/*
	This message is sent when the user clicks the spin control or
	has the left mouse button held down.
	Message Cracking
		WPARAM - 0 ignore it
		LPARAM - Pointer to SPINMSG structure.  Make sure you typecast
						 this value to the correct structure.  DO NOT FREE/DELETE
						 this structure.
*/

#define	SPIN_SETLVALUE	CCCKBASE + 1
/*
	Send this message to set the lower range value of the spin control.
	This control tracks the value as a float type.  It uses this lower
	range value to decide when to stop sending messages to the parent.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float.

		Example:
		float lower, higher, step;
		lower = -10.0;
		higher = 10.0;
		step = 0.25;		Each click will increament/decreament by step amount
		SendMessage( whandle, SPIN_SETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_SETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_SETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_SETUVALUE	CCCKBASE + 2
/*
	Send this message to set the upper range value of the spin control.
	This control tracks the value as a float type.  It uses this upper
	range value to decide when to stop sending messages to the parent.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float.

		Example:
		float lower, higher, step;
		lower = -10.0;
		higher = 10.0;
		step = 0.25;		Each click will increament/decreament by step amount
		SendMessage( whandle, SPIN_SETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_SETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_SETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_SETSTEP	CCCKBASE + 3
/*
	Send this message to set the step value.  The step value is used to
	increament (when up arrow button clicked) / decreament (when down
	arrow button clicked) the current value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float.

		Example:
		float lower, higher, step;
		lower = -10.0;
		higher = 10.0;
		step = 0.25;		Each click will increament/decreament by step amount
		SendMessage( whandle, SPIN_SETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_SETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_SETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_GETLVALUE	CCCKBASE + 4
/*
	Send this message to get the lower range value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float

		Example:
		float lower, higher, step;
		SendMessage( whandle, SPIN_GETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_GETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_GETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_GETUVALUE	CCCKBASE + 5
/*
	Send this message to get the upper range value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float

		Example:
		float lower, higher, step;
		SendMessage( whandle, SPIN_GETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_GETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_GETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_GETSTEP		CCCKBASE + 6
/*
	Send this message to get the step value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float

		Example:
		float lower, higher, step;
		SendMessage( whandle, SPIN_GETLVALUE, 0, (LPARAM)&lower );
		SendMessage( whandle, SPIN_GETUVALUE, 0, (LPARAM)&upper );
		SendMessage( whandle, SPIN_GETSTEP, 0, (LPARAM)&step );
*/

#define	SPIN_GETVALUE		CCCKBASE + 7
/*
	Send this message to get the current value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float

		Example:
		float currValue;
		SendMessage( whandle, SPIN_GETVALUE, 0, (LPARAM)&currValue );
*/

#define	SPIN_SETVALUE		CCCKBASE + 8
/*
	Send this message to SET the current value.
	Message Packing
		WPARAM - 0 is ignored
		LPARAM - Pointer to a float

		Example:
		float currValue = 1.5;
		SendMessage( whandle, SPIN_SETVALUE, 0, (LPARAM)&currValue );
*/


#define	SPIN_INFOCUS		CCCKBASE + 9
/*
	Sent to the parent when it receives focus.
	WPARAM - 0 ignore it
	LPARAM - Pointer to SPINMSG structure.  Make sure you typecast
						 this value to the correct structure.  DO NOT FREE/DELETE
						 this structure.
*/

#define	SPIN_OUTFOCUS		CCCKBASE + 10
/*
	Sent to the parent when it looses focus.
	WPARAM - 0 ignore it
	LPARAM - Pointer to SPINMSG structure.  Make sure you typecast
						 this value to the correct structure.  DO NOT FREE/DELETE
						 this structure.
*/


/*
NOTES

The Spin control can be used next to an edit control.  It allows a user
to step through a range of valid numbers.  Since the edit control may
be displaying floating point values ex: margins this control uses a
float type to track ranges and current value.  When you use this control
you need to watch for the SPIN_CLICK message.  When you receive this
message, retreive the SPINMSG struct pointer from LPARAM and use the
'nVal' member to set the new value in your edit control.
You can always retreive all the values you set.  You can at any time
get the current value too.

This is a very simple control to use, take a look at the example
programs.

*********************************************************************/



/********************  SCROLLBAR CONTROL  ********************/

#ifdef	__cplusplus
extern "C" {
#endif
// The following structure is passed to the parent window
typedef struct {
	DWORD	hWnd;								// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	long	nVal;								// New value
}SCROLLMSG, far *LPSCROLLMSG;
#ifdef	__cplusplus
}
#endif


#define	EXSB_VSCROLL	CCCKBASE + 20
#define	EXSB_HSCROLL	CCCKBASE + 21
/*
	Sent to the parent when the current position changes
	EXSB_VSCROLL if its a vertical scrollbar else it sends a
	EXSB_HSCROLL message

	WPARAM - 0 ignore it
	LPARAM - Pointer to SCROLLMSG structure.  Make sure you typecast
					 this value to the correct structure.  DO NOT FREE/DELETE
					 this structure.
*/

#define	EXSB_SETLLIMIT	CCCKBASE + 22
/*
	Send this message to the control when you need to set the
	lower limit

	WPARAM - 0 ignores it
	LPARAM - value
*/

#define	EXSB_SETULIMIT	CCCKBASE + 23
/*
	Send this message to the control when you need to set the
	upper limit

	WPARAM - 0 ignores it
	LPARAM - value
*/

#define	EXSB_GETLLIMIT	CCCKBASE + 24
/*
	Send this message to the control when you need to get the
	lower limit

	WPARAM - 0 ignores it
	LPARAM - 0 ignores it
	LRESULT is sent back which has the value requested
*/

#define	EXSB_GETULIMIT	CCCKBASE + 25
/*
	Send this message to the control when you need to get the
	upper limit

	WPARAM - 0 ignores it
	LPARAM - 0 ignores it
	LRESULT is sent back which has the value requested
*/

#define	EXSB_SETBARPOS	CCCKBASE + 26
/*
	Send this message to the control when you need to set the
	current thumb position

	WPARAM - 0 ignores it
	LPARAM - value
*/

#define	EXSB_GETBARPOS	CCCKBASE + 27
/*
	Send this message to the control when you need to get the
	current thumb position value

	WPARAM - 0 ignores it
	LPARAM - 0 ignores it
	LRESULT is sent back which has the value requested
*/

#define	EXSB_LINEMAG		CCCKBASE + 28
/*
	Send this message to the control when you need to set the
	line magnitude. The amount the thumb should move for each click

	WPARAM - Value
	LPARAM - 0 ignores it
*/

#define	EXSB_PAGEMAG		CCCKBASE + 29
/*
	Send this message to the control when you need to set the
	line magnitude. The amount the thumb should move for each click
	in the bar area/pgup/pgdn

	WPARAM - Value
	LPARAM - 0 ignores it
*/

#define	EXSB_SETFOCUS		CCCKBASE + 30
/*
	Sent to the parent when it receives focus.

	WPARAM - 0 ignore it
	LPARAM - Pointer to SCROLLMSG structure.  Make sure you typecast
					 this value to the correct structure.  DO NOT FREE/DELETE
					 this structure.
*/

#define	EXSB_KILLFOCUS	CCCKBASE + 31		// Sent by scrollbar to parent when it looses focus
/*
	Sent to the parent when it looses focus.

	WPARAM - 0 ignore it
	LPARAM - Pointer to SCROLLMSG structure.  Make sure you typecast
					 this value to the correct structure.  DO NOT FREE/DELETE
					 this structure.
*/



/********************  ListBox Control  ********************/
// Maximum length of each column in a record
#define	MAX_FIELDLEN		64
#define	MAX_TITLELEN		16


// MESSAGES
#define	VLB_SELCHANGE		CCCKBASE + 41
/*
	This message will be sent whenever the user selects a new row as the
	current row.
	WPARAM = 0 ignore it
	LPARAM = pointer to VLBROWDATA structure

	DO NOT DELETE/FREE THIS STRUCTURE.  Use it for any processing you wish
	to do.
*/

#define	VLB_DBLCLK 			CCCKBASE + 42
/*
	This message is sent when the double clicks a line of text in the
	control.
	WPARAM = 0	ignore it
	LPARAM = pointer to VLBROWDATA structure
	When you receive it use the "cNum" member to determine the number of
	columns in the control that need title text.
	The parent window can use this message to start another dialog etc.
*/

#define	VLB_KILLFOCUS		CCCKBASE + 43
/*
	This message is sent when the control looses focus
	WPARAM = 0	ignore it
	LPARAM = HWND window handle of control
*/

#define	VLB_SETFOCUS		CCCKBASE + 44
/*
	This message is sent when the control gains focus
	WPARAM = 0	ignore it
	LPARAM = HWND window handle of control
*/



#define	VLB_SETCOUNT		CCCKBASE + 45
/*
	You must send this message before the control is displayed
	if you want it to display data.
	WPARAM = 0
	LPARAM = Total Number of rows to display - (Total Records)
	If this message is sent more than once then the control will
	clear its internal buffer and send the parent window messages to
	fill up the internal buffer
	Send this message at the start at least once.  After that if the
	number rows to be displayed increases / decreases, send this message
	with the new value for total records.
*/

#define	VLB_GETCOUNT		CCCKBASE + 46
/*
	The parent window can send this message at anytime to determine
	the total rows that this control will be displaying.
	WPARAM = 0	is ignored
	LPARAM = 0	is ignored
	The return value is the LRESULT.  If this value is 0 means that
	you never set the total rows value.
*/

#define	VLB_SETCURSEL		CCCKBASE + 47
/*
	The parent window can send this message at any time to set the
	current row in focus.  If the row number specified is not in the
	buffer, the control will send messages to get the row data.
	WPARAM = 0	is ignored
	LPARAM = New Row number to display
*/

#define	VLB_GETCURSEL		CCCKBASE + 48
/*
	The parent window can send this message at any time to get the
	current row in focus.
	WPARAM = 0	is ignored
	LPARAM = 0	is ignored
	The return value is the LRESULT.  If this value is -1 it means you
	forgot to set the total rows to display
*/

#define	VLB_NEEDRECSTR	CCCKBASE + 49
/*
	This message will be sent to the parent whenever the control needs
	more data to be displayed.
	WPARAM = 0	ignore it
	LPARAM = pointer to VLBROWDATA structure
	When you receive it use the "cNum" member to determine the number of
	columns in the control that need text.
	NOTE - The title string CANNOT EXCCED "MAX_FIELDLEN" (64).
				 When you receive this message you should NOT change
				 any values in the structure except add strings to the
				 cText member. The rowNum value is set internally.  You need
				 to check this value to determine what row data to insert.
				 This number is NOT '0' based! If it is '1' it means the
				 1st row out of n rows.  This value is set just once by the
				 control.  Do NOT CHANGE it.
*/

#define	VLB_NEEDTITLES	CCCKBASE + 50
/*
	This message is sent only once at start up to get the title text
	for each column being displayed.  This message is only sent if
	you have set the Display Titles attribute in the style.
	WPARAM = 0	ignore it
	LPARAM = pointer to VLBTITLES structure
	When you receive it use the "cNum" member to determine the number of
	columns in the control that need title text.
	Note that the title string CANNOT EXCCED "MAX_TITLELEN" (16)
*/


#define	VLB_SETWINBKCOL	CCCKBASE + 51
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	You should send this message if you wish to change the background
	colour of the control window as a whole.  The default is WHITE.
*/


#define	VLB_SETTITLEFGCOL	CCCKBASE + 52
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	You should send this message if you wish to change the foreground
	colour for the titles' text.  The default is BLUE.

	NOTE:
	The titles' background is always LT_GRAY and the 3D raised button is
	always drawn.  You cannot change the titles' background colour!
*/


#define	VLB_SETSELFGCOL	CCCKBASE + 53
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	You should send this message if you wish to change the selected
	rows' foreground colour.  The default is WHITE.
*/

#define	VLB_SETSELBKCOL	CCCKBASE + 54
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	You should send this message if you wish to change the selected
	rows' background colour.  The default is BLUE.
*/

#define	VLB_SETREGFGCOL	CCCKBASE + 55
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	You should send this message if you wish to change the unselected
	row's foreground colour.  The default is BLACK.
	NOTE:
	The background colour of an unselected row is defaulted to the control
	window's background colour so things do not clash.  You cannot set the
	background colour of an unselected row!
*/


#define	VLB_SETDEFAULTCOL	CCCKBASE + 56
/*
	Send this message to the control to change colours.
	WPARAM = 0	is ignored
	LPARAM = COLORREF value
	Send this message if for some reason you want to redraw the whole
	control in the original default colours that it started off with.
*/


#define	VLB_RBUTTONDOWN	CCCKBASE + 57
/*
	Sent by control to parent window
	WPARAM = The column numer it was clicked on.  This is '0' based
	LPARAM = Ignore it
	This message is sent if the user pressed the Right mouse button
	Down.  It is NOT A CLICK just a WM_RBUTTONDOWN.  The WPARAM is a 0
	based value where 0 = 1st column etc.
*/


#define	VLB_GETCOLWIDTH	CCCKBASE + 58
/*
	Send this message to get column width settings
	WPARAM = Ignored
	LPARAM = Pointer to VLBCOLUMNS structure

	Typically the user will adjust the column widths on the fly.  To
	restore this width you need to save it yourself.  Send this message
	and allocate enough memory for LPARAM.
	The Control WILL NOT DELETE/FREE the memory associated with LPARAM.
	In the structure use the cNum as the number of columns, this number
	is the total number of columns.
	The cWidth[] array holds the column widths.
*/

#define	VLB_SETCOLWIDTH	CCCKBASE + 59
/*
	Send this message to set column width settings
	WPARAM = Ignored
	LPARAM = Pointer to VLBCOLUMNS structure

	The Control WILL NOT DELETE/FREE the memory associated with LPARAM.
	In the structure use the cNum as the number of columns, this number
	is the total number of columns.  You should have retrieved this from
	some earlier call to VLB_GETCOLWIDTH.
	The cWidth[] array holds the column widths.  This array will be used
	in a for( i = 0; i < struct->cNum; i++ ).

	The hWnd member is ignored, assuming that you have sent this message
	to the right window.  The control will check to see if the
	cNum == _numColumns(internal) if this is TRUE the column widths will
	be adjusted and the start column will be reset to '0'.
*/


#define	VLB_SETOUTFOCUSFGCOL	CCCKBASE + 60
/*
	Send this message to change the foreground colour of a selected row
	when the control is out of focus.
	WPARAM = Ignored
	LPARAM = COLORREF value

	Send this message to the control if want to change the colour used
	to display a selected row when the control goes out of focus
*/


#define	VLB_GETMULTISEL		CCCKBASE + 61
/*
	Send this message to get the check/selection state for a given row.

	WPARAM = Ignored
	LPARAM = Row number from 1L ... MAXROWS

	LRESULT
		0 = The row is not selected OR
			 The row numer in LPARAM is >= 16384 OR
			 You did not select the 'Allow multiple selection' at design time
		1 = Yes the row number specified is selected
*/


#define	VLB_SETMULTISEL		CCCKBASE + 62
/*
	Send this message to set the check/selection state for a given row.

	WPARAM = Ignored
	LPARAM = Row number from 1L ... MAXROWS

	After it receives this message the control will do a redraw.  If the row
	number you specified is >= 16384 then nothing is going to happen.

	The multi-selection feature only works on the first 16384 rows.
*/


#ifdef	__cplusplus
extern "C" {
#endif

// STRUCTURES REQUIRED TO COMMUNICATE WITH CONTROL
typedef struct {
	DWORD	hWnd;		 		// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	short int	cNum;		// Total Number of Columns or cTitles
	char	**cTitle;		// Titles for each column
} VLBTITLES;
typedef VLBTITLES *LPVLBTITLES;

typedef struct {
	DWORD	hWnd;				// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	long	rowNum;			// The row/record number
	short int	cNum;		// Total Number of Columns or cText - 0 based
	char	**cText;		// Column Data for each column
} VLBROWDATA;
typedef VLBROWDATA *LPVLBROWDATA;

typedef struct {
	DWORD	hWnd;							// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	short int cNum;				 	// Total number of columns - 0 based
	short int	cWidth[ 64 ];	// 128 bytes is not too much
} VLBCOLUMNS;
typedef VLBCOLUMNS *LPVLBCOLUMNS;

#ifdef	__cplusplus
}
#endif


/********************  CALENDAR CONTROL API  ********************/
#ifdef	__cplusplus
extern "C" {
#endif
// The following structure is passed to the parent window
typedef struct {
	DWORD	hWnd;								// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	char	calDate[ 20 ];			// New date value 'November 12, 1994"
	short int	calDow;					// 0 = Sunday, 1= Monday etc.
	short int	calDom;         // Day of month 1 - 31
	short int	calMonth;				// Month 1 = Jan, 2 = Feb etc.
	short int	calYear;				// The year 1994 etc.
}CALMSG, far *LPCALMSG;
#ifdef	__cplusplus
}
#endif


#define	CAL_INFOCUS			CCCKBASE + 69
/*
	Sent to the parent when it receives focus.
	WPARAM - 0 ignore it
	LPARAM - Pointer to CALMSG structure.  Make sure you typecast
					 this value to the correct structure.  DO NOT FREE/DELETE
					 this structure.  Only the hWnd member is valid.  DO NOT
					 USE the values in the remaining members of the structure.
*/

#define	CAL_OUTFOCUS		CCCKBASE + 70
/*
	Sent to the parent when it looses focus.
	WPARAM - 0 ignore it
	LPARAM - Pointer to CALMSG structure.  Make sure you typecast
					 this value to the correct structure.  DO NOT FREE/DELETE
					 this structure.  Only the hWnd member is valid.  DO NOT
					 USE the values in the remaining members of the structure.
*/

#define	CAL_SETDATE			CCCKBASE + 71
/*
	Sent to control when you wish to set the calendar date
	WPARAM - 0 ignore it
	LPARAM - Pointer to a CALMSG structure.  The control WILL NOT
					 FREE the memory associated with the structure.  Use only
					 the following members:
					 calDom		// Day of month 1 - 31
					 calMonth	// Month 1 = Jan, 2 = Feb etc.
					 calYear		// The year 1994 etc.
					 DO NOT USE THE calDate array!

					 You must create an instance of the CALMSG structure and assign
					 its address to the LPARAM parameter.  DO NOT USE THE
					 PostMessage function, use the SendMessage function.
*/

#define	CAL_GETDATE			CCCKBASE + 72
/*
	Sent to control when you wish to get the calendar date
	WPARAM - 0 ignore it
	LPARAM - Pointer to a CALMSG structure.  The control WILL NOT
					 FREE the memory associated with the structure.  The
					 control will fill the structure for you with the current
					 selected date.

					You must create an instance of the CALMSG structure and assign
					its address to the LPARAM parameter.  DO NOT USE THE
					PostMessage function, use the SendMessage function.
*/


#define	CAL_SELCHANGE		CCCKBASE + 73
/*
	This message is sent when the user changes the date in any way
	WPARAM - 0 ignore it
	LPARAM - Pointer to a CALMSG structure.  DO NOT FREE/DELETE
					 this structure.  You will receive this message most often,
					 since the user will change the dates etc.
*/



/********************  TABBED DIALOG CONTROL API  ********************/


#define	TAB_INFOCUS			CCCKBASE + 83
/*
	Sent to the parent when it receives focus.
	WPARAM - 0 ignore it
	LPARAM - Tab Number In Focus.  This is a '0' based number.
					 0 = 1st Tab, 1 = 2nd Tab etc.

*/

#define	TAB_OUTFOCUS 		CCCKBASE + 84
/*
	Sent to the parent when it looses focus.
	WPARAM - 0 ignore it
	LPARAM - 0

*/

#define	TAB_SETTAB			CCCKBASE + 85
/*
	Sent to control when you wish to set the current Tab
	WPARAM - 0 ignore it
	LPARAM - Tab Number In Focus.  This is a '0' based number.
					 0 = 1st Tab, 1 = 2nd Tab etc.

					 Use SendMessage instead of PostMessage.  The LRESULT value
					 returned is 1 if set correctly, 0 if there was an error.
*/

#define	TAB_GETTAB			CCCKBASE + 86
/*
	Sent to control when you wish to get the current Tab
	WPARAM - 0 ignore it
	LPARAM - 0 ignore it

					 Use SendMessage instead of PostMessage.  The LRESULT value
					 returned is a 0 based number. 0 = 1st Tab, 1 = 2nd Tab etc.
*/


#define	TAB_SELCHANGE		CCCKBASE + 87
/*
	This message is sent when the user changes the tab order
	WPARAM - 0 ignore it
	LPARAM - Tab Number In Focus.  This is a '0' based number.
					 0 = 1st Tab, 1 = 2nd Tab etc.
*/

#define	TAB_SETTEXT			CCCKBASE + 88
/*
	Send this msg to the control when you wish to set the Title string
	for each tab.
	WPARAM - 0 ignore it
	LPARAM - Pointer to a NULL terminated string.  This string will have
					 the following format: "Title 1|Title 2|Title 3"
					 The delimiter '|' is very important, the control will use
					 "Title 1" as the text for the 1st tab, it will skip the '|'
					 and use "Title 2" as the text for the 2nd tab etc.
					 Remember that the number of titles you pass should be equal
					 to the number of tabs you have.  The string should NOT end
					 with a '|'.

					 Use SendMessage instead of PostMessage.
*/

#define	TAB_REDRAWONTOP	CCCKBASE + 89
/*
	You can send this message anytime you feel that the TAB control
	has/may overdraw your control(s).  This messages will force the TAB
	control to go and force a repaint of all controls that are on top
	it.

	WPARAM - 0 ignored
	LPARAM - 0 ignored

	USE ONLY IF NEEDED - Could cause flicker if there are many controls on
	top.
*/

#define	TAB_TOGGLETAB		CCCKBASE + 90      
/*
	You can send this message anytime you want to disable/enable a
	single TAB selection.

	WPARAM - 0 = DISABLE  1 = ENABLE
	LPARAM - TAB number.  This is 0 based.  0 = 1st Tab 1 = 2nd Tab etc.

	RETURN - 1 if done else 0.

	Just remember that the TAB number is 0 based.

	SITUATIONS WHEN A 0 IS RETURNED
	- Tab number is out of range
	- The Tab you are trying to disable happens to be the last enabled
		Tab. The control will not allow every single TAB to be disabled.
		There has to be atleast 1 TAB that is enabled.
*/


/********************  EDIT CONTROL API  ********************/

#ifdef	__cplusplus
extern "C" {
#endif
// The following structure is passed to the parent window
typedef struct {
	DWORD	hWnd;								// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	char	editTxt[ 65 ];			// Array for text, DO NOT CHANGE THE SIZE
}EDITMSG, far *LPEDITMSG;
#ifdef	__cplusplus
}
#endif

/*
												MASK TYPES

CharMask	= 'A'
	Any character can be entered by the user.

UpperMask	= '!'
	Any alphabet character can be entered by the user and it will be
	converted to upper case.

NumbMask	= '#'
	Any number from 0-9 can be entered

How To Use Them
---------------
Regular Text is the only data type that will allow you to change its
mask.  Example below illustrates how it works.

		In RW select this data type and specify the length of the string
		INCLUDING any format characters i.e. '(',')','-' etc.

		Send a message to set the mask.
		ex: (###)###-#### or ###-##-#### or ###-!##-!!## etc.
		Any character that is not one of the three above mask characters
		will be inserted litterally in the same position.  So a mask for
		a USA telephone number will become (___)___-____.  If the user
		enters only the area code i.e. (703)___-____ and you send a
		message to GetText then the string you will get back will look
		like : "(703)   -    "

*/

/*
												CUT/COPY/PASTE
This control allows you to cut and copy regardless of data type.  The
only limitation is when you paste.  You can only paste into a control
with "Regular Text" type with no mask.  When you paste the data it will
overwrite the data in the control from the point of the caret.  This
limitation is due to the fact that this control has a size limit on the
text regardless of data type.

*/


#define	EDIT_INFOCUS		CCCKBASE + 98
/*
	Sent to the parent when it receives focus.
	WPARAM - 0 ignore it
	LPARAM - 0 ignore it

*/

#define	EDIT_OUTFOCUS		CCCKBASE + 99
/*
	Sent to the parent when it looses focus.
	WPARAM - 0 ignore it
	LPARAM - 0 ignore it

*/

#define	EDIT_GETTEXT		CCCKBASE + 100
/*
	Send this message to the control when you wish to get the data
	in this control
	WPARAM - 0 ignored
	LPARAM - Should point to a EDITMSG structure.
					 The control will fill up the structure for you.

	RETURN - Always (LRESULT)1

*/

#define	EDIT_SETTEXT		CCCKBASE + 101
/*
	Send this message to the control when you wish to set the data for
	this control
	WPARAM - 0 ignored
	LPARAM - Pointer to EDITMSG structure.
					 This pointer WILL NOT BE deleted/freed for you.
					 The control will use the data pointed to by this pointer
					 to fill in the control.
					 Since this control is a special type of Edit Control the
					 inserting of data and setting of data is handled in a
					 different way.
					 Data is never inserted but overwritten.
					 The setting of data is based on whether or not there is
					 a mask set for this instance of the control.
					 When you place this control in a dialog box using RW, a
					 default mask is set for it.  You can change it if the data
					 type is "Regular Text".  You cannot change it if the data
					 type is "Numeric", "Float" or "Date".  These data types
					 have a fixed mask.  In the case of "Numeric" and "Float"
					 you have to specify (in RW) the total length of the string
					 including the places after the decimal, but excluding the
					 '.', ',' and '-' signs.
					 So if you want your end result not to exceed "999,999.99"
					 set the length to '8'.

	RETURN - (LRESULT)1 = SUCCESS		(LRESULT)0 = FAILURE

	Example:

	DataType		   Mask   		EDIT_SETTEXT Data		Result
	-----------------------------------------------------
	RegularText		#####-####		"22011"						"22011-____"
															"2211-ABC81"			"22118-1___"
															"220113832"				"22011-3832"

	RegularText		AAA-AAA				"A2B-220"					"A2B-220"
															"12-DF45"					"12--DF4"
																								The extra '-' is because
																								of the '-' character
																								is a any character. In a case
																								like this you have to be
																								extra careful.
															"12F-45"					"12F-45__"
															"12FD43"					"12F-D43"

	In all cases regardless of the format in which you send the data, the
	end result will be fine.  There is only one(1) exception to this rule
	which is illustrated in the "12-DF45" case.

*/


#define	EDIT_GETMASK		CCCKBASE + 102
/*
	Send this message to the control when you wish to get the mask
	being used in this control
	WPARAM - 0 ignored
	LPARAM - Should point to a EDITMSG structure.
					 The control will fill up the structure for you.
					 In this case it will copy the mask string into
					 the 'editTxt' array

	RETURN - Always (LRESULT)1

*/


#define	EDIT_SETMASK		CCCKBASE + 103
/*
	Send this message to the control when you wish to set the mask
	being used in this control
	WPARAM - 0 ignored
	LPARAM - Should point to a EDITMSG structure.
					 This pointer WILL NOT BE deleted/freed for you.
					 In this case it will use the mask string stored
					 the 'editTxt' array

	RETURN - Always (LRESULT)1

*/


#define	EDIT_NUMFORMAT	CCCKBASE + 104
/*
	Send this message to the control if you wish to toggle the use
	of the thousand separator ',' for NUMERIC DATA TYPES.  You can not
	set this property at design time because there is no more space in
	the design data struture.
	WPARAM - If set to 1 = Use ','  0 = Do not use ','
					 Default is '1' - Use ','
	LPARAM - 0 ignored

	RETURN - 1 = Success  0 = Failure because the control is not of
							 NUMERIC DATA TYPE.

	There are times when you might want to display a NUMERIC number
	without the ',' thousand separator, send this message for those times.

	This message will erase the current data, change the buffer size etc.
	So if you wish to display data send a EDIT_SETTEXT message after this
	call.

*/


#define	EDIT_READONLY		CCCKBASE + 105
/*
	Send this message to toggle the field as a READ-ONLY or READWRITE
	field.  You should be able to send this message any time you wish,
	the advantage to this is that text will still be displayed in
	dark black instead of a disabled gray.

	WPARAM - If set to 1 = READONLY  0 = READ-N-WRITE
					 Default is '0' - READ-N-WRITE
	LPARAM - 0 ignored

	RETURN - 1L always

*/


/********************  BUTTON CONTROL API  ********************/

#define	BUTTON_ISCCCKITRADIO		CCCKBASE + 115
/*
	This message is used internally to determine if this button
	belongs to the CCCKIT family.  It only works if the control is a
	Radio Button.

	WPARAM - 0 ignored

	LPARAM - 0 ignored

	RETURN - 1993L if it is us, else the value is undetermined

*/

#define	BUTTON_ISCCCKITCHECK		CCCKBASE + 116
/*
	This message is used internally to determine if this button
	belongs to the CCCKIT family.  It only works if the control is a
	CheckBox Button.

	WPARAM - 0 ignored

	LPARAM - 0 ignored

	RETURN - 1993L if it is us, else the value is undetermined

*/


#define	BUTTON_INFOCUS		CCCKBASE + 117
/*
	This message is sent when it receives a WM_SETFOCUS

	WPARAM - (HWND)wParam = Control Window

	LPARAM - 0 ignored

*/


#define	BUTTON_KILLFOCUS		CCCKBASE + 118
/*
	This message is sent when it receives a WM_SETFOCUS

	WPARAM - (HWND)wParam = Control Window

	LPARAM - 0 ignored

*/


/********************  COMBOBOX CONTROL API  ********************/
#ifdef	__cplusplus
extern "C" {
#endif
typedef struct {
	DWORD	hWnd;				// Controls Handle - If Win3.x use (HWND)LOWORD(hWnd) else use(HWND)hWnd
	long	rowNum;			// The row/record number
	char	*cText;			// Points to a char[] of MAXFIELDLEN(64) + 1
} VCOMBODATA;
typedef VCOMBODATA *LPVCOMBODATA;
#ifdef	__cplusplus
}
#endif

#define	VCOMBO_NEEDDATA		CCCKBASE + 128
/*
	This message is sent when the control needs fresh data to display

	WPARAM - 0 ignored

	LPARAM - Pointer to a VCOMBODATA structure.
					 The cText should be filled up with the relevant data
					 for row# 'rowNum'.  The row numbers are 1 based so 1 means
					 the first record.  NEVER DELETE/FREE THIS STRUCTURE.

	RETURN - You must return 1 if Ok else a 0.

	NOTE - The cText string CANNOT EXCCED "MAX_FIELDLEN" (64).
				 When you receive this message you should NOT change
				 any values in the structure except add strings to the
				 cText member. The rowNum value is set internally.  You need
				 to check this value to determine what row data to insert.
				 This number is NOT '0' based! If it is '1' it means the
				 1st row out of n rows.  This value is set just once by the
				 control.  Do NOT CHANGE it.
*/

#define	VCOMBO_GETCURSEL		CCCKBASE + 129
/*
	This message can be sent at any time to determine which record
	number is the currently selected number.

	WPARAM - 0 ignored

	LPARAM - 0 ignored

	RETURN - Long value that will be >= 1L if successful.  A return of
					 <=0L means i) An error ii) Max rows was set to 0L, therefore
					 there are no rows.
*/

#define	VCOMBO_SETCURSEL		CCCKBASE + 130
/*
	This message can be sent at any time to set the current row in this
	control.  By doing so it will check to see if the row is present in
	its internal buffer if not it will send VCOMBO_NEEDDATA message(s).
	It will then insert the new row data into the control on top.

	WPARAM - 0 ignored

	LPARAM - A long value must be >= 1L AND <= MAXROWS

	RETURN - 1L always

*/


#define	VCOMBO_INFOCUS		CCCKBASE + 131
/*
	This message is sent when the control is in focus

	WPARAM - (HWND)wParam = Control Window

	LPARAM - 0 ignore it

	RETURN - Any value you wish

*/

#define	VCOMBO_KILLFOCUS		CCCKBASE + 132
/*
	This message is sent when the control is out of focus

	WPARAM - (HWND)wParam = Control Window

	LPARAM - 0 ignore it

	RETURN - Any value you wish

*/


#define	VCOMBO_GETCOUNT		CCCKBASE + 133
/*
	You can send this message to query the MAX rows that this control
	will use

	WPARAM - 0 ignored

	LPARAM - 0 ignored

	RETURN - A long value that will be = to _totalRows.  If it is 0L
					 It means you forgot to set the maximum rows in this control

*/


#define	VCOMBO_SETCOUNT		CCCKBASE + 134
/*
	You must send this message at least once after the control has been
	created.  This message is needed to know how many rows you will be using
	in this control

	WPARAM - 0 ignored

	LPARAM - A long value indicating the total rows you want this control
					 to handle.  This value should be 1 based.  If you are using
					 a database Table to display zip codes for example and the
					 total rows in your table is 50,000, then this value should
					 also be 50,000.  Remember that this control treats all rows
					 on a 1based system to be in line with databases.

	RETURN - 1L always

*/

#define	VCOMBO_SELCHANGE		CCCKBASE + 135
/*
	You will receive this message whenever the user changes the current
	row.

	WPARAM - 0 ignored

	LPARAM - A pointer to VCOMBODATA structure

	DO NOT FREE/DELETE THIS STRUCTURE.  Use it to do any processing
  you wish.
*/

#define	VCOMBO_CHAR		CCCKBASE + 136
/*
	You will receive this message whenever the user types in a character
	whose value >= 32 (0x20) AND value <= 127(0x7F)

	WPARAM - (int)value of key

	LPARAM - ignore it

	We send this message to the parent window to allow it to do its own
	data search.  Since this control does not have all the data in its
	buffer, there is no way to know if infact there is a row whose 1st
	character is == (int)WPARAM.  To do that it would have to start from
	the	top and send a message for each row to do its searching.  If you
	did not wish to do that it would be a waste of time.

	Its faster for you to do the searching and key matching, since you
	have control of the original data.  If you are using ODBC/SQL all it
	would take is a search for x column whose 1st char is == (int)WPARAM.
*/



#endif // RC_INVOKED

#endif