////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: TestTab.hpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class to demonstrate Tab Control
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#ifndef __TESTTAB__H
#define __TESTTAB__H
#include "dialog.hpp"
#include "resload.hpp"
#include "samplapp.rh"


#define	DLG_EXIT_TABTOP		WM_USER + 13004
#define	DLG_EXIT_TABLEFT	WM_USER + 13008
#define	DLG_EXIT_TABBOT		WM_USER + 13009
#define	DLG_EXIT_TABRIGHT	WM_USER + 13010

// If you are wondering why the structs have large fillers :
// Under NT its faster to have 64 byte alignment
// If not it takes longer, because the system generates an exception
// which forces the system to then adjust for the unalignment
// BOOLs are basically ints which are 4 bytes under NT
struct ClientInfoXfer {
	char    FName[ 16 ];
	char    LName[ 16 ];
	char    Address[ 40 ];
	char    DOB[ 11 ];
	char    SSN[ 12 ];
	char		Filler[ 33 ];
};


struct ClientSurveyXfer {
	BOOL    SMagazine;
	BOOL    SFriend;
	BOOL    SCatalog;
	BOOL    SRadio;
	char  	SState[ 6 ][ 3 ];
	int			LastState;
	char    SZip[ 11 ];
	char    SPhone[ 14 ];
	char    SIncome[ 12 ];	// 9 bytes + 1 for '-' + 1 for '.' + 1 for NULL
#if defined(__WIN32__) || defined(__FLAT__)
	char		Filler[ 53 ];
#else
	char		Filler[ 15 ];
#endif
};


struct ClientCreditXfer {
	char  	CrCard[ 4 ][ 24 ];
	int			LastCard;
	BOOL    CrBad;
	BOOL    CrFair;
	BOOL    CrGood;
	BOOL    CrExel;
	char    CrLimit[ 12 ]; // 9 bytes + 1 for '-' + 1 for '.' + 1 for NULL
	char    CrNum[ 20 ];
#if defined(__WIN32__) || defined(__FLAT__)
	char		Filler[ 28 ];
#else
	char		Filler[ 6 ];
#endif
};



class TestTab : public Dialog {
	HWND	_tab, _centre;
	HWND 	_fn, _ln, _add, _dob, _ssn;
	HWND 	_szip, _sphone, _sincome, _sstate;
	HWND 	_crlimit, _crnum, _crcard;

	int   item1, item2, item3;
  UINT	retMsg;

	ResourceLoader  *_rcLoad;

	// Structures for transfering data
	ClientInfoXfer ClInfo;
	ClientSurveyXfer ClSurvey;
	ClientCreditXfer ClCredit;

public:
	TestTab( HWND, HINSTANCE, int );
	~TestTab();

	BOOL WmInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam);
	BOOL HandleUserMsg( HWND, UINT, WPARAM, LPARAM );
	void WmCommand( HWND, int, HWND, UINT );

private:
	void	ManageClInfo( BOOL );
	void	ManageClSurvey( BOOL );
	void	ManageClCredit( BOOL );

protected:
	TestTab( const TestTab& );
	const TestTab& operator=( const TestTab& );

};


#endif
