////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Testlbox.cpp
//	Date				: March 14, 1995
//	Remarks			: Dialog class to demonstrate Virtual List Box Control
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////
#include "testlbox.hpp"
#include <ccckit.hpp>


TestListBox::TestListBox( HWND w, HINSTANCE inst, int id )
			:	Dialog( w, inst, id )
{
	_db = 0;
	_dBase = new DataBase();
	if( _dBase )
		_dBase->InitDb();
	_colWidth = new VLBCOLUMNS;
}


TestListBox::~TestListBox()
{
	SendMessage( _lbox, VLB_GETCOLWIDTH, (WPARAM)0, (LPARAM)_colWidth );
	WriteColWidth( _colWidth );
	if( _dBase )
		delete _dBase;
	if( _colWidth )
		delete _colWidth;
}


BOOL TestListBox::WmInitDialog(HWND hwnd, HWND cw, LPARAM lp )
{
	Dialog::WmInitDialog( hwnd, cw, lp );
	_lbox = GetDlgItem( hwnd, IDC_LISTBOX );
	// Edit controls
	_fn	= GetDlgItem( hwnd, IDC_FNAME );
	_ln 	= GetDlgItem( hwnd, IDC_LNAME );
	_add	= GetDlgItem( hwnd, IDC_ADDRESS );
	_city	= GetDlgItem( hwnd, IDC_CITY );
	_state= GetDlgItem( hwnd, IDC_STATE );
	_zip 	= GetDlgItem( hwnd, IDC_ZIP );

	RegisterUserMsg( VLB_NEEDRECSTR );
	RegisterUserMsg( VLB_NEEDTITLES );
	RegisterUserMsg( VLB_SELCHANGE );
	RegisterUserMsg( VLB_RBUTTONDOWN );

	COLORREF cref = RGB( 255, 100, 0 );
	SendMessage( _lbox, VLB_SETCOUNT, (WPARAM)0, (LPARAM)15 );
	SendMessage( _lbox, VLB_SETCURSEL, (WPARAM)0, (LPARAM)1 );
	// This changes the color of unfocus control text color
	SendMessage( _lbox, VLB_SETOUTFOCUSFGCOL, (WPARAM)0, (LPARAM)cref );

	// Read Last column width settings
	if( ReadColWidth( _colWidth ) )
		SendMessage( _lbox, VLB_SETCOLWIDTH, (WPARAM)0, (LPARAM)_colWidth );

	// Manage dbase
	if( _dBase )
		_db = _dBase->dbGoTop();
	MoveToBuffer();

	return TRUE;
}


BOOL TestListBox::HandleUserMsg( HWND hwnd, UINT m, WPARAM wp, LPARAM lp )
{
	if( m == VLB_NEEDRECSTR )
	{
		_lbData = (LPVLBROWDATA)lp;
		if( _dBase )
		{
			_db = _dBase->dbGetRec( (int)_lbData->rowNum );
			if( _db )
			{
				lstrcpy( _lbData->cText[ 0 ], _db->FName );
				lstrcpy( _lbData->cText[ 1 ], _db->LName );
				lstrcpy( _lbData->cText[ 2 ], _db->Address );
				lstrcpy( _lbData->cText[ 3 ], _db->City );
				lstrcpy( _lbData->cText[ 4 ], _db->State );
				lstrcpy( _lbData->cText[ 5 ], _db->Zip );
			}
		}
		return TRUE;
	}

	if( m == VLB_NEEDTITLES )
	{
		LPVLBTITLES _lbTData = (LPVLBTITLES)lp;
		lstrcpy( _lbTData->cTitle[ 0 ], "First Name" );
		lstrcpy( _lbTData->cTitle[ 1 ], "Last Name" );
		lstrcpy( _lbTData->cTitle[ 2 ], "Address" );
		lstrcpy( _lbTData->cTitle[ 3 ], "City" );
		lstrcpy( _lbTData->cTitle[ 4 ], "State" );
		lstrcpy( _lbTData->cTitle[ 5 ], "Zip" );
		return TRUE;
	}

	if( m == VLB_SELCHANGE )
	{
		EDITMSG editMsg;
		_lbData = (LPVLBROWDATA)lp;
		lstrcpy( editMsg.editTxt, _lbData->cText[ 0 ] );
		SendMessage( _fn, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _lbData->cText[ 1 ] );
		SendMessage( _ln, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _lbData->cText[ 2 ] );
		SendMessage( _add, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _lbData->cText[ 3 ] );
		SendMessage( _city, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _lbData->cText[ 4 ] );
		SendMessage( _state, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _lbData->cText[ 5 ] );
		SendMessage( _zip, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		return TRUE;
	}

	if( m == VLB_RBUTTONDOWN )
	{
		char tmp[ 42 ];
		wsprintf( tmp, "Right Click In Column -> %d", (int)wp );
		MessageBox( hwnd, tmp, "Right Button Click", MB_OK );
		return TRUE;
	}

	return FALSE;
}


void TestListBox::WmCommand( HWND, int id, HWND, UINT )
{
	if( id == IDOK || id == IDCANCEL )
		PostMessage( GetParent(), DLG_EXIT_LBOX, (WPARAM)0, (LPARAM)0 );

	if( id == IDC_CHECK )
	{
		long i =	SendMessage( _lbox, VLB_GETCURSEL, (WPARAM)0, (LPARAM)0 );
		if( SendMessage( _lbox, VLB_GETMULTISEL, (WPARAM)0, (LPARAM)i ) == 0L )
			SendMessage( _lbox, VLB_SETMULTISEL, (WPARAM)0, (LPARAM)i );
	}

	if( id == IDC_UNCHECK )
	{
		long i =	SendMessage( _lbox, VLB_GETCURSEL, (WPARAM)0, (LPARAM)0 );
		if( SendMessage( _lbox, VLB_GETMULTISEL, (WPARAM)0, (LPARAM)i ) == 1L )
			SendMessage( _lbox, VLB_SETMULTISEL, (WPARAM)0, (LPARAM)i );
	}
}


void TestListBox::MoveToBuffer()
{
	EDITMSG editMsg;
	if( _db )
	{
		lstrcpy( editMsg.editTxt, _db->FName );
		SendMessage( _fn, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _db->LName );
		SendMessage( _ln, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _db->Address );
		SendMessage( _add, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _db->City );
		SendMessage( _city, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _db->State );
		SendMessage( _state, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		lstrcpy( editMsg.editTxt, _db->Zip );
		SendMessage( _zip, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
	}
	else
	{
		lstrcpy( editMsg.editTxt, "" );
		SendMessage( _fn, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		SendMessage( _ln, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		SendMessage( _add, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		SendMessage( _city, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		SendMessage( _state, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		SendMessage( _zip, EDIT_SETTEXT, (WPARAM)0, (LPARAM)&editMsg );
		MessageBox( GetWnd(), "Unable to get data from sample.db", "ERROR", MB_OK );
		SendMessage( _lbox, VLB_SETCOUNT, (WPARAM)0, (LPARAM)0 );
	}
}


