////////////////////////////////////////////////////////////////////////
//	Application	: Sample16.exe and Sample32.exe
//	File Name		: Main.hpp
//	Date				: March 14, 1995
//	Remarks			: This file has the main code for winmain and the main
//								window.  The code is written using message crakers
//								allow for 16bit and 32bit compiles.
////////////////////////////////////////////////////////////////////////
//	COPYRIGHT
//  	Sapient Technology, Inc.
//  	Copyright  1994, 1995. All Rights Reserved.
//	AUTHOR
//  	Ravi Prakash
////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "dialog.hpp"
#include "samplapp.rh"


class MainWindow {
	HWND	hWnd;

public:
	MainWindow();
	~MainWindow();
	int	GetStatus() const { return ( hWnd ? 1 : 0 ); }
	HWND GetMainWnd() const { return hWnd; }

	// Default proc for each instance if needed
	static LRESULT WINAPI WndProc( HWND, UINT, WPARAM, LPARAM );

	// Public
	HINSTANCE ccck;

protected:
	MainWindow( const MainWindow& );
	const MainWindow& operator=( const MainWindow& );
};


class AboutDlg : public Dialog {
public:
	AboutDlg( HWND, HINSTANCE, int );
	~AboutDlg();

	// We take control here
	void WmCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
	BOOL WmInitDialog(HWND hwnd, HWND cw, LPARAM lp );

protected:
	AboutDlg( const AboutDlg& );
	const AboutDlg& operator=( const AboutDlg& );
};


class CCCKPriceDlg : public Dialog {
public:
	CCCKPriceDlg( HWND, HINSTANCE, int );
	~CCCKPriceDlg();

	// We take control here
	void WmCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);

protected:
	CCCKPriceDlg( const CCCKPriceDlg& );
	const CCCKPriceDlg& operator=( const CCCKPriceDlg& );
};



