                /*ͻ
                  C Easy buttons.c Menu Sample 
                 */

#include "\ceasy\ceasy1.h"
#include "\ceasy\ceasy2.h"

char *GetString(), *GetString2();

struct
{
 int pix;
 int width;
 int height;
 int row;
 int column;
 char *msg;
 char *program;
}
 button[50];

int buttons;
char *pointer;

int main(argc,argv)
int argc;
char *argv[];
{
 FILE *fptr;
 char buffer[100];
 int x;
 int OVERLAY;
 char *token;
 char filename[11];

 start_program();

 set_graphics_mode (ON);
 clear_screen (FGND_BLUE, FGND_BLUE);
 set_color(FGND_YELLOW); set_color(BKGND_BLUE);
 cursor(2,30); see("C Easy Button Sample");
 set_color (BKGND_BLACK);
 OVERLAY=OFF;
 if((fptr=xopen("buttons.ovl","r"))!=NULL)
  {
   fclose(fptr);
   restore_overlay("buttons",".ovl");
   OVERLAY=ON;
  }
 strcpy(filename,"buttons.dta");
 if(argc==2)
  {
   filename[10]=*argv[1];
  }
 if((fptr=xopen(filename,"r"))==NULL)
  {
   display_error("buttons definition file missing",NULL);
   set_graphics_mode(OFF);
   stop_program(0);
  }
 else
  {
   buttons=0;
   while(fgets(buffer,80,fptr)!=NULL)
    {
     CreateButton(buttons,buffer);
     buttons++;
    }
   fclose(fptr);
  }

// NOTE: YOU MUST DELETE buttons.ovl WHENEVER YOU CHANGE BUTTON DEFINITIONS.
//       THE OVERLAY FILE REFLECTS THE LAST ACCESSED BUTTONS (button.dt?).
 if(OVERLAY==OFF)
  {
   for(x=0; x<buttons; x++)
    {
     DisplayButton(x);
     ButtonOnOff(x,OFF);
     DisplayButtonMsg(x,OFF);
    }
   IGNORE_BLACK=ON;
   put_token(read_token("c_easy.tok"),360,130);
   IGNORE_BLACK=OFF;
   save_overlay("buttons",".ovl");
  }
 if(buttons>50) buttons=50;
 mouse_cursor(480-128,640/2);
 show_mouse_cursor();
 while(1)
  {
   if ( mouse_button_down ( LEFT_BUTTON ) && (x=HotSpot()) )
    {
     hide_mouse_cursor ();
     ButtonOnOff (x-1, ON);
     DisplayButtonMsg (x-1, ON);
     show_mouse_cursor();
     while (mouse_button_down(LEFT_BUTTON) && x==HotSpot());
     if(x==HotSpot())
      {
       set_graphics_mode (OFF);
       compare(button[x-1].program,"exit",4);
       if(NOT_EQUAL)
          call_program(button[x-1].program,NULL);
       set_graphics_mode (OFF);
       stop_program();
      }
     else
      {
       hide_mouse_cursor();
       ButtonOnOff (x-1, OFF);
       DisplayButtonMsg(x-1,OFF);
       show_mouse_cursor();
      }
    }
  }
}

int DisplayButton (x)
int x;
{
 int width, height, row, column;
 int rowcnt, colcnt;

 for(rowcnt=button[x].height,row=button[x].row; rowcnt; rowcnt--,row++)
  {
   for(colcnt=button[x].width, column=button[x].column;
       colcnt; colcnt--, column++)
      put_pixel(button[x].pix, row, column);
  }
 return(0);
}

int DisplayButtonMsg (x, status)
int x, status;
{
 int line, column;

 line   = (button[x].row+button[x].height/2)/16+1;
 column = button[x].column/8+2;
 if(button[x].pix < 8)
    BKGND_GRAPHIC=button[x].pix+30;
 else
    BKGND_GRAPHIC=button[x].pix+40-8;
 if(status)  set_color(FGND_BLUE+1);
 else        set_color(FGND_LIGHT_BLUE+1);
 cursor(line, column);
 see(button[x].msg);
 return(0);
}

int ButtonOnOff(x,status)
int x, status;
{
 int width, height, row, column;
 int rowcnt, colcnt;
 int depth;

 for ( depth=3; depth; depth--)
  {
   for ( colcnt = button[x].width,
            row = button[x].row+depth-1,
         column = button[x].column; colcnt; colcnt--, column++ )
    {
     if ( status == OFF) put_pixel ( FGND_WHITE-32, row, column );
     else                put_pixel ( 0, row, column );
    }
  }
 for ( depth=3; depth; depth-- )
  {
   for ( colcnt = button[x].width,
            row = button[x].row + button[x].height-depth,
         column = button[x].column; colcnt; colcnt--, column++)
    {
     if ( status == ON ) put_pixel ( FGND_WHITE-32, row, column );
     else                put_pixel ( 0, row, column );
    }
  }
 for( depth=3; depth; depth-- )
  {
   for ( rowcnt  = button[x].height,
            row  = button[x].row,
          column = button[x].column+depth-1; rowcnt; rowcnt--, row++ )
    {
     if ( status == OFF ) put_pixel( FGND_WHITE-32, row, column );
     else                 put_pixel ( 0, row, column );
    }
  }
 for ( depth=3; depth; depth-- )
  {
   for ( rowcnt = button[x].height,
            row = button[x].row,
         column = button[x].column+button[x].width-depth;
         rowcnt; rowcnt--, row++ )
    {
     if ( status == ON ) put_pixel ( FGND_WHITE-32, row, column );
     else                put_pixel ( 0, row, column );
    }
  }
 return(0);
}

int CreateButton(x,buffer)
int x;
char *buffer;
{
 pointer=buffer;
 button[x].pix    = atoi (GetString());
 button[x].width  = atoi (GetString()) * 8;
 button[x].height = atoi (GetString()) * 16;
 button[x].row    = atoi (GetString()) * 16;
 button[x].column = atoi (GetString()) * 8;
 button[x].msg    = GetString2();
 button[x].program= GetString();
 return(0);
}

int HotSpot()
{
 int x;
 for ( x=0; x < buttons; x++ )
  {
   get_mouse_position();
   if ( MOUSE_ROW    > button[x].row &&
        MOUSE_ROW    < button[x].row+button[x].height &&
        MOUSE_COLUMN > button[x].column &&
        MOUSE_COLUMN < button[x].column+button[x].width
      )
     return(x+1);
  }
 return(0);
}

char *GetString()
{
 int x;
 char *i;

 i=pointer;
 if(*i!=SPACE)
  {
   for(x=40; *i!=SPACE && x; x--, i++);
  }
 for(x=40; *i==SPACE && x; x--, i++);
 pointer=i;
 return(make_string(i,40));
}

char *GetString2()
{
 char *i, *j;
 int x;

 GetString();
 i=pointer;
 x=0;
 if(*i=='"')
  {
   pointer++;
   i=pointer;
   for(;*i==SPACE && x<10;i++,x++);
  }
 for(;x<40;x++,i++)
  {
   compare(i,"  ",2);
   if(EQUAL)
    {
     *i=0;
     break;
    }
  }
 j=Malloc(x+1);
 strcpy(j,pointer);
 pointer=i-1;
 return(j);
}
