//**************************************************************************
//
//  Title: BASE.C
//
//  Author: Jim Cash
//  Version: 1.2
//  Revision History:
//    Original version: June 5, 1990
//    v1.1: February 13, 1991
//    v1.2: June 21, 1991
//
//  LAB #01
//
//  Purpose:
//      This is LAB00 plus a demonstration of the use of the DEBUG macro
//      to display the contents of the WinMain parameters.
//
//**************************************************************************
#define DEBUGGING
#define _WINDOWS
#include <WINDOWS.H>
#include "BASE.H"


//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
    DEBUG("\r\nLAB #01: Sample Name\r\n",0)
    DEBUG("----  Application Initiated  ----\r\n",0)
    DEBUG("hInstance = %04x\r\n",hInstance)
    DEBUG("hPrevInstance = %04x\r\n",hPrevInstance)
    DEBUG("lpszCmdLine = %s\r\n",lpszCmdLine)
    DEBUG("nCmdShow = %04x\r\n",nCmdShow)

    return TRUE;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{

    return 0;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\r\n",0)
}

