/*
 * Copyright (c) 1988
 * by CompuServe Inc., Columbus, Ohio
 *
 * ABSTRACT:
 * 	Common Definitions
 *
 * ENVIRONMENT: n/a
 *
 * AUTHOR: Steve Wilhite
 *
 * REVISION HISTORY: $Log:   C:/HMI/TOOLBOX/VCS/COMDEF.H_V  $
 *
 *    Rev 1.2   28 Jun 1988 13:17:16   S.Wilhite
 * Added PASCAL, FAR, and NEAR macros.
 * 
 *    Rev 1.1   13 Apr 1988 14:58:32   S.Wilhite
 * clean-up Mac stuff.
 *
 *    Rev 1.0   11 Apr 1988  8:50:36   Admin
 * Initial revision.
 *
 */

#ifndef COMDEF_H
#define COMDEF_H	1

#define STDC		1

#ifdef __TURBOC__
#define MSDOS
#endif

#ifdef MSDOS				/* MSC */

    #ifndef NULL
	#if (!defined(M_I86CM) && !defined(M_I86LM))
	    #define NULL	0		/* 16-bit ptr */
	#else
	    #define NULL	0L		/* 32-bit ptr */
	#endif
    #endif

    #define PASCAL	pascal
    #define FAR		far
    #define NEAR	near

#endif /* MSDOS */

#ifdef macintosh			/* MPW C */
    #include <Types.h>
#endif /* macintosh */

#define LINT_ARGS	1		/* enable argument type checking */

/* Standard data types */

typedef char		BYTE;		/* signed 8-bit integer */
typedef unsigned char	UBYTE;		/* unsigned 8-bit integer */
typedef short		WORD;		/* signed 16-bit integer */
typedef unsigned short	UWORD;		/* unsigned 16-bit integer */
typedef long		LONG;		/* signed 32-bit integer */
typedef unsigned long	ULONG;		/* unsigned 32-bit integer */

/* A few useful constants */

#ifdef macintosh

    #define BOOL		Boolean
    #define TRUE		true
    #define FALSE		false

#else /* not macintosh */

    typedef unsigned short	BOOL;		/* (FALSE, TRUE) */
    #define TRUE		1
    #define FALSE		0

#endif

#define Success		1
#define Failure		0

#define private		static
#define public
#define then

#define and		&&
#define or		||
#define not		!
#define mod		%
#define xor		^

#ifndef min
#define min(x, y)	((x) < (y) ? (x) : (y))
#define max(x, y)	((x) > (y) ? (x) : (y))
#endif

#endif
