
/************************************************************************
 *									*
 *  Copyright (c) 1987							*
 *  by CompuServe Incorporated, Columbus, Ohio				*
 *									*
 *  The information in ths software is subject to change without	*
 *  notice and should not be construed as a commitment by CompuServe	*
 *  Incorporated							*
 *									*
 ************************************************************************/

/**
 * File:  BPPACKET.H
 *
 * Facility:  B protocol packet driver
 *
 * Abstract:
 *	'C' header for B protocol packet driver
 *
 * Environment:  None specified
 *
 * Author:  John Pampuch, November 5, 1987
 *
 * Modified by:
 *
 * 1	John Pampuch, November 5, 1987
 *	- Original
 *
 * 2	John Pampuch, January 5, 1988
 * 	- Modified to remove unneeded structure nesting
 *
 **/

#ifndef BPPACKET_H
#define BPPACKET_H

#include "comdef.h"

#define MaskLowRange 0x01
#define MaskHiRange 0x10
/*
 * B protocol error codes
 *
 * Used to specify extended information identifying specific
 * B protocol errors.  
 */

#define Normal		0
#define Timeout		1
#define Memory		2	/* s_alloc returned failure (NULL) */
#define Packet_Arrived	3	/* packet arrived while awaiting an ACK */
#define Early_ETX	4	/* ETX arrived before data */
#define Buffer_Overflow	5	/* Arriving packet does not fit into buffer */
#define Check_Failure	6	/* Checksum is not correct */
#define CRC_Failure	7	/* similar to Check_Failure */
#define Pkt_Out_of_Seq	8	/* Packet arrived with unexpected sequence */
#define ACK_Arrived	9	/* ACK arrived while awaiting a packet */
#define Logical_Timeout	10	/* too many packets arrived without timeout */
#define Missing_Funct	11	/* required function not supplied */

/*
 * General definitions used by the protocol library
 */

#define	Remote_Timeout		-1
#define Check_B			0
#define Check_CRC		1
#define Old_B			FALSE
#define B_Plus			TRUE
#define Send_Ahead_Buffers	5
#define Default_Packet_Size	513
#define Default_Max_Errors	10
#define NUL			0x00

#define Quote_Default		0
#define Quote_Not_NULL		1
#define Quote_Extended		2
#define Quote_Full		3
#define Quote_Mask		4

typedef struct
    {
    WORD Seq_Num;			/* sequence number for packet */
    WORD Packet_Size;			/* size of packet to send */
    UBYTE *packet;			/* pointer to packet data */
    } Pending_Element;

typedef struct PDBstruct		/* protocol descriptor block */
    {
    /* pointers to status information handling routines */
    void (*Ch_Sent) (UWORD);	    
    void (*Ch_Read) (UWORD);
    void (*Send_Error) (void);
    void (*Read_Error) (void);

    /* pointers to remote io routines */
    WORD (*Get_Ch_Timed) (WORD);	/* Get BYTE with timeout after */
					/* n seconds: 0 indicates */
					/* return if none pending,  -1 */
					/* indicates wait indefinitely */
    WORD (*Put_Ch) (UBYTE);		/* put BYTE to remote */


    void (*Delay) (UWORD);		/* delay n seconds */

    /* buffers */
    UBYTE *Send_Buffer;			/* Send buffer */
    WORD S_Buffer_Len;			/* Length of buffer contents */
    UBYTE *Read_Buffer;			/* Read buffer */
    WORD R_Buffer_Len;			/* ditto */

    /* space allocation routines */
    BYTE *(*s_alloc) (UWORD);
    void (*s_free) (BYTE *);
	
    /* transfer control information */
    WORD Window_Size;			/* Send size of send ahead window */
    WORD Use_Transport;			/* Flag controlling + negotiation */
					/* packet transport flag FALSE = */
					/* Don't, TRUE = do use transport */
    BOOL Use_B_Plus;			/* Flag controlling use of B+ */
					/* either Old_B or B_Plus */
    WORD Packet_Size;			/* Maximum block size.  Should */
					/* be initialized to 513 */
    WORD Update_Freq;			/* character frequency of status */
					/* updates */
    WORD Max_Errors;			/* Count of errors allowed til */
					/* failure.  Generally should be 10 */
					/* but setting it to a smaller */
					/* value facilitates debugging */
    WORD Quoting_Level;			/* quoting level requested by the */
    					/* user:  Best choice is 1, but 0 */
					/* through 3 are supported */
    WORD Error_Code;			/* extended error information */
    					/* see the list above for the */
					/* meaning of the contents */

    /* remaining items are transfer specific values used internally */
    /* by the protocol handler and must be initialized to 0 */

    Pending_Element Pending		/* list of pending packets */
    	[Send_Ahead_Buffers];
    WORD Pending_Count;			/* count of packets in window */
    WORD Next_Packet;			/* index to next ack expected in */
					/* pending[] */
    WORD Send_Seq_Number;		/* current send sequence number */
    WORD Read_Seq_Number;		/* current read sequence number */
    UWORD Check_sum;			/* checksum of packet in progress */
    WORD S_Bytes;			/* bytes sent */
    WORD R_Bytes;			/* bytes read */
    WORD Lchar;				/* last BYTE read from remote */
    BOOL NotMasked;			/* Is last char masked? */
    WORD Actual_Check;			/* actual check method */
    BOOL Actual_Xport;			/* actually using transport? */
    BOOL Actual_Plus;			/* init resets, negotiation sets */
    WORD Packets_Btwn_ACKs;		
    WORD Last_ACK_Seen;			
    BOOL Sent_ENQ_To_Remote;
    UBYTE Mask [32];			/* Array of masked chars */

    WORD Valid_To_Resume_Download;	/* Sortof belongs in another place */
    WORD Valid_To_Resume_Upload;
    WORD Send_File_Information; 

    } Protocol_Desc_Block;

/* public routine prototypes for use by calling application */
public void BP_Send_ACK (Protocol_Desc_Block *);
public void BP_Send_Wait (Protocol_Desc_Block *);
public Protocol_Desc_Block *BP_Create_PDB (BYTE *(*) (UWORD), void (*) (BYTE *));
public WORD BP_Init_PDB (BOOL, WORD, Protocol_Desc_Block *);
public WORD BP_Set_To_Quote (UBYTE, Protocol_Desc_Block *);
public WORD BP_Unset_To_Quote (UBYTE, Protocol_Desc_Block *);
public BOOL BP_Is_Chr_Quoted (UBYTE, Protocol_Desc_Block *);
public WORD BP_Alloc_Buffers (Protocol_Desc_Block *);
public void BP_Free_Buffers (Protocol_Desc_Block *);
public WORD BP_Read_Packet (BOOL, BOOL, BOOL, Protocol_Desc_Block *);
public WORD BP_Send_Packet (WORD, Protocol_Desc_Block *);
public void BP_Send_Failure (UBYTE, UBYTE *, Protocol_Desc_Block *);
public void BP_Seen_ENQ (Protocol_Desc_Block *);
public WORD BP_Flush_Pending (Protocol_Desc_Block *);
public void BP_Do_CRC (WORD, WORD *);
#endif
