/*
    seg.c

    segment creation, edit, deletion, and control routines
*/

#include    "defs.h"

static  key_t   *top_key    =    NULL;
static  key_t   *cur_key    =    NULL;

seg_t   *top_seg    =    NULL;
seg_t   *cur_seg    =    NULL;

static  int opened = FALSE;

void    draw_seg(seg, vport)
seg_t   *seg;
vport_t *vport;
{
rect_t  chk, *get_bbox(), *copy_rect();

    vport->seg = seg;
/*
    Check segment bbox to see if it's
    visible at all.
*/
    if(seg->visible && sect_rect(seg->bbox, vport->window, &chk))
        list_draw(seg->data, vport);
}

/* create segment */

BOOLEAN cr_seg(name)
char    *name;
{
seg_t   *seg, *inst_seg();

    if(opened != FALSE)
        {
        error("Can't create segment, please close current segment");
        return(FALSE);
        }
    else
        {
        opened = TRUE;

        /* get a new segment descriptor */
        seg = inst_seg(name);
        top_key = cur_key = NULL;

        /* link descriptor into segment list */
        if(top_seg == NULL)
            {
            top_seg = seg;
            }
        else
            {
            seg->next = top_seg;
            top_seg = seg;
            }

        /* track current segment */
        cur_seg = top_seg;

        return(TRUE);
        }
}

/* open segment */

BOOLEAN op_seg(seg)
seg_t   *seg;
{
    if(opened != NULL)
        {
        error("Can't open segment, please close current segment");
        return(FALSE);
        }
    else
        {
        opened = TRUE;
        cur_seg = seg;
        top_key = seg->data;
        cur_key = seg->eol;
        return(TRUE);
        }
}

/* append to current segment */

void    append(type, pointer)
int        type;
char    *pointer;
{
    if(opened == FALSE)
        return;

    if(top_key == NULL)
        {
        top_key = cur_key = inst_key();
        }
    else
        {
        cur_key->next = inst_key();
        cur_key = cur_key->next;
        }

    cur_key->key.ptr = pointer;
    cur_key->type = type;
}

/* close segment */

seg_t    *cl_seg()
{
rect_t  *get_bbox();

    if(top_key == NULL)
        {
        error("Closing empty segment");
        return(NULL);
        }
    else
        {
        opened = FALSE;
        cur_seg->data = top_key;
        cur_seg->eol =  cur_key;
        top_key = cur_key = NULL;

        cur_seg->bbox = get_bbox(cur_seg->data);
        cur_seg->visible = TRUE;
        cur_seg->locked = FALSE;
        return(cur_seg);
        }
}

seg_t   *instance(seg)
seg_t   *seg;
{
    seg->num_inst++;
    return(seg);
}

void    del_seg(seg)
seg_t    *seg;
{
key_t   *next;
seg_t   *last;
void    free_key();

    if(seg->locked == TRUE)
        return;

    if(seg->num_inst == 0)
        {
        /* free segment data */
        cur_key = seg->data;
        while(cur_key != NULL)
            {
            next = cur_key->next;
            free_key(cur_key);
            cur_key = next;
            }

        /* free segment rectangles */
        if(seg->bbox != NULL)
            free(seg->bbox);

        /* free segment descriptor */
        if(top_seg == seg)
            {
            top_seg = seg->next;
            free(seg);
            return;
            }
        else
            {
            last = top_seg;
            while(last->next != NULL)
                {
                if(last->next == seg)
                    {
                    /* patch segment list */
                    last->next = seg->next;
                    free(seg);
                    return;
                    }
                last = last->next;
                }
            /* error: can't find segment */
            }
        }
    else
        seg->num_inst--;
}

void    del_data(key)
key_t   *key;
{
seg_t   *seg;

    seg = top_seg;
    while(seg != NULL)
        {
        if(seg->data == key)
            {
            del_seg(seg);
            return;
            }
        seg = seg->next;
        }
}

void    free_key(key)
key_t    *key;
{
void    free_cpt();

    switch(key->type)
        {
        case    REF     :
            if(key->key.ref->instance != NULL)
                del_seg(key->key.ref->instance);
            break;

        case    LINE    :
            free_cpt(key->key.line->point);
            break;

        case    POLY    :
            free_cpt(key->key.poly->point);
            break;

        default :
		;		/* do nothing */
        }

    if(key->key.ptr != NULL)    /* if a primitive */
        free(key->key.ptr);

    free(key);
}

/* free links in continue point list */

void    free_cpt(cp)
cpoint_t    *cp;
{
    if(cp->next != NULL)
        free_cpt(cp->next);

    free(cp);
}
