/*
    graphics.c

    device-dependent code

    NOTE:

        All routines in this file are passed
        world coordinates.

        These coordinates are operated on in the following order:

        1. clip-to-window      (world coordinates)
        2. map-to-viewport     (display coordinates)
        3. draw on display

*/

#include "defs.h"

extern  rect_t  screen, *cur_win, *cur_port;

/* current position in window */
int cx = 0, cy = 0;

/* results of line clip */
extern  int rx1, ry1, rx2, ry2;


/*

    display initialization, control, and
    termination subroutines

    initialize:
        erase display (to black),
        set up a color lookup table if needed,
        perform anything else

    set_color:
        takes attribute color as argument,
        sets current display draw color

    terminate:
        restore state of display to
        what it was before initialization

*/

void    initialize()
{
void    set_color();
/*
    set_rect(&screen, ...... );
*/
    set_color(WHITE);
}

void    set_color(attr)
int attr;
{
    switch(attr)
        {
        case BLACK  :   /* set display's equivalent color code */
        case WHITE  :
        case RED    :
        case GREEN  :
        case BLUE   :
        case MAGENTA :
        case CYAN   :
        case YELLOW :
            break;
        }
}

void    terminate()
{
}

/*

    simple movement and line drawing

*/

void    move_to(x, y)
int     x, y;
{
    printf("WC : Move to %d, %d\n",x,y);

    cx = x;
    cy = y;
}

void    move(x, y)
int     x, y;
{
    printf("WC : Move %d, %d\n",x,y);

    cx += x;
    cy += y;
}

void    line_to(x, y)
int     x, y;
{
    printf("WC : Line to %d, %d\n",x,y);

    if(clipper(cx, cy, x, y, cur_win))
        {
        map(&rx1, &ry1);
        map(&rx2, &ry2);

    printf("SC : Line %d, %d to %d, %d\n",rx1,ry1,rx2,ry2);
/*
        draw line from rx1, ry1 to rx2, ry2
*/
        }

    cx = x;
    cy = y;
}

void    line(x, y)
int  x, y;
{
    printf("WC : Line %d, %d\n",x,y);

    if(clipper(cx, cy, cx + x, cy + y, cur_win))
        {
        map(&rx1, &ry1);
        map(&rx2, &ry2);

    printf("SC : Line %d, %d to %d, %d\n",rx1,ry1,rx2,ry2);
/*
        draw line from rx1, ry1 to rx2, ry2
*/
        }

    cx += x;
    cy += y;
}

/*

    text routines:

    text_bbox returns rectangle that
    represents bounding box of text
    primitive

    draw_text draws given text on
    display in specified format

*/

rect_t  *text_bbox(string, jh, jv)
char    *string;
char    jh, jv;
{
rect_t  *bbox,
        *inst_rect();
int     offset;
int     size[2];    /* used to get bbox */

    printf("Text bbox\n");
    /* use system to find text bbox here */

    /* reset to system's text bbox */
    bbox = inst_rect( 0, 0, size[0], size[1]);

    /* offset for justification */
    switch(jh)
        {
        case    MIDDLE  :
            offset = 0 - size[0] / 2;
            offset_rect(bbox, offset, 0);
            break;
        case    RIGHT   :
            offset = 0 - size[0];
            offset_rect(bbox, offset, 0);
            break;
        }
    switch(jv)
        {
        case    CENTER  :
            offset =  0 - size[1] / 2;
            offset_rect(bbox, 0, offset);
            break;
        case    TOP  :
            offset = 0 - size[1];
            offset_rect(bbox, 0, offset);
        }

    return(bbox);
}

void    draw_text(string, x, y, bbox)
char    *string;
int     x, y;
rect_t  *bbox;
{
rect_t  vbb;
char    str[256];

    printf("Draw text [%s] at %d, %d\n",string,x,y);

    /* copy string to scratch */
    strcpy(str, string);

    vbb.left = bbox->left + x;
    vbb.bottom = bbox->bottom + y;

    vbb.right = bbox->right + x;
    vbb.top = bbox->top + y;

    /* map viewable bbox */
    map( &(vbb.left), &(vbb.bottom));
    map( &(vbb.right), &(vbb.top));

    /* if hardware origin is at lower left */
    x = vbb.left;
    y = vbb.bottom;

    /* call system to draw text at x, y */

}

/*
    remaining routines fill and
    frame simple shapes
*/

void    fill_rect(rect)
rect_t  *rect;
{
rect_t  r;

    printf("Fill rect %d, %d <-> %d, %d\n",
        rect->left, rect->bottom, rect->right, rect->top);

    if(sect_rect(rect, cur_win, &r))
        {
        printf("\tCC %d, %d <-> %d, %d\n",r.left,r.bottom,r.right,r.top);

        map( &(r.left),  &(r.bottom));
        map( &(r.right), &(r.top));

        printf("\tSC %d, %d <-> %d, %d\n",r.left,r.bottom,r.right,r.top);
/*
        draw primitive according to its color
*/
        }
}

void    clear_vport(vp)
vport_t *vp;
{
}


void    fill_oval(rect)
rect_t  *rect;
{
rect_t  r;

    printf("Fill oval %d, %d <-> %d, %d\n",
        rect->left, rect->bottom, rect->right, rect->top);

    if(sect_rect(rect, cur_win, &r))
        {
        map( &(r.left),  &(r.bottom));
        map( &(r.right), &(r.top));

        printf("\tSC %d, %d <-> %d, %d\n",r.left,r.bottom,r.right,r.top);
/*
        draw primitive according to its color
*/
        }
}

void    frame_oval(rect)
rect_t  *rect;
{
rect_t  r;

    printf("Frame oval %d, %d <-> %d, %d\n",
        rect->left, rect->bottom, rect->right, rect->top);

    if(sect_rect(rect, cur_win, &r))
        {
        map( &(r.left),  &(r.bottom));
        map( &(r.right), &(r.top));

        printf("\tSC %d, %d <-> %d, %d\n",r.left,r.bottom,r.right,r.top);
/*
        draw primitive according to its color
*/
        }
}

void    fill_poly(p)
poly_t  *p;
{
    printf("Fill Poly\n");

/*
        clip polygon to current window,
        map each of polygon's vertices,
        draw primitive according to its color
*/
}
