/**************************************************************************
* This file contains function routines that parallel those found in       *
* QuickBasic 4.5 and otherwise. Written by David Wesson   Version 1.1     *
*   NOTE: ASC() requires presence of char *ascii declared locally         *
**************************************************************************/

#define MAIN
#include "basic.h"

char *xcalloc( unsigned int items, unsigned int size )
{ /* allocates heap space at runtime, by Kochan & Wood */
     char *heap;
     unsigned int blocksize;

     blocksize = items * size;

     if( (heap = malloc( blocksize + sizeof( int ) ) ) == NULL )
		fprintf( stderr, "Not enough space in memory." ), exit ( 1 );

     *(int *)heap = items;
     memset( heap + sizeof( int ), 0, blocksize );
     return heap + sizeof( int );
}

int findfiles( char *pathname )
{
     struct find_t find;
     static int num = 0;

     if( !_dos_findfirst( pathname, _A_NORMAL, &find ) )
          strcpy( filelist[num++], find.name );
     else
          return 0;

     while( !_dos_findnext( &find ) )
          strcpy( filelist[num++], find.name );

     return num;
}

char *keyin( int row, int col, int fcolor, int bcolor, int length,
		   int type, char *deflt )
{
	int ch;
	register x, place = strlen( deflt );
	char k[MAX_SCREEN_LINE], spacer[] = "\0";

	print( row, col, bcolor, fcolor, deflt );
	LOCATE( row, col + place );
	COLOR( fcolor, bcolor );
	CURSOR_ON;
	memset( k, 0, MAX_SCREEN_LINE);
	strcpy( k, deflt );
	while( TRUE )
		{
		ch = getch();
		if( ch == 0 )                /* Check and process extended keys */
			{
			switch ( ch = getch() )
				{
				case HOME:
					place = 0;
					print( row, col, fcolor, bcolor, k );
					LOCATE( row, col );
					break;
				case END:
					place = strlen( k );
					LOCATE( row, col + place );
					break;
				case LEFT:
					print( row, col, fcolor, bcolor, k );
					if( place > 0 )
						{
						LOCATE( row, col + --place  );
						}
					break;
				case RIGHT:
					if( place < strlen( k ) )
						LOCATE( row, col + ++place );
					break;
				case DEL:
					if( place < length )
						{
						PRINT( spacer );
						k[place] = ' ';
						if( place < length - 1 )
							place++;

						LOCATE( row, col + place );
						}
					break;
				case INS:
					for( x = 0; x < length - place; x++ )
						k[length - x] = k[length - x - 1];

					k[place] = ' ';
					k[length] = '\0';
					print( row, col, fcolor, bcolor, k );
					LOCATE( row, col + place );
					break;
				default:
					k[0] = (char)ch;
					k[1] = '\0';
					k[MAX_SCREEN_LINE] = 2;
					return k;
				}
			goto skip;
			}

		switch( ch )                 /* Process regular characters */
			{
			case ENTER:
					if( strlen( k ) == 0 )
						strcpy( k , "enter" );

					CURSOR_OFF;
					return k;
			case ESC:
					strcpy( k, "esc" );
					CURSOR_OFF;
					return k;
			case BKSP:
					print( row, col, fcolor, bcolor, k );
					if( place > 0 )
						{
						k[--place] = ' ';
						LOCATE( row, col + place );
						PRINT( spacer );
						LOCATE( row, col + place );
						}
					break;
			default:
					{
					if( strlen( deflt ) > 0 )
						{
						memset( k, 0, MAX_SCREEN_LINE);
						place = 0;
						print( row, col, fcolor, bcolor, string( length, 254 ) );
						strcpy( deflt, "" );
						}

					if( type == NUMERIC && ((ch < 42) || (ch > 58)) )
						{
						BEEP;  /*  Alphas in a numeric field are filtered, */
						break; /*  but not numerics in alpha fields.       */
						}

					if( place == length ||
					    place == MAX_SCREEN_LINE - 1 )
						{
						BEEP;
						break;
						}
					else
						{
						k[place] = (char) ch;
						print( row, col + place - 1, fcolor, bcolor, k + place++ );
						LOCATE( row, col + place );
						}
					}
				}
skip:     while( k[strlen( k ) - 1] == 32 )
			  k[strlen( k ) - 1] = 0;
		}
		CURSOR_OFF;
}

long freespace( int drive )
{
     long a, b, c;

     inregs.x.ax = 0x3600;
     inregs.x.dx = drive;
     int86( DOS, &inregs, &outregs );
     a = outregs.x.ax;
     b = outregs.x.bx;
     c = outregs.x.cx;
     return ( a * c * b );
}

char *filestamp( char *filename )
{
     char temp[MAX_SCREEN_LINE], buffer[MAX_SCREEN_LINE];
     char time[10], hour[10], min[10], ampm[] = "am";
     int hr;

     stat( filename, &filestat );
     strcpy( buffer, lftstr( ctime( &filestat.st_atime ), 24 ) );
     strcpy( hour, midstr( buffer, 12, 2 ) );
     strcpy( min, midstr( buffer, 15, 2 ) );
     hr = atoi( hour );
     if( hr > 12 )
          {
          hr -= 12;
          strcpy( ampm, "pm" );
          }
     itoa( hr, hour, 10 );
     sprintf( time, "%.2i:%s%s", hr, min, ampm );
     sprintf ( temp, "%s, %s %s", midstr( buffer, 5, 6 ),
               rtstr( buffer, 4 ), time );
     return temp;
}

char *timestamp( void )
{
     char temp[MAX_SCREEN_LINE], buffer[MAX_SCREEN_LINE];
     char t[10], hour[10], min[10], ampm[] = "am";
     int hr;

     time( &ltime );
     strcpy( buffer, lftstr( ctime( &ltime ), 24 ) );
     strcpy( hour, midstr( buffer, 12, 2 ) );
     strcpy( min, midstr( buffer, 15, 2 ) );
     hr = atoi( hour );
     if( hr > 12 )
		hr -= 12, strcpy( ampm, "pm" );
     sprintf( t, "%.2i:%s%s", hr, min, ampm );
     sprintf ( temp, "%s, %s %s", midstr( buffer, 5, 6 ),
               rtstr( buffer, 4 ), t );
     return temp;
}

char *string( size_t num, int ascii )
{
     char temp[MAX_SCREEN_LINE]=
     "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
     strset( temp, ascii );
     temp[num] = '\0';
     return strdup( temp );
}

char *tabout( char *line, int space, int maxsize)
{
     char *temp, *t;
     int offset;

     while( ( strchr( line, '\t' ) != NULL ) &&
            ( ( strlen( temp ) + space ) < maxsize - 1 ) )
          {
          t = strchr( line, '\t' );
          offset = t - line;
          sprintf( temp, "%s%s%s",
                   lftstr( line, offset ),
                   SPACE( space ),
                   rtstr( line, strlen( line ) - (offset + 1) ) );
          strcpy( line, temp );
          }
     return line;
}

char *ltrim( char *string )
{
     char *temp;

     temp = strdup( string );
     while( temp[0] == 32 )
          temp++;
     return temp;
}

char *rtrim( char *string)
{
     char *temp;
     int last;

     temp = strdup( string );
     last = strlen( temp ) - 1;
     while( temp[last] == 32 )
		temp[last] = 0, last -= 1;
     return temp;
}


long lof( char *filename )
{
     stat( filename, &filestat );
     return filestat.st_size;
}

int checkkey( void )
{
     int key = OFF;

     if( kbhit() != NULL )
          key = getch();
     return key;
}

char *justfilename( char *pathname )
{

     char temp[MAX_PATH_SIZE];
     char drive[_MAX_DRIVE], dir[_MAX_DIR];
     char fname[_MAX_FNAME], ext[_MAX_EXT];

     _splitpath( pathname, drive, dir, fname, ext );
     sprintf( temp, "%s%s", fname, ext );
     return temp;
}

char *lftstr( char *string, int len )
{
     char *temp;

     temp = strdup( string );
     strset( temp, 0);
     memccpy( temp, string, '\0', len );
     return temp;
}

char *rtstr( char *string, int len )
{
     char *temp;

     temp = strdup( string );
     strset( temp, 0);
     memccpy( temp, (string + (strlen( string ) - len )), '\0', len );
     return temp;
}

char *midstr( char *string, int offset, int len )
     /* NOTE: len 0 produces rest of string */
{
     char *temp;

     if( len == 0 )
          len = (strlen( string ) - offset + 1);

     temp = strdup( string );
     strset( temp, 0);
     memccpy( temp, (string + offset - 1), '\0', len );
     return temp;
}

int printer( void )
{
     int p = 0, a = 0, b = 0, result = 0;

     inregs.h.ah = 0x2;
     int86( LPRINTER, &inregs, &outregs );
     p = outregs.h.ah;
     a = p & 32;
     b = p & 128;
     if( ( a != OFF ) || ( b == OFF ) )
          result = OFF;
     else
          result = ON;

     return result;
}




