/*
 * prbar - print a thick or thin line or space
 * IBM Graphics Printer version
 * written 1987 David J. Rodman
 * Paradise Technology, Inc.
 * Compuserve 70007,1545
 * This code is placed into the public domain.  Have at it.
 */

#include <stdio.h>
extern int res, depth; 	/* settings for width and heigth of barcode */
extern char *text[];   	/* text for the right-hand part of label */
extern lineno;		/* current line of label */

static char *str;	/* the string to encode */

/*
 * initialize the printer as required to print string s
 * the ratio of thick to thin is 3:1, and there will be 3 thicks and 6 thins.
 * each character is terminated by a thin space.
 * thus, each character is 16 * res dots wide (res * 6 + 3*res * 3 + res)
 * each string starts and stops with a special code, so there are
 * strlen(s) + 2 bytes to print.
 */
prinit(s)
	char *s;
{
	unsigned n;

	str = s;	
	n = 16 * res * (strlen(s) + 2);		/* total # of graphic bytes */
	printf("%c1", 0x1b); 	  	  	/* 10 lpi */
	printf("%cL%c%c", 0x1b, n & 0xff, n >> 8);	/* 120 DPI graphics */
}

/*
 * This is the place to put any other printer reset commands you want,
 *	like 6 LPI, condensed print, or whatever.
 */
prfini()
{
	printf("%c3%c\n%s\n", 0x1b, 36, text[0]);
}

/*
 * print an individual line or space, thick or thin 
 * args are boolean
 */
prbar(thick, line)
{
	int w, c;

	w = res * (thick ? 3 : 1);
	c = line ? 0xff : 0;
	while(w--)
		printf("%c", c);
}

/*
 * move down one line, printing the appropriate text
 */
prdown()
{
 	printf(" %s", text[lineno++]);
	printf("%c%c", 0x0d, 0x0a);
}

