// ---------------------------------------------------------------------------
// bag.cpp
//
// An example of a direct bag implementation.
//
// This sample program creates 6 strings stored on
// the heap and stores them in a bag.
// ---------------------------------------------------------------------------

#include <classlib/bags.h>
#include <iostream.h>
#include <strstrea.h>


typedef char * MyClass;
typedef TBagAsVector<MyClass> BagType;
typedef TBagAsVectorIterator<MyClass> BagIteratorType;

const int MaxItems=6;

void ForEachCallBack(MyClass& mc, void* s) {
		cout << (char*)s << mc << endl;
}


int EqualityTest(const MyClass& mc, void * s) {
	// cout << "Testing " << mc << " against " << (char*) s << endl;
	int result = strcmp(mc, (const char *) s);

	// cout << "result = " << result << endl;

	return (!result);
}



void AddItems(BagType& container, int numItems)
{
		for( int i=numItems; i>0; i-- )
				{
				char buf[80];
				ostrstream str( buf, sizeof(buf) );
				str << i << " hello" << ends;
				cout << "Adding string " << buf << " to bag." << endl;
				container.Add( strdup(buf) );
				}
}

void UseForwardIterator(BagType& container)
{
		BagIteratorType iterator(container);
		while( iterator )
				{
				cout << iterator.Current() << endl;
				iterator++;
				}
}


void DoLookup(BagType & container, const char * buf) {
	cout << "Testing for " << buf << " in bag." << endl;

	// Now go find it...
	char ** bag = container.FirstThat(EqualityTest, (void *)buf);
	if (bag) {
		cout << "found: " << *bag << endl;
	}
	else {
		cout << "no match found" << endl;
	}
}


int main()
{
		BagType container(MaxItems);
		AddItems(container, MaxItems);

		cout << "--- Starting ForEach" << endl;
		container.ForEach(ForEachCallBack, (void*)"FE ");

		cout << "--- Starting Iterator (forward)" << endl;
		UseForwardIterator(container);

		cout << "--- Looking Up \"4 hello\"" << endl;
		DoLookup(container, "4 hello");

		cout << "--- Looking Up \"unknown\"" << endl;
		DoLookup(container, "unknown");

		return 0;
}
