#include <dos.h>

#include "async.h"

extern  int UART_ports[];
extern  struct async_portS async_port[4];

int     async_putch_timeout(int comport, char c, long timeout)
{
    long    to;

    to = timeout;
    while (async_port[comport].txbuflength>=TXBUFSIZE) {
        if (timeout) {
            to--;
            delay(1);

            if (to == 0) {
                return(0);
            }
        }
    }

    async_port[comport].txbuf[async_port[comport].txhead] = c;

    async_port[comport].txhead++;
    async_port[comport].txbuflength++;
    if (async_port[comport].txhead == TXBUFSIZE) {
        async_port[comport].txhead = 0;
    }

    outportb(UART_ports[comport]+IER, 0x03);

    return (1);
}

void    async_putch(int comport, char c)
{
    async_putch_timeout(comport, c, 0L);

    outportb(UART_ports[comport]+IER, 0x03);
}

void    async_puts(int comport, char *s)
{
    while (*s) {
        async_putch(comport, *s++);
    }
}

int     async_putblock_timeout(int comport, const char *block, int size, long timeout)
{
    long    to;

    while (size--) {
        to = timeout;

        // Wait for room in the TX buffer
        while (async_port[comport].txbuflength>=TXBUFSIZE) {
            if (timeout) {
                to--;
                delay(1);

                if (to == 0) {
                    return(0);
                }
            }
        }

        // Go ahead and put next character from block into TX buffer
        async_port[comport].txbuf[async_port[comport].txhead] = *block++;

        // Increment buffer pointers
        async_port[comport].txhead++;
        async_port[comport].txbuflength++;
        if (async_port[comport].txhead == TXBUFSIZE) {
            async_port[comport].txhead = 0;
        }
    }

    outportb(UART_ports[comport]+IER, 0x03);

    return (1);
}

void    async_putblock(int comport, const char *block, int size)
{
    async_putblock_timeout(comport, block, size, 0L);
}

int     async_ready(int comport)
{
    if (async_port[comport].rxbuflength) {
        return (1);
    } else {
        return (0);
    }
}

char    async_getch(int comport)
{
    char    c;

    if (async_port[comport].rxbuflength) {
        c = async_port[comport].rxbuf[async_port[comport].rxtail];

        async_port[comport].rxtail++;
        async_port[comport].rxbuflength--;
        if (async_port[comport].rxtail == RXBUFSIZE) {
            async_port[comport].rxtail = 0;
        }

        return(c);
    }

    return (0);
}

int     async_getblock(int comport, char *block, int size)
{
    int     snatched = 0;

    while (size && async_port[comport].rxbuflength) {
        block[snatched] = async_port[comport].rxbuf[async_port[comport].rxtail];

        size--;
        async_port[comport].rxbuflength--;
        snatched++;
        async_port[comport].rxtail++;
        if (async_port[comport].rxtail == RXBUFSIZE) {
            async_port[comport].rxtail = 0;
        }
    }

    return (snatched);
}

char    async_peek(int comport)
{
    char    c;

    if (async_port[comport].rxhead != async_port[comport].rxtail) {
        c = async_port[comport].rxbuf[async_port[comport].rxtail];
        return (c);
    }

    return (0);
}

void    async_flushrx(int comport)
{
    async_port[comport].rxhead = 0;
    async_port[comport].rxtail = 0;
    async_port[comport].rxbuflength = 0;
}

void    async_flushtx(int comport)
{
    async_port[comport].txhead = 0;
    async_port[comport].txtail = 0;
    async_port[comport].txbuflength = 0;
}
