;-------------------------------------------------------------------------
; xms_drv.asm -- FORCE Interface to the XMS driver.
;-------------------------------------------------------------------------
; RCSid = "$Header: C:\TECH\FAQ\XMS\RCS\xms_drv.asm 0.10 1992/05/22 19:30:52 holmesda Exp holmesda $";
;-------------------------------------------------------------------------
; Note: The following code has been "borrowed" from the _interrupt()
;	function source code in the FORCE library
;-------------------------------------------------------------------------
params	struc
		ret_addr dd	?
		_stk_bp	dw	?

		_xd_address	dd	?
		_ax	dd 	?
		_bx	dd 	?
		_cx	dd 	?
		_dx	dd 	?
		_si	dd 	?
		_di	dd 	?
		_bp	dd 	?
		_ds	dd 	?
		_es	dd 	?
params	ends
;-------------------------------------------------------------------------
Mr_Stack		segment para stack public 'STACK'
			db	200h	dup(?)
Mr_Stack		ends
;-------------------------------------------------------------------------
Mr_Code			segment word public 'CODE'
			assume cs:Mr_Code
;-------------------------------------------------------------------------
int_ax			dw	?
int_bx			dw	?
int_ds			dw	?
XMS_DRIVER		dd	?
;-------------------------------------------------------------------------
; function: _call_driver()
;
; description:  Given the address of the XMS driver, and the addresses
;	of the pseudo-registers, call the driver and return all the
;	the values through the registers.
;-------------------------------------------------------------------------
			public	_call_driver
_call_driver		proc	far
			push	bp		; Save the necessary
			mov	bp,sp		; Registers....
			push	ds
			push	si
			push	es
			push	di

			mov	ax, word ptr [bp]._xd_address
			mov	word ptr [XMS_driver], ax
			mov	ax, word ptr [bp]._xd_address.2
			mov	word ptr [XMS_driver].2,ax

			lds	bx, [bp]._ax
			mov	ax, [bx]
			mov	cs:int_ax, ax

			lds	bx, [bp]._bx
			mov	ax, [bx]
			mov	cs:int_bx, ax

			lds	bx, [bp]._ds
			mov	ax, [bx]
			mov	cs:int_ds, ax

			lds	bx, [bp]._es
			mov	es, [bx]

			lds	bx, [bp]._cx
			mov	cx, [bx]

			lds	bx, [bp]._dx
			mov	dx, [bx]

			lds	bx, [bp]._si
			mov	si, [bx]

			lds	bx, [bp]._di
			mov	di, [bx]

			mov	ax, cs:int_ax
			mov	bx, cs:int_bx
			mov	ds, cs:int_ds

			call	dword ptr [XMS_driver]

			mov	cs:int_ax, ax
			mov	cs:int_bx, bx
			mov	cs:int_ds, ds

			lds	bx, [bp]._ax
			mov	ax, cs:int_ax
			mov	[bx], ax

			lds	bx, [bp]._bx
			mov	ax, cs:int_bx
			mov	[bx], ax

			lds	bx, [bp]._ds
			mov	ax, cs:int_ds
			mov	[bx], ax

			lds	bx, [bp]._es
			mov	[bx], es

			lds	bx, [bp]._cx
			mov	[bx], cx

			lds	bx, [bp]._dx
			mov	[bx], dx

			lds	bx, [bp]._si
			mov	[bx], si

			lds	bx, [bp]._di
			mov	[bx], di

  _call_driver_out:	pop	di
			pop	es
			pop	si
			pop	ds
			pop	bp
			ret
_call_driver		endp

Mr_Code			ends

			end
;-- EOF: xms_drv.asm  ----------------------------------------------------
