/****************************************************************************
 ICONDEMO.PRG

 Demo of WinIcon()

 J. David Reynolds
 07/13/94

****************************************************************************/

#include "achoice.ch"
#include "directry.ch"
#include "inkey.ch"
#include "setcurs.ch"

#define CRLF chr( 13 ) + chr( 10 )


static lFileMode  := .t.
static nBGColor   := 0
static nColorRow  := 0
static nFileRow   := 0



/****************************************************************************
 Main()
****************************************************************************/
function Main( cFilename, cBGColor )
   local aColors
   local aFiles   := {}
   local lQuit    := .f.
   local nColor   := 1
   local nFile    := 1
   local xOldCurs

   if ( empty( cFilename ) )
      cFilename   := ""
   endif
   if ( empty( cBGColor ) )
      cBGColor := "0"
   endif

   if ( "?" $ cFilename )
      outerr( "Usage:  ICONDEMO [<filename>[.ICO] " + ;
         "[<background color number>]]" + CRLF )
      quit
   endif

   xOldCurs := setcursor( SC_NONE )
   scroll()
   @ 00, int( maxcol() / 2 ) + 1 to maxrow(), maxcol()
   setblink( .f. )

   if ( empty( cFilename ) )
      aeval( directory( "*.ICO" ), { | e | aadd( aFiles, e[F_NAME] ) } )
      aColors  := { ;
         "black        ", ;
         "blue         ", ;
         "green        ", ;
         "cyan         ", ;
         "red          ", ;
         "magenta      ", ;
         "brown        ", ;
         "light grey   ", ;
         "dark grey    ", ;
         "light blue   ", ;
         "light green  ", ;
         "light cyan   ", ;
         "light red    ", ;
         "light magenta", ;
         "yellow       ", ;
         "white        " }
      __keyboard( chr( K_ESC ) )
      achoice( int( maxrow() / 2 ) + 2, 01, ;
         maxrow() - 1, int( maxcol() / 2 ) - 1, ;
         aColors, ;
         , ;
         "ColorFunc", ;
         nColor, ;
         nColorRow )
      __keyboard( chr( K_CTRL_PGUP ) )
      while ( .not. lQuit )
         if ( lFileMode )
            @ 00, 00 to int( maxrow() / 2 ), int( maxcol() / 2 ) double
            @ int( maxrow() / 2 ) + 1, 00 to maxrow(), int( maxcol() / 2 )
            while ( ( nFile > 0 ) .and. ;
                  ( .not. ( lastkey() == K_TAB ) ) )
               if ( ( nFile  := ;
                     achoice( 01, 01, ;
                        int( maxrow() / 2 ) - 1, int( maxcol() / 2 ) - 1, ;
                        aFiles, ;
                        , ;
                        "FileFunc", ;
                        nFile, ;
                        nFileRow ) ) > 0 )
                  DispIcon( aFiles[nFile], ;
                     int( ( maxrow() - 16 ) / 2 ), ;
                     int( maxcol() / 2 ) + 2 + ;
                     int( int( maxcol() / 2 ) - 32 ) / 2 )
               endif
            end while
            __keyboard( chr( 0 ) )
            inkey()
            lQuit := ( nFile == 0 )
         else
            @ 00, 00 to int( maxrow() / 2 ), int( maxcol() / 2 )
            @ int( maxrow() / 2 ) + 1, 00 to ;
               maxrow(), int( maxcol() / 2 ) double
            while ( ( nColor > 0 ) .and. ;
                  ( .not. ( lastkey() == K_TAB ) ) )
               if ( ( nColor  := ;
                     achoice( int( maxrow() / 2 ) + 2, 01, ;
                        maxrow() - 1, int( maxcol() / 2 ) - 1, ;
                        aColors, ;
                        , ;
                        "ColorFunc", ;
                        nColor, ;
                        nColorRow ) ) > 0 )
                  nBGColor := nColor - 1
                  DispIcon( aFiles[nFile], ;
                     int( ( maxrow() - 16 ) / 2 ), ;
                     int( maxcol() / 2 ) + 2 + ;
                     int( int( maxcol() / 2 ) - 32 ) / 2 )
               endif
            end while
            __keyboard( chr( 0 ) )
            inkey()
            lQuit := ( nColor == 0 )
         endif
      end while
   else
      nBGColor := val( cBGColor )
      DispIcon( cFilename, ;
         int( ( maxrow() - 16 ) / 2 ), ;
         int( ( maxcol() - 32 ) / 2 ) )
      inkey( 0 )
   endif

   setblink( .t. )
   scroll()
   setcursor( xOldCurs)

   return( NIL )



/****************************************************************************
 FileFunc()
****************************************************************************/
function FileFunc( nMode, nChoice, nCurRowPos )
   local nReturn

   if ( nMode == AC_IDLE )
      nFileRow    := nCurRowPos
      nReturn     := AC_SELECT
   elseif ( lastkey() == K_ESC )
      nReturn     := AC_ABORT
   elseif ( lastkey() == K_TAB )
      lFileMode   := .f.
      nReturn     := AC_SELECT
   else
      nReturn     := AC_CONT
   endif

   return( nReturn )



/****************************************************************************
 ColorFunc()
****************************************************************************/
function ColorFunc( nMode, nChoice, nCurRowPos )
   local nReturn

   if ( nMode == AC_IDLE )
      nColorRow   := nCurRowPos
      nReturn     := AC_SELECT
   elseif ( lastkey() == K_ESC )
      nReturn     := AC_ABORT
   elseif ( lastkey() == K_TAB )
      lFileMode   := .t.
      nReturn     := AC_SELECT
   else
      nReturn     := AC_CONT
   endif

   return( nReturn )



/****************************************************************************
 DispIcon()
****************************************************************************/
static function DispIcon( cFilename, nRow, nCol )
   local cOldColor

   cFilename   := upper( cFilename )
   if ( .not. ( "." $ cFilename ) )
      cFilename   += ".ICO"
   endif

   cOldColor   := setcolor( iif( nBGColor == 15, "n/", "+w/" ) + ;
      NTrim( nBGColor ) )
   @ nRow - 1, nCol - 1, nRow + 16, nCol + 32 box "-|-|"
   setcolor( cOldColor )

   if ( .not. WinIcon( cFilename, nRow, nCol, nBGColor ) )
      alert( "Error reading " + cFilename )
   endif

   return( NIL )

