/*************************************************************/
/*                                                           */
/*  WHOAMI.C - Clipper UDF written in C                      */
/*             Steve Busey - CompuServe 70224,37             */
/*             02/13/92                                      */
/*                                                           */
/*  Returns string containing the user's NetWare LOGIN name. */
/*    No special libraries needed.                           */
/*                                                           */
/*  Compiled with Borland C++ 3.0                            */
/*    (syntax should work with Borland C++ 2.0 also)         */
/*                                                           */
/*  Compiler command line syntax:                            */
/*    bcc -c -f- -K -ml -N- -P whoami.c                      */
/*                                                           */
/*  Link resulting file in with your Clipper app and         */
/*    EXTEND.LIB and call with something like:               */
/*                                                           */
/*      cLoginName := whoami()                               */
/*                                                           */
/*************************************************************/
/*                                                           */
/* 10/14/92 - Additional error checking and buffer init'ing  */
/*            added to fix delay and lockup reports.   -srb  */
/*                                                           */
/*************************************************************/

/* extern command needed for compatibility with Clipper.     */
/* Note entire program is enclosed by extern braces          */
extern "C" {

/* need to have Clipper's extend.h in working directory      */
#include "extend.h"

/* define request data buffer                                */
typedef struct REQ {
   unsigned int    buffer_length;
   unsigned char   subfunc;
   unsigned char   connection_num;
} reqbuf;

/* Clipper extend naming convention                          */
CLIPPER WHOAMI( void )
{
   reqbuf        request_buffer;
   char          reply_buffer[63];
   unsigned int  i;
   unsigned char conn;
	  
	/* Init reply buffer  */
	for (i=0;i<63;i++)
		reply_buffer[i] = ' ';

	if (PCOUNT == 0) {

   	   /* NetWare interrupt to get connection number             */
	   /*  - uses in-line assembler capability of BC++ 3.0       */
   	   _asm    mov ah,0dch
	   _asm    int 21h
	   conn = _AL;
	}
	else {
	   conn = _parni(1);
	}

   /* Connection Number returned in conn                      */
   if ( conn != 0 ) {

     /* Fill request buffer with proper data, including      */
     /* Connection Number which was returned in conn          */
     /* register above                                       */
     request_buffer.connection_num = conn;
     request_buffer.buffer_length = 0x200;
     request_buffer.subfunc       = 0x16;

     /* Load registers with buffer addresses                 */
     _DI = (unsigned)reply_buffer;
     _SI = (unsigned)&request_buffer;
     _ES = _DS;

     /* Set the function and call the NetWare interrupt      */
     /*  - uses in-line assembler capability of BC++ 3.0     */
     _asm    mov ax,0e300h
     _asm    int 21h

     /* If not successful, make sure we return a null string */
     if (_AL != 0)
	 reply_buffer[8] = 0;

   }
   else {
     /* If connection number is 0, return a null string      */
     reply_buffer[8] = 0;
   }

   /* LOGIN name is returned starting at 9th byte, so find   */
   /* first zero byte after 9th - that's length of string    */
   for ( i=0; reply_buffer[8+i]; i++);

   /* Extend system string/length return protocol            */
   _retclen( reply_buffer+8, i);

}

};

