* These are some of the UDF's that I use from day to day
* Most of them are pretty simple and self-documenting, but if
* you have any problems, I can be reached via the BOSS bbs at
* 201-568-7293 or at my home phone below
*
* 
* Dave West 
* 208 Randall
* Reinbeck IA 50669
* Phone (319) 345-6562 Voice Only! 
*
* Functions
*-----------
* IsOpen()      Find out if a file is open and if so in what work area
* ToLower()     Properly capitalize a string
* NumStr()      1st,2nd,3rd instead of 1,2,3
*
* Procedures
*--------------------
* To_Array      Read a record into an array
* From_Array    Copy an array into a record
*


FUNCTION IsOpen
* --------------------------------------------------------------
* Parameters: alias of file to be checked (c)
* Returns:    SELECT area of file or 0 if not open (n)
*
* EXAMPLE
*    IF IsOpen("Orders")=0
*       WAIT "Error! Order File not open!""
*       SELECT 0
*       Use Orders Index Orders
*    ELSE
*       Select Orders
*    ENDIF
*
PARAMETERS CL_Alias
STORE 1 TO CL_Area
STORE 0 TO CL_Result
DO WHILE CL_Area<11 .AND. CL_Result=0
    IF Alias(CL_Area)=UPPER(CL_Alias)
        STORE CL_Area TO CL_Result
    ELSE
        STORE CL_Area+1 TO CL_Area
    ENDIF
ENDDO
RETURN CL_Result


***************************************************************



FUNCTION ToLower
*------------------------------------------------
* Purpose: Turn JOHN J. SMITH into John J. Smith
* 
* Parameters: <Character string>
* Returns:    Properly capitalized version of character string
* Example:    ? ToLower("JOHN JACOB JINGLEHEIMER-SCHMIDT")  
*              John Jacob Jingleheimer-Schmidt        
PARAMETERS CL_Str

STORE LEN(CL_Str) TO CL_OrigLen        && Keep the original length of the string
STORE TRIM(CL_Str) TO CL_Str           && Trim off trailing spaces
STORE LEN(TRIM(CL_Str)) TO CL_TLen     && Get the length of the new string
*                                      && Cap first letter, lowercase all else
STORE UPPER(SUBSTR(CL_Str,1,1))+LOWER(SUBSTR(CL_Str,2,CL_TLen-1)) TO CL_Str

*---------------------------------------------------
* CL_Pos will be a position with CL_Str, starting at the
* second character
*
STORE 2 TO CL_Pos

*---------------------------------------------------
* Any character in CL_Str which is preceded by any of
* the characters in CL_CapList will be capitalized 
*
STORE "~!@#$%^&*()_+|\=-?/.,<>';:[]{}"+CHR(34)+SPACE(1) TO CL_CapList

*---------------------------------------------------

DO WHILE CL_Pos<=CL_Tlen                               && Move through CL_Str ....
    IF SUBSTR(CL_Str,CL_Pos-1,1)$CL_CapList             && If the previous char is in CL_CapList,
        STORE SUBSTR(CL_Str,1,CL_Pos-1) TO CL_Left       && Store the left half to CL_Left
        STORE UPPER(SUBSTR(CL_Str,CL_Pos,1)) TO CL_Upper && Capitalize the character
        *                                                 && Re-assemble the string
        STORE CL_Left+CL_Upper+SUBSTR(CL_Str,CL_Pos+1,CL_TLen-CL_Pos) TO CL_Str
    ENDIF
    STORE CL_Pos+1 TO CL_Pos                            && Increment position counter
ENDDO

IF LEN(CL_Str)<CL_OrigLen                               && Restore the string to it's
    STORE CL_Str+SPACE(CL_OrigLen-LEN(CL_Str)) TO CL_Str && original length if need be
ENDIF

RETURN CL_Str
*
*



*********************************************************************


*****************************************
* This function returns a string like 101st
* ? NUMSTR(100) returns 100th
*
FUNCTION NumStr
PARAMETERS CL_Num
STORE LTRIM(STR(CL_Num)) TO CL_Str
STORE SUBSTR(CL_Str,LEN(CL_Str),1) TO CL_Bit
DO CASE
 CASE CL_Bit="1"
    STORE "st" TO CL_Suffix
 CASE CL_Bit="2"
    STORE "nd" TO CL_Suffix
 CASE CL_Bit="3"
    STORE "rd" TO CL_Suffix
 CASE CL_Bit$"4567890" .OR. CL_Num>10 .AND. CL_Num<21
    STORE "th" TO CL_Suffix
ENDCASE
STORE LTRIM(STR(CL_Num,6,0))+CL_Suffix TO CL_Result
RETURN CL_Result


PROCEDURE To_Array
*-----------------------------------------------
* This function fills an array with the fields
* of the currently select record.
*
* NOTE: The array must have been declared by the 
*       calling procedure, as arrays in CLipper 
*       are PRIVATE, so if ToArray created an array,
*       it would not be available to the caller.
*
* The name of of the array is passed to ToArray from
* the caller in the memvar CL_Bin
*
PARAMETERS CL_Bin

*------------------------------------------------
* CL_FldCnt will be number of fields in structure
* 
STORE FCount() TO CL_FldCnt

*--------------------------------------------------
* CL_FldPos will be the number of the current field
*
STORE 1 TO CL_FldPos

*-------------------------------------------------
* Move through the field structure.....
*
DO WHILE CL_FldPos<=CL_FldCnt
    
    *------------------------
    * Get the current field's name
    *
    STORE FIELDNAME(CL_FLdPos) TO CL_FldName
    
    *----------------------------
    * And insert it into the array
    *
    STORE &CL_FldName TO CL_Bin[CL_FldPos]
    
    *----------------------------
    * Increment the field counter
    * 
    STORE CL_FldPos+1 TO CL_FldPos
    
ENDDO

RETURN
*
*
*
PROCEDURE From_Array
*------------------------------------------------------
* This function fills an record with the elements
* of the an array that was defined by the procedure
* TO_Array
*
* The name of of the array is passed to From_Array from
* the caller in the memvar CL_Bin
*
PARAMETERS CL_Bin

*------------------------------------------------
* CL_FldCnt will be number of fields in structure
* 
STORE FCount() TO CL_FldCnt

*--------------------------------------------------
* CL_FldPos will be the number of the current field
*
STORE 1 TO CL_FldPos

*-------------------------------------------------
* Move through the field structure.....
*
DO WHILE CL_FldPos<=CL_FldCnt
    
    *------------------------
    * Get the current field's name
    *
    STORE FIELDNAME(CL_FLdPos) TO CL_FldName
    
    *----------------------------
    * And insert it into the field
    * only if it is different from
    * what is there now
    *
    IF &CL_FldName # CL_Bin[CL_FldPos]
        
        REPLACE &CL_FldName WITH CL_Bin[CL_FldPos]
        
    ENDIF
    
    
    *----------------------------
    * Increment the field counter
    * 
    STORE CL_FldPos+1 TO CL_FldPos
    
ENDDO

RETURN
*
*
*


