*
*
*    Source File: WCD.PRG
*
*         System: WCD - Wright Change Directory
*         Author: John Wright
*   Copyright (c) 1995-1996 John Wright
*
*      Comments : Change directories across drives.
*                 Works with unlimited number of
*                 directories/drives.
*
*        Procedures : GoodBye
*                   : InfoScreen
*                   : AddDir
*                   : ChangeDir
*                   : CallBrowse
*                   : Force_main
*
*         Functions : GetSubDir
*                   : CountSubDirs
*                   : GetNext
*                   : DirPick
*
* Documented 01/02/96 at 20:00 FDOC Version 1.01b
*
* 12/10/95 - v1.0  Initial version of WCD program (Force 2.4c).
* 12/11/95 - v1.1  Minor change to display extra text during FIND.
* 12/20/95 - v1.2  Added option to process a list of directories.
*                  Added option to ignore directories during build.
*                  Added option to delete directories from database.
* 01/02/96 - v1.3  Recompiled with Force 2.4e to test new compiler.

*ͻ
* Subdirectory parsing functions are based on source code from the  
* DU, Directory Utilization, program released to the public domain. 
* (c) 1995 by Tim Holterhus                                         
*Ķ
* Database browsing functions based on BR_DEMO program included in  
* Force 2.4c SAMPLE directory (released to the public domain).      
*ͼ

* Ignore warnings from compiler
#PRAGMA  W_EXTERN-
#PRAGMA  W_FUNC_PROC-
#PRAGMA  W_INDIRECT-
#PRAGMA  W_MAC_REDEF-

* Not defined in Force 2.4e BROWSE.HDR file
#DEFINE  BROWSE_NIL         0
#DEFINE  BROWSE_REFRESH     1
#DEFINE  BROWSE_RESTART     2
#DEFINE  BROWSE_QUIT        3

* Include function/procedures
#INCLUDE browse.hdr
#INCLUDE database.hdr
#INCLUDE fileio.hdr
#INCLUDE io.hdr
#INCLUDE keys.hdr
#INCLUDE mouse.hdr
#INCLUDE screen.hdr
#INCLUDE string.hdr
#INCLUDE system.hdr

* Define main database
DBFDEF wcd
   CHAR(12)  dirname
   CHAR(80)  dirpath
ENDDEF

* Define main index
INDEXDEF
   CHAR(14) wcdindex wcd->dirname + SUBSTR( wcd->dirpath, 1, 2 )
ENDDEF

* Define temporary "skip" database
DBFDEF wcd_skip
   CHAR(80)  dirpath
ENDDEF

* Define temporary "skip" index
INDEXDEF
   CHAR(80) skip_wcd wcd_skip->dirpath
ENDDEF

* External declaration to allow "close" matches
VARDEF  EXTERN
   LOGICAL  __soft_seek := .F.
ENDDEF

* Define global variables instead of passing parameters
VARDEF
   BYTE      bColor[3] := 31,112,31
   CHAR      cDir
   CHAR(12)  cTheDir
   CHAR      cThePath
   CHAR(74)  cTitle[3]
   CHAR(74)  cFooter
   CHAR      cFields
   CHAR      cOptions
   CHAR      cWCDpath
   CHAR      cWCDsave
   FILE      fFileHand
   INT       nOldrow
   INT       nOldcol
   LOGICAL   lExitOkay  := .F.
   LOGICAL   lNewDir    := .F.
   LOGICAL   lSetMouse  := .F.
   LOGICAL   lSkipCheck := .F.
   LONG      nMatches
   LONG      nProcess
   UINT      uiDrv
   ULONG     ulTopRecord
   ULONG     ulBottomRecord
ENDDEF

*
*
*                   Procedure GoodBye
*
* Called by : InfoScreen
*           : ChangeDir
*           : Force_main
*
*   Purpose : Close database, display message and return
*             any errorlevel codes for DOS batch files.
*
*Parameters : Type      Method    Name
*           : INT       VALUE     nQuit
*           : CHAR      CONST     cText
*
*
PROCEDURE GoodBye
   PARAMETERS VALUE INT nQuit, CONST CHAR cText

   * Close WCD database
   CLOSE DATABASES

   * Erase temporary databases used to skip directories
   IF "/NEW" $ cOptions
      IF EXIST( cWCDpath + "wcd_skip.dbf" )
         DEL( cWCDpath + "wcd_skip.dbf" )
      ENDIF
      IF EXIST( cWCDpath + "wcd_skip.fdx" )
         DEL( cWCDpath + "wcd_skip.fdx" )
      ENDIF
   ENDIF

   * Check errorlevel
   IF nQuit < 0
      * Do NOT move cursor; DOS screen was updated by WCD
      nQuit := 0
   ELSE
      * Put cursor back where it was at startup
      @ nOldrow, nOldcol
   ENDIF

   * Display message (if passed)
   IF LEN( cText ) > 0
      ? cText
      ?
   ENDIF

   * Turn cursor back on
   CURSOR_ON()

   * Exit program with a return code
   QUIT nQuit

ENDPRO

*
*
*                   Procedure InfoScreen
*
* Called by : Force_main
*
*     Calls : GoodBye
*
*   Purpose : Display information about WCD
*
*Parameters :   none  
*
*
PROCEDURE InfoScreen
   
   CLEAR
   ??"͸"
   ? " WCD 1.3 - Wright Change Directory         (c) 1995-1996  John Wright "
   ? "Ĵ"
   ? "                                                                      "
   ? " WCD *                     Browse list of all directories             "
   ? " WCD dir                   Change to directory or browse list         "
   ? " WCD /ADD [drive:\dir]     Add directories and check for duplicates   "
   ? " WCD /DEL [drive:\dir]     Delete directories from WCD database list  "
   ? " WCD /NEW [drive:\dir]     Erase WCD database and add New directories "
   ? " WCD /FIND dir             Find directory name(s) within list         "
   ? " WCD /R                    Return to previous directory (if saved)    "
   ? "                                                                      "
   ? " WCD defaults to current directory if drive & path are not specified  "
   ? " for ADD, DEL or NEW.  DEL does not remove/delete directories in DOS. "
   ? "                                                                      "
   ? " FIND option will display a list of matches by scanning WCD database. "
   ? " Output from FIND can be redirected to a printer or text file.        "
   ? "                                                                      "
   ? " Use SET WCD= to specify location of WCD database if not using C:\.   "
   ? " Example: SET WCD=H:\ for network H: drive.  Previous directory       "
   ? " location is stored in C:\SAVE.WCD or SET WCD_SAVE= to another file.  "
   ? "                                                                      "
   ? ";"
   WAIT "Press any key for more information..."
   CLEAR
   ??"͸"
   ? " WCD 1.3 - Wright Change Directory         (c) 1995-1996  John Wright "
   ? "Ĵ"
   ? "                                                                      "
   ? " You can specify a list of directories to process by storing them in  "
   ? " a text file.  Example: WCD /ADD @newlist.txt  (Note: @ is required)  "
   ? "                                                                      "
   ? " There are two special files which can be used with the /NEW option.  "
   ? " The files must be located in C:\ or the path specified by SET WCD=.  "
   ? " SCAN.WCD should contain a list of drives:\directories to scan.       "
   ? " SKIP.WCD should contain a list of drives:\directories to skip.       "
   ? "                                                                      "
   ? " Refer to WCD.NET file for sample network batch file.  WCD returns    "
   ? " error levels which can be used in batch file processing.             "
   ? "                                                                      "
   ? " DOS errorlevel:  4  Error opening WCD database or text file          "
   ? "                  3  Invalid directory passed for processing          "
   ? "                  2  Directory not found in WCD database              "
   ? "                  1  Unable to change to directory                    "
   ? "                  0  Successful directory change or exit              "
   ? "                                                                      "
   ? " WCD is released as freeware.  No fee is required for use.  Enjoy!!!  "
   ? ";"
   ? ""
   QUIT 0

ENDPRO

*
*
*                   Procedure AddDir
*
* Called by : GetNext()
*           : Force_main
*
*   Purpose : Add a directory to WCD database
*
*Parameters :   none  
*
*
PROCEDURE AddDir
   
   ? cThePath + cTheDir
   
   * Make sure path is not too large for database
   IF LEN( cThePath ) <= 80
      
      IF "/ADD" $ cOptions .OR. "/DEL" $ cOptions
         lNewDir := .T.
         SEEK cTheDir
         
         * Make sure path is not already in database
         DO WHILE RTRIM( wcd->dirname ) == cTheDir
            IF RTRIM( wcd->dirpath ) == cThePath
               lNewDir := .F.
               IF "/DEL" $ cOptions
                  IF RLOCK()
                     REPLACE wcd->dirname WITH CHR(255), wcd->dirpath WITH CHR(255)
                     DELETE
                     UNLOCK
                     nProcess ++
                  ENDIF
               ENDIF
               EXIT
            ENDIF
            SKIP
         ENDDO
      ELSE
         lNewDir := .T.
      ENDIF
      
      IF lNewDir
         nProcess ++
         SEEK CHR(255)
         IF EOF()
            APPEND BLANK
         ELSE
            RLOCK()
            RECALL
         ENDIF
         REPLACE wcd->dirname WITH cTheDir, wcd->dirpath WITH cThePath
         UNLOCK
      ENDIF
      
   ENDIF
   
ENDPRO

*
*
*                    Function GetSubDir
*
*      Type : CHAR    
*
* Called by : GetNext()             
*
*   Purpose : Return Nth subdirectory name in a given directory.
*
*Parameters : Type      Method    Name
*           : CHAR      CONST     cDir
*           : UINT      VALUE     uiNum
*
*   Returns : CHAR     cName
*
*
FUNCTION CHAR GetSubDir
   PARAMETERS CONST CHAR cDir, VALUE UINT uiNum
   VARDEF
      CHAR(12)       cName
      UINT           uiCount
   ENDDEF
   
   uiCount := 0
   IF FIND_FIRST(cDir + "*.*", &FIND_SUBDIR)
      REPEAT
         IF FIND_FATTR() == &FIND_SUBDIR
            cName := FIND_FSTR()
            IF cName <> "." .AND. cName <> ".."
               uiCount++
               IF uiCount == uiNum
                  RETURN cName
               ENDIF
            ENDIF
         ENDIF
      UNTIL .NOT. FIND_NEXT()
   ENDIF
   RETURN ""

ENDPRO

*
*
*                    Function CountSubDirs
*
*      Type : UINT    
*
* Called by : GetNext()             
*           : Force_main            
*
*   Purpose : Return number of subdirectories in a given directory.
*             Will NOT find hidden or read-only directory name.
*
*Parameters : Type      Method    Name 
*           : CHAR      CONST     cDir
*
*   Returns : UINT     uiNum
*
*
FUNCTION UINT CountSubDirs
   PARAMETERS CONST CHAR cDir
   VARDEF
      CHAR(12)       cName
      UINT           uiNum
   ENDDEF
   
   uiNum := 0
   IF FIND_FIRST( cDir + "*.*", &FIND_SUBDIR )
      REPEAT
         IF FIND_FATTR() == &FIND_SUBDIR
            cName := FIND_FSTR()
            IF cName <> "." .AND. cName <> ".."
               uiNum++
            ENDIF
         ENDIF
      UNTIL .NOT. FIND_NEXT()
   ENDIF
   RETURN uiNum
   
ENDPRO

*
*
*                    Function GetNext
*
*      Type : CHAR    
*
* Called by : GetNext()             
*
*     Calls : AddDir
*           : CountSubDirs()
*           : GetSubDir()
*
*   Purpose : Processes subdirectories recursively.
*
*Parameters : Type      Method    Name
*           : CHAR      CONST     cDir
*           : UINT      VALUE     uiSubs
*
*   Returns : CHAR     uiNum
*
*
FUNCTION CHAR GetNext
   PARAMETERS CONST CHAR cDir, VALUE UINT uiSubs
   VARDEF
      CHAR(12)       cNext
      UINT           uiLoop
      UINT           uiMore
   ENDDEF
   
   FOR uiLoop := 1 TO uiSubs
      cNext := GetSubDir(cDir, uiLoop)
      IF "\" $ cNext
         cTheDir := SUBSTR( cNext, 1, AT( "\", cNext ) - 1 )
      ELSE
         * If a directory name is 12 characters Force does not return
         * a backslash!  This only happens if a directory has an extension.
         cTheDir := cNext
      ENDIF
      cThePath := cDir
      * Check directories to skip
      IF lSkipCheck
         SELECT wcd_skip
         cFields := cThePath + cTheDir
         SEEK cFields
         IF .NOT. EOF()
            * If this is an exact match then skip this directory
            IF cFields == RTRIM( wcd_skip->dirpath )
               cNext := ""
            ENDIF
         ENDIF
         SELECT wcd
      ENDIF
      * Continue processing
      IF LEN( cNext ) > 0
         * Add directory to WCD
         AddDir()
         uiMore := CountSubDirs( cDir + cNext )
         IF uiMore > 0
            GetNext( cDir + cNext, uiMore )  // here's the recursion
         ENDIF
      ENDIF
   NEXT uiLoop
   RETURN ""

ENDPRO

*
*
*                   Procedure ChangeDir
*
* Called by : CallBrowse
*           : Force_main
*
*     Calls : GoodBye
*
*   Purpose : Save current directory and change to new
*
*Parameters : Type      Method    Name 
*           : CHAR      CONST     cNewPath
*
*
PROCEDURE ChangeDir
   PARAMETERS CONST CHAR cNewPath
   
   * Grab current drive and directory
   uiDrv := CURDRIVE()
   cDir  := CHR(uiDrv + 65) + ":" + CURDIR(uiDrv + 1)
   
   IF CHDIR( cNewPath )
      * Change drive if not on correct one
      IF CHR( uiDrv + 65 ) <> SUBSTR( cNewPath, 1, 1 )
         uiDrv := ASC( SUBSTR( cNewPath, 1, 1 ) ) - 65
         * Force 2.4c has SELECT_DRIVE, 2.4e has SELECTDRIVE
         SELECTDRIVE( uiDrv )
      ENDIF
      * Erase old save file if exists
      IF EXIST( cWCDsave )
         ERASE cWCDsave
      ENDIF
      * Save old path for /R option to restore later
      IF F_OPEN( fFileHand, cWCDsave, &F_CREATE, &F_TEXT )
         F_PUT( fFileHand, cDir + CHR(10) + CHR(13) )
         F_CLOSE( fFileHand )
      ELSE
         GoodBye( 4, "Unable to create " + cWCDsave )
      ENDIF
   ELSE
      GoodBye( 1, "Unable to change to " + cNewPath )
   ENDIF

ENDPRO

*
*
*                    Function DirPick
*
*      Type : UINT
*
*   Purpose : Pick a directory while browsing
*
*Parameters : Type      Method    Name 
*           : ULONG     VALUE     ulAdress
*           : UINT      VALUE     uiCallType
*           : CHAR      REFERENCE cSayString
*
*   Returns : UINT     BROWSE_NIL
*
*
FUNCTION UINT DirPick
   PARAMETERS VALUE ULONG ulAdress, ;
      VALUE UINT  uiCallType, ;
      CHAR  cSayString
   
   * Push mouse cursor to upper left corner (defaults to center)
   IF .NOT. lSetMouse
      MOUSESETROWCOL( 0, 79 )
      lSetMouse := .T.
   ENDIF
   
   DO CASE
   CASE uiCallType = 0
      cSayString := wcd->dirname + "  " +  wcd->dirpath
      RETURN &BROWSE_NIL

   CASE uiCallType = 1              && Special keys
      
      DO CASE
         
      CASE LASTKEY() = &K_ENTER
         lExitOkay := .T.
         RETURN &BROWSE_QUIT
         
      CASE LASTKEY() = &K_ESC
         lExitOkay := .T.
         RETURN &BROWSE_QUIT
         
      CASE LASTKEY() = &K_C_PG_UP .OR. LASTKEY() = &K_C_HOME
         GOTO TOP
         RETURN &BROWSE_QUIT
         
      CASE LASTKEY() = &K_C_PG_DOWN .OR. LASTKEY() = &K_C_END
         GOTO BOTTOM
         RETURN &BROWSE_QUIT

      CASE LASTKEY() = &K_ALT_S
         cTheDir := SPACE(12)
         @ 03,03 SAY SPACE(76)
         CURSOR_ON()
         @ 03,03 SAY "Search for:" GET cTheDir PICTURE "@!"
         READ
         CURSOR_OFF()
         IF LASTKEY() <> &K_ESC
            SEEK RTRIM( cTheDir )
            IF EOF()
               __soft_seek := .T.
               SEEK RTRIM( cTheDir )
               __soft_seek := .F.
               SOUND( 200, 5 )
            ENDIF
         ENDIF
         RETURN &BROWSE_QUIT
         
      ENDCASE
      
   OTHERWISE
      RETURN &BROWSE_NIL
   ENDCASE
   
ENDPRO

*
*
*                   Procedure CallBrowse
*
* Called by : Force_main            
*
*     Calls : ChangeDir
*
*   Purpose : Call BROWSE() routine
*
*Parameters :   none
*
*
PROCEDURE CallBrowse

   * Setup browse variables
   cTitle[0] := "WCD 1.3 - Wright Change Directory"
   cTitle[1] := REPLICATE("",74)
   cTitle[2] := "[Enter] = change to directory  /  "+;
      "[Esc] = exit  /  [Alt]-[S] = search list"
   cFooter   := "Left mouse button to select (double-click)  /  Right mouse button to exit"
   cFields   := "Directory     Drive and preceding directory path"
   
   lExitOkay := .F.
   DO WHILE .NOT. lExitOkay
      * Move mouse to upper right corner (default is middle of screen)
      lSetMouse   := .F.
      * Browse directory list
      BROWSE( WCD, 7, 3, 21, 76, cTitle[], cFooter, cFields, ;
         bColor[], 1, ulTopRecord, ulBottomRecord, DirPick )
   ENDDO
   
   * Change directory!
   IF LASTKEY() == &K_ENTER
      DO ChangeDir WITH RTRIM( wcd->dirpath ) + RTRIM( wcd->dirname )
   ENDIF
   
ENDPRO

*
*
*                   Procedure Force_main
*
*     Calls : AddDir
*           : CallBrowse
*           : ChangeDir
*           : CountSubDirs()
*           : GetNext()
*           : GoodBye               
*           : InfoScreen
*
*   Purpose : Main program to manage WCD options.
*
*Parameters : Type      Method    Name 
*           : CHAR      CONST     cCmdLine
*
*
PROCEDURE Force_main
   PARAMETERS CONST CHAR cCmdLine
   
   VARDEF
      UINT      nSpot
   ENDDEF

   * This forces the runtime engine to read BIOS row/col positions.
   * Get current row/col information from SCRN_DIRECT screen driver.
   SCRN_DIRECT()
   nOldrow := ROW()
   nOldcol := COL()

   * Convert command line to upper case and trim spaces
   cOptions := LTRIM( RTRIM( UPPER( cCmdLine ) ) )
   
   * Display information about WCD
   IF "?" $ cOptions .OR. "/H" $ cOptions .OR. LEN( cOptions ) = 0
      InfoScreen()
   ENDIF

   CURSOR_OFF()

   * Check for WCD environment variable
   cWCDpath := GETENV("WCD")
   IF cWCDpath == ""
      * Check for C:\ drive
      IF FIND_FIRST( "C:\*.*", &FIND_ANYFILE )
         cWCDpath := "C:\"
      ENDIF
   ENDIF

   * Look for save file (default to C: drive)
   cWCDsave := GETENV("WCD_SAVE")
   IF cWCDsave == ""
      cWCDsave := "C:\SAVE.WCD"
   ENDIF
   
   * Option to Return to previous directory
   IF "/R" $ cOptions
      IF EXIST( cWCDsave )
         * Open file, read first line and change to directory
         IF F_OPEN( fFileHand, cWCDsave, &F_READ, &F_TEXT )
            F_GETLN( fFileHand, cThePath )
            F_CLOSE( fFileHand )
            DO ChangeDir WITH cThePath
         ELSE
            GoodBye( 4, "Unable to open "+cWCDsave+" file" )
         ENDIF
      ELSE
         GoodBye( 4, "Unable to locate "+cWCDsave+" file" )
      ENDIF
      GoodBye( 0, "" )
   ENDIF

   IF "/NEW" $ cOptions
      * Open files exclusively if building a new list
      SET EXCLUSIVE ON
      * Check for file to specify scan list
      IF EXIST( cWCDpath + "scan.wcd" )
         cOptions := "/NEW @" + cWCDpath + "scan.wcd"
      ENDIF
      * Check for file to specify skip/ignore list
      IF EXIST( cWCDpath + "skip.wcd" )
         * Read records
         cDir := cWCDpath + "skip.wcd"
         IF F_OPEN( fFileHand, cDir, &F_READ, &F_TEXT )
            ?"Reading list of directories to skip..."
            BUILD cWCDpath + "wcd_skip.dbf" FROM ALIAS wcd_skip
            OPEN cWCDpath + "wcd_skip.dbf" ALIAS wcd_skip
            REPEAT
               F_GETLN( fFileHand, cDir )
               IF LEN( cDir ) > 0
                  ?cDir
                  APPEND BLANK
                  REPLACE wcd_skip->dirpath WITH cDir
               ENDIF
            UNTIL F_EOF( fFileHand )
            F_CLOSE( fFileHand )
            SET ALIAS skip_wcd TO cWCDpath + "wcd_skip.fdx"
            INDEX skip_wcd
            lSkipCheck := .T.
         ELSE
            GoodBye( 4, "Unable to open "+ cDir + " for reading!" )
         ENDIF
      ENDIF
   ELSE
      * Open files in shared mode on networks
      SET EXCLUSIVE OFF
   ENDIF
   
   * Build database if not found
   IF .NOT. EXIST( cWCDpath + "wcd.dbf" )
      BUILD cWCDpath + "wcd.dbf" FROM ALIAS wcd
   ENDIF
   
   * Open WCD database
   OPEN cWCDpath + "wcd.dbf" ALIAS wcd
   
   * Check for network error
   IF NET_ERR() > 0
      GoodBye( 4, "Network error #: "+LTRIM( STR( NET_ERR(), 3, 0 ) ) +;
         "  -  " + cWCDpath + "WCD.DBF not opened." )
   ENDIF
   
   * Open index file
   SET ALIAS wcdindex TO cWCDpath + "wcd.fdx"
   IF EXIST( cWCDpath + "wcd.fdx" )
      SET INDEX TO wcdindex
   ELSE
      IF RECCOUNT() > 0
         ??"Creating WCD index..."
      ENDIF
      INDEX wcdindex
   ENDIF
   
   * Get first and last records
   IF RECCOUNT() > 0
      GOTO TOP
      ulTopRecord    := RECNO()
      GOTO BOTTOM
      ulBottomRecord := RECNO()
   ENDIF

   DO CASE
   CASE "/NEW" $ cOptions .OR. "/ADD" $ cOptions .OR. "/DEL" $ cOptions
      
      SCRN_DOS()
      
      * Erase records
      IF "/NEW" $ cOptions
         ZAP
      ENDIF

      * Setup variables
      nProcess  := 0
      lExitOkay := .T.
      
      DO CASE
      CASE "@" $ cOptions
         * Grab file name passed on command line
         nSpot := AT("@",cOptions) + 1
         cDir  := SUBSTR( cOptions, nSpot, LEN( cOptions ) - ( nSpot - 1 ) )
         IF EXIST( cDir )
            IF F_OPEN( fFileHand, cDir, &F_READ, &F_TEXT )
               F_GETLN( fFileHand, cDir )
               lExitOkay := .F.
            ELSE
               GoodBye( 4, "Unable to open "+ cDir + " for reading!" )
            ENDIF
         ELSE
            GoodBye( 4, cDir + " is not a valid file name!" )
         ENDIF
      CASE ":\" $ cOptions
         * Grab directory passed on command line
         nSpot := AT(":",cOptions) - 1
         cDir  := SUBSTR( cOptions, nSpot, LEN( cOptions ) - ( nSpot - 1 ) )
      OTHERWISE
         * Grab current drive and directory information
         uiDrv := CURDRIVE()
         cDir  := CHR(uiDrv + 65) + ":" + CURDIR(uiDrv + 1)
      ENDCASE
      
      * Create loop to process text file
      REPEAT
         
         * Check first directory against skip list
         IF lSkipCheck
            SELECT wcd_skip
            SEEK cDir
            IF .NOT. EOF()
               * If this is an exact match then skip this directory
               IF cDir == RTRIM( wcd_skip->dirpath )
                  cDir := ""
               ENDIF
            ENDIF
            SELECT wcd
         ENDIF
         
         * Add to database if not in Root directory
         IF LEN(cDir) > 3
            IF .NOT. FIND_FIRST( cDir + "\*.*", &FIND_ANYFILE )
               IF "@" $ cOptions
                  ?cDir + " is not a valid directory!"
                  cDir := ""
               ELSE
                  GoodBye( 4, cDir + " is not a valid directory!" )
               ENDIF
            ENDIF
            cTheDir  := SUBSTR( cDir, RAT( "\", cDir ) + 1, 12 )
            cThePath := SUBSTR( cDir, 1, RAT( "\", cDir ) )
            * Add directory to WCD
            AddDir()
            * Append backslash to directory name
            cDir += "\"
         ENDIF
         
         * Process subdirectories
         IF LEN( cDir ) > 0
            GetNext( cDir, CountSubDirs(cDir) )
         ENDIF
         
         * Check for more lines to process
         IF "@" $ cOptions
            IF .NOT. F_EOF( fFileHand )
               F_GETLN( fFileHand, cDir )
            ELSE
               F_CLOSE( fFileHand )
               lExitOkay := .T.
            ENDIF
         ENDIF
         
      UNTIL lExitOkay
      
      * Display number of matches
      ?
      ? LTRIM( STR( nProcess, 9, 0 ) ) + " directories "
      IF "/DEL" $ cOptions
         ??"deleted from WCD list"
      ELSE
         ??"added to WCD list  ( "
         ?? LTRIM( STR( RECCOUNT(), 9, 0 ) ) + " total ) "
      ENDIF
      GoodBye( -1, "" )
      
   CASE RECCOUNT() = 0
      GoodBye( 1, "There are no directories in WCD database!" )
      
   CASE "/FIND " $ cOptions
      nMatches := 0
      nProcess := 0
      nSpot    := AT(" ",cOptions) + 1
      cDir     := SUBSTR( cOptions, nSpot, LEN( cOptions ) - ( nSpot - 1 ) )
      
      SCRN_DOS()
      
      ?"WCD find => " + cDir + " <= within directory name   ( Esc to exit )"
      ?

      * Have to issue this or whole file is not processed!
      GOTO TOP

      DO WHILE .NOT. EOF() .AND. INKEY() <> 27
         IF cDir $ wcd->dirname
            ?wcd->dirname + " -> " + RTRIM( wcd->dirpath ) + wcd->dirname
            nMatches ++
         ENDIF
         nProcess ++
         SKIP
      ENDDO
      
      ?
      ? LTRIM( I_STR( nMatches ) ) + " matches found out of "
      ?? LTRIM( STR( nProcess, 8, 0 ) ) + " directories."
      
      GoodBye( -1, "" )
      
   CASE cOptions == "*"
      SET DELETE ON
      GOTO TOP
      CallBrowse()

   OTHERWISE
      SET DELETE ON
      nProcess := RECNO()
      !wcd SEEK cOptions
      IF EOF()
         GoodBye( 2, cOptions + " not found in " + cWCDpath + "WCD.DBF"  )
      ELSE
         nProcess := RECNO()
         SKIP
         IF wcd->dirname = cOptions
            GOTO nProcess
            CallBrowse()
         ELSE
            GOTO nProcess
            DO ChangeDir WITH RTRIM( wcd->dirpath ) + RTRIM( wcd->dirname )
         ENDIF
      ENDIF
      
   ENDCASE
   
   GoodBye( 0, "" )
   
ENDPRO

*:   EOF: WCD.PRG
