
/*
    Use MSC Ver 6.0 to recompile
*/
/*
 * File......   : VOLUME.C
 * Author....   : Peter Kulek
 * Date......   : $Date:   26 Jun 1992  $
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * And is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 */

/*
The following DOS INT 21h functions may be used to set or determine the serial
number (taken from Ralf Brown's INTERRUPT listing):

INT 21 - DOS 3.2+ - IOCTL - GENERIC BLOCK DEVICE REQUEST
        AX = 440Dh
        BL = drive number (00h=default,01h=A:,etc)
        CX = 0846h      - set volume serial number
        CX = 0866h      - get volume serial number

DS:DX
Offset  Size    Description
 00h    WORD    info level (00h)
 02h    DWORD   disk serial number (binary)
 06h 11 BYTEs   volume label or "NO NAME    "
 11h  8 BYTEs   file system type "FAT12   " or "FAT16   " (CL=66h only)

Return: CF set on error            AX = error code
        CF clear if successful
*/

#include "extend.api"
#include "fm.api"
#include "exoapi.h"


#define UPPER       ('a' - 'A')
#define islower(p)   ( 'a' <= (p) && (p) <= 'z' )
#define toupper(p)   ( islower(p) ? ((p) - UPPER) : ((p)) )

CLIPPER  Volume() {
    char *name ;
    unsigned int iDrive = ISNUM(1) ? _parni(1) : 0 ;
    int iCX = 2150 ;
    int iReturn = 0;
    int iFree  = 0;
    if ISCHAR(1) {
    	iDrive = toupper(_parc(1)[0]) - 64 ;
    }
    if (ISCHAR(2) && (_parclen(2) == 25) ) {
        iCX = 2118 ;
        name = _parc(2);
    } else {    
        iFree = 1;
        name = _xalloc(25) ;
    }
    _asm{
          push    ds    
          push    dx    
          push    cx    
          
          lds     dx,[name]   ;  load name address in DS:DX
          
          mov     AX,440Dh  
          MOV     BX,iDrive
          MOV     CX,iCX   
          int     21h       

          JNC      noerror

          MOV     iReturn,AX
noerror:

          pop     cx        
          pop     dx        
          pop     ds        
    }
    _retc("");
    if ( iReturn == 0  ){
        _retclen(name,25);
    }
    if (iFree) {
        _xfree(name);
    }
}




