//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//                VISUAL ENGINE FOR CLIPPER TUTOR ( MULTITASKING )
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veColors.ch"

#define cBall   Chr( 20 ) + Chr( 21 )

//-----------------------------------------------------------------------//

static nIDClk,  ;          // Identifier for Clock    background procedure
       nIDBall, ;          //    "        "  Ball         "         "
       nIDWP               //    "        "  WallPaper    "         "

static nMaxBallSpeed := 100    // Maximum ball speed

//-----------------------------------------------------------------------//

function MultiTask()

   /*------------------------
     See previous chapters to know why this part is REM

     INIT SYSTEM         
   ------------------------*/

   Clock()
   Ball()
   WallPaper()
   Desktop()

   /*---------------------------
     See previous chapters to know why this part is REM

   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

return nil

//-----------------------------------------------------------------------//
// Controlling the multitasking environment

static function Desktop()

   local btnClock, btnWP
   local wndDesk, nBallSpeed
   local lClock := .T.
   local lWP    := .T.

   CREATE WINDOW wndDesk      ;
          FROM  8, 4 TO 18,29 ;
          TITLE "Desktop"     ;
          ON CLOSE StopWP()   ;
          NO HELPLINE

   @  1, 2 SPINNER nBallSpeed     ;
           RANGE   1, 100         ;
           PROMPT  "&Ball speed " ;
           PICTURE "999"          ;
           INITIAL 90             ;
           ACTION  nMaxBallSpeed := 100 - nBallSpeed

   @  4, 2 BUTTON btnClock             ;
           PROMPT "   Stop &clock   "  ;
           ACTION ( Clock( lClock := ! lClock ), ;
                    btnClock:SetPrompt( If( lClock, ;
                            "   Stop &clock   ", "    Go  &clock   " ) ) )

   @  7, 2 BUTTON btnWP                ;
           PROMPT " Stop &WallPaper "  ;
           ACTION ( WallPaper( lWP := ! lWP ), ;
                    btnWP:SetPrompt( If( lWP, ;
                            " Stop &WallPaper ", "  Go  &WallPaper " ) ) )

   OPEN WINDOW wndDesk

   LessonWnd( wndDesk )                // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
//                        CLOCK ROUTINES
//-----------------------------------------------------------------------//

static function Clock( lOn )

   static wndClock

   if lOn == nil                                           // initiating
      CREATE WINDOW wndClock         ;
             FROM  1, 9 TO  5,20     ;
             TITLE "Clock"           ;
             ICON TITLE "          " ;
             ON CLOSE   StopClock()  ;
             NO RESIZE  NO MAXIMIZE  NO HELPLINE

      OPEN WINDOW wndClock

      LessonWnd( wndClock )               // For internal tutor use only
   endif

   if ( lOn == nil .or. lOn )
      nIDClk = App():oServer:AddBackProc( { || ShowClock( wndClock ) } )
   else
      App():oServer:DelBackProc( nIDClk )
   endif

return nil

//-----------------------------------------------------------------------//
// this backgroud process will display clock

static function ShowClock( oWnd )

   static cTime   := ""
   local  nOldWnd := VWSetOut( oWnd:nHandle, ;  // chages wnd video output
                               oWnd:nStatus == WND_STAT_MINIMIZED )  

   if cTime != Time()
      @ 1,1 veSAY ( cTime := Time() )                        ;
            COLOR If( oWnd:nStatus == WND_STAT_MINIMIZED,    ;
                      oWnd:aColor[ If( oWnd:lFocused,        ;
                                       WND_CLR_ICON_ON,      ;
                                       WND_CLR_ICON_OFF ) ], ;
                      oWnd:COLOR_HIGH )
      if oWnd:nStatus != WND_STAT_MINIMIZED
         @ 2,1 veSAY DtoC( Date() )      COLOR oWnd:COLOR_HIGH
      endif
   endif

   VWSetOut( nOldWnd )              // restores previous wnd video output

return nil

//-----------------------------------------------------------------------//
// this filter deactivates the BackGround process at window close

static function StopClock()

   App():oServer:DelBackProc( nIDClk )

return .F.     // .F. -> message will be processed by its default action

//-----------------------------------------------------------------------//
//                        BALL ROUTINES
//-----------------------------------------------------------------------//
static function Ball()

   local wndBall

   CREATE WINDOW wndBall          ;
          FROM  2,42 TO 22,75     ;
          TITLE "Ball"            ;
          VIRTUAL 24, 79          ;
          ON CLOSE   CloseBall()  ;
          NO HELPLINE

   OPEN WINDOW wndBall

   nIDBall = App():oServer:AddBackProc( { || ShowBall( wndBall ) } )

   LessonWnd( wndBall )               // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
// this backgroud process will display the ball moving inside the window

static function ShowBall( oWnd )

   static y      := 0,;
          x      := 0,;
          nIncY  := 1,;
          nIncX  := 2,;
          lInit  := .T.,;
          nCount := 101

   local nOldWnd 

   if nCount++ < nMaxBallSpeed
      return nil
   endif

   nCount  = 1
   nOldWnd = VWSetOut( oWnd:nHandle )           // changes wnd video output

   SetPos( y, x )                           // you can use standard clipper
   DevOut( "  ", "W+/B" )                   // functions if you want

   y += nIncY
   x += nIncX

   if( y < 0 .or. y > oWnd:wBottom() - oWnd:wTop() - 2 )
      y += If( y < 0, 1, -1 )
      nIncY *= -1
   endif

   if (x < 0 .or. x+1 > oWnd:wRight() - oWnd:wLeft() - 3 )
      x += If( x < 0, 2, -2 )
      nIncX *= -1
   endif

   @ y,x SAY cBall COLOR "W+/B"    // you can use standard clipper commands

   VWSetOut( nOldWnd )                         // restores wnd video output

return nil

//-----------------------------------------------------------------------//
// this filter disactivates the background process at window close

static function CloseBall()

   App():oServer:DelBackProc( nIDBall )

return .F.             // .F. == not processed => Window will be closed

//-----------------------------------------------------------------------//
//                      WALLPAPER ROUTINES
//-----------------------------------------------------------------------//
// As wndRoot ( WallPaper ) always exist, we don't need to create it

static function WallPaper( lOn )

   if ( lOn == nil .or. lOn )
      nIDWP = App():oServer:AddBackProc( { || ShowWP() } )
   else
      App():oServer:DelBackProc( nIDWP )
   endif

return nil

//-----------------------------------------------------------------------//

static function ShowWp()

   local nOldWnd := VWSetOut( WND_ID_ROOT )   // changes wnd video output
   local cColor  := SetColor( "B+/N" )

   QQOut( " Visual Engine For Clipper " )

   VWSetOut( nOldWnd )                         // restores wnd video output
   SetColor( cColor )

return nil

//-----------------------------------------------------------------------//

static function StopWP()

   App():oServer:DelBackProc( nIDWP )
   App():SetWallPaper()

return .F.              // .F. == not processed => Window will be closed

//-----------------------------------------------------------------------//
