//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//            VISUAL ENGINE FOR CLIPPER TUTOR  (CONTROL FILTERING)
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//

function CtrlFilter()

   local wndFilter, cBoxType

   /*------------------------
     See previous chapters to know why this part is REM

     INIT SYSTEM         
   ------------------------*/

   CREATE WINDOW wndFilter FROM 1,22 TO 8,59         ;
                 TITLE "Filtering controls messages" ;
                 ON OPEN WriteMsg( wndFilter )       ; 
                 NO HELPLINE

   @ 4,2 GET cBoxType PROMPT "Box Type "    ;
         INITIAL Space( 8 )                 ;
         FILTER { |aMsg| MyFilter( aMsg ) } ;
         OF wndFilter

   OPEN WINDOW wndFilter   


   /*---------------------------
     See previous chapters to know why this part is REM

   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

   LessonWnd( wndFilter )                  // For internal tutor use only

return nil

//-----------------------------------------------------------------------//

static func WriteMsg( oWnd )

   @ 1,2 veSAY "This get field only accept box"  COLOR oWnd:COLOR_LOW
   @ 2,2 veSAY "characters. ( ASCII  179-218 )"  COLOR oWnd:COLOR_LOW

   // This messages will be written in the window before controls
   // Both appear instantaneously when the window is opened

return nil

//-----------------------------------------------------------------------//
// if a filter exists, all the messages will be sent to the filter instead
// of the control. The filter can: Process it and/or Change it or ignore.
// The message will be sent to the control if the filter returns .F.,
// and not sent if returns .T.

static func MyFilter( aMsg )

   if aMsg[ EVT_TYPE ] == EVT_TYPE_KEY

      // this filter will not process non editable keys (i.e. Alt-F4)
      if aMsg[ EVT_INFO ] >= 32 .and. aMsg[ EVT_INFO ] <= 255

         if aMsg[ EVT_INFO ] >= 179 .and. aMsg[ EVT_INFO ] <= 218
            return .F.                   // not processed == accep this key
         else
            return .T.                   // processed == discard this key
         endif

      else
         return .F.                  // The control will process other keys
      endif

   endif

return .F.   // Other event (i.e. mouse) will not be processed by this
             // filter. So we return .F. and the control will process them.

//-----------------------------------------------------------------------//
