//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//                VISUAL ENGINE FOR CLIPPER TUTOR (WINDOW MSG FILTER)
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//

function WndFilter()

   local wndFilter

   /*------------------------
     See previous chapters to know why this part is REM

     INIT SYSTEM         
   ------------------------*/

   CREATE WINDOW wndFilter FROM 2,24 TO 7,56        ;
                 TITLE "Filtering window messages"  ;
                 NO HELPLINE                        ;
                 FILTER { |aMsg| MyFilter( aMsg ) }

   OPEN WINDOW wndFilter                // First to write, open the window

   @ 1,2 veSAY "To test the filter, try"  COLOR wndFilter:COLOR_LOW
   @ 2,2 veSAY "to close the window."     COLOR wndFilter:COLOR_LOW


   /*---------------------------
     See previous chapters to know why this part is REM

   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

   LessonWnd( wndFilter )              // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
// if a filter exists, all the messages will be sent to the filter instead
// of the window. The filter can: Process it and/or Change it or ignore.
// The message will be sent to the window if the filter returns .F.,
// and not sent if returns .T.

static func MyFilter( aMsg )

   local lProcessed := .F.

   if aMsg[ EVT_MSG ] == MSG_WND_CLOSE
      lProcessed = ! ( veAlert( "Are you sure you want;to close the window ?", ;
                               { "&Yes", "&No" } ) == 1 )
   endif

return lProcessed

//-----------------------------------------------------------------------//
