//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//        VISUAL ENGINE FOR CLIPPER TUTOR ( MESSAGES AMONG WINDOWS )
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veMouse.ch"
#include "veWindow.ch"
#include "veColors.ch"

//-----------------------------------------------------------------------//

function WndMsg()

   local wndMsg1, wndMsg2, wndMsg3


   CREATE WINDOW wndMsg3  FROM  1,43 TO  6,79 ;
          TITLE "Sending messages to server"

   @  1, 1 BUTTON " Select Wnd&1 "          ;
           EXECUTE  WND_SELECT( wndMsg1 )   ;
           HELPLINE "Changes focus to Wnd1" ;
           OF       wndMsg3


   @  1,18 BUTTON " Select Wnd&2 "          ;
           EXECUTE  WND_SELECT( wndMsg2 )   ;
           HELPLINE "Changes focus to Wnd2" ;
           OF       wndMsg3

 //------------------------------------------------//

   CREATE WINDOW  wndMsg2 FROM 0,0 TO  7,20  ;    // Actual window size
          VIRTUAL 35, 99                     ;    // Maximum window size
          TITLE  "Receiving messages window" ;
          NO HELPLINE

 //-----------------------------------------------//

   CREATE WINDOW wndMsg1 FROM 2,6 TO  9,73 ;
          TITLE "Sending messages window"

   CtrlsWnd1( wndMsg1, wndMsg2 )                  // Loads Ctrls for Wnd1

 //-----------------------------------------------//

   OPEN WINDOW wndMsg3
   OPEN WINDOW wndMsg2
   OPEN WINDOW wndMsg1

 //-----------------------------------------------//

   LessonWnd( wndMsg1 )                // For internal tutor use only
   LessonWnd( wndMsg2 )                // For internal tutor use only
   LessonWnd( wndMsg3 )                // For internal tutor use only

return nil

//----------------------------------------------------------------------------//

static function CtrlsWnd1( oWnd1, oWnd2 )

   local nRow, nCol, nHeight, nWidth

   @  1, 1 SPINNER  nRow                                   ;
           RANGE    0, 24 STEP 1                           ;
           INITIAL  0                                      ;
           PROMPT   "Wnd&Row "                             ;
           PICTURE  "99"                                   ;
           ACTION   If( oWnd2 != nil, oWnd2:Move( nRow ),) ;
           HELPLINE "Changes the row of Wnd2"              ;
           OF       oWnd1

   @  1,16 SPINNER  nCol                                     ;
           RANGE    0, 79 STEP 1                             ;
           INITIAL  0                                        ;
           PROMPT   "WndCo&l "                               ;
           PICTURE  "99"                                     ;
           ACTION   If( oWnd2 != nil, oWnd2:Move( , nCol ),) ;
           HELPLINE "Changes the col of Wnd2"                ;
           OF       oWnd1

   @  1,31 SPINNER  nHeight                                   ;
           RANGE    5, 50  STEP 1                             ;
           INITIAL  8                                         ;
           PROMPT   "Wnd&Height "                             ;
           PICTURE  "99"                                      ;
           ACTION   If( oWnd2 != nil, oWnd2:Size( nHeight ),) ;
           HELPLINE "Changes height of Wnd2"                  ;
           OF       oWnd1

   @  1,49 SPINNER  nWidth                                     ;
           RANGE    8, 79 STEP 1                               ;
           INITIAL  21                                         ;
           PROMPT   "Wnd&Width "                               ;
           PICTURE  "99"                                       ;
           ACTION   If( oWnd2 != nil, oWnd2:Size( , nWidth ),) ;
           HELPLINE "Changes width of Wnd2"                    ;
           OF       oWnd1

   @  3, 1 BUTTON " &Restore "        ;
           EXECUTE  Restore( oWnd2 )  ;
           HELPLINE "Restores Wnd2"   ;
           OF       oWnd1

   @  3,24 BUTTON " &Minimize "       ;
           EXECUTE  Minimize( oWnd2 ) ;
           HELPLINE "Minimizes Wnd2"  ;
           OF       oWnd1

   @  3,49 BUTTON " Ma&ximize "       ;
           EXECUTE  Maximize( oWnd2 ) ;
           HELPLINE "Maximizes Wnd2"  ;
           OF       oWnd1

return nil

//----------------------------------------------------------------------------//

static function Restore( oWnd )

   if oWnd != nil .and. oWnd:nStatus != WND_STAT_CLOSED
      App():oServer:Message( { EVT_TYPE_WND, oWnd, MSG_WND_RESTORE } )
   endif

return nil

//----------------------------------------------------------------------------//

static function Minimize( oWnd )

   if oWnd != nil .and. oWnd:nStatus != WND_STAT_CLOSED
      App():oServer:Message( { EVT_TYPE_WND, oWnd, MSG_WND_MINIMIZE } )
   endif

return nil

//----------------------------------------------------------------------------//

static function Maximize( oWnd )

   if oWnd != nil .and. oWnd:nStatus != WND_STAT_CLOSED
      App():oServer:Message( { EVT_TYPE_WND, oWnd, MSG_WND_MAXIMIZE } )
   endif

return nil

//----------------------------------------------------------------------------//
