//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//              VISUAL ENGINE FOR CLIPPER TUTOR ( MULTIPLE WINDOWS )
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veColors.ch"

#define  BACK  .F.
#define  FRONT .T.

//-----------------------------------------------------------------------//

function MultiWnd()

   local wndMulti      // declarating a var for an object of TWindow class

   /*----------------------
     Refer to chapter 2 to know about this command.
     It is in a REM area because VEC Tutor made it at start up

   INIT SYSTEM
   -----------------------*/

   CREATE WINDOW wndMulti FROM 2,14 TO 10,62 ;
                 TITLE "Multiple Windows"    ;
                 ICON TITLE "MultiWnds"

   @ 4, 5 BUTTON   " Open &Back "              ;
          HELPLINE "Open a new window on back" ;
          ACTION   CreateWnd( BACK )           ;
          OF       wndMulti

   @ 4,25 BUTTON   " Open &Front "            ;
          HELPLINE "Open a new window on top" ;
          ACTION   CreateWnd( FRONT )         ;
          OF       wndMulti

   OPEN WINDOW wndMulti                 // First to write, open the window

   LessonWnd( wndMulti )                // For internal tutor use only

   // We prefer to use  @ veSAY...  because it is faster and more flexible

   @ 1,2 veSAY "Number of opened windows depends only of" ;
         COLOR wndMulti:COLOR_LOW
   @ 2,2 veSAY "of the amount of free memory you have."   ;
         COLOR wndMulti:COLOR_LOW

   /*----------------------------------------------------------------------
   // Now the Event System will work until all the windows that have been
   // created and opened (wherever in the program) have been closed.

   ACTIVATE WINDOWS                    // This command activates all wnds
                                       // that have been previously opened,
                                       // and the event system.
                                       // This command is used only once

   DEINIT SYSTEM                       // Code will araise here when all
                                       // windows have been closed.

   // Both commands are in a REM area to avoid crashes with the "VEC Tutor"
   ----------------------------------------------------------------------*/

return nil

//-----------------------------------------------------------------------//

#undef BACK
 
static func CreateWnd( lFront )

   static nCount := 1
   local  nRow   := Min( nCount * 8, 72 ) - 8
   local  wndNew, nWndVideo

   CREATE WINDOW wndNew FROM  0, nRow TO  6, nRow+15 ;
                 TITLE "New window"                  ;
                 ICON TITLE PadC( nCount, 7 )        ;
                 NO HELPLINE                    // As there aren't controls
                                              // or menu, don't need HelpLine

   if lFront
      OPEN WINDOW wndNew
   else
      OPEN WINDOW wndNew BACK                // As this wnd is opened back,
      nWndVideo = VWSetOut( wndNew:nHandle ) // we need to change the output
   endif                                     // to our new wnd

   @ 1,1 veSAY "I'm window "                        COLOR wndNew:COLOR_LOW
   @ 2,1 veSAY "number " + LTrim( Str( nCount++ ) ) COLOR wndNew:COLOR_LOW

   if nWndVideo != nil                      // After paint in a back wnd,
      VWSetOut( nWndVideo )                 // we have to restore the
   endif                                    // output to the one who had it

   //---------------------------------------//

   LessonWnd( wndNew )                      // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
