//-----------------------------------------------------------------------//
//  (c) 1992-3 Peyrona Soft
//  Autor: Manolo Caracuel Urbano
//         Francisco Morero Peyrona
//
//               VISUAL ENGINE FOR CLIPPER TUTOR: GENERIC DBF MANAGER
//-----------------------------------------------------------------------//

#include "Inkey.ch"
#include "DbStruct.ch"
#include "veSystem.ch"
#include "veWindow.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veMouse.ch"
#include "vePopUp.ch"
#include "veColors.ch" 

//-----------------------------------------------------------------------//

function Client()
   
   local bEditRec := { |aTemp, lAppend| EditClient( aTemp, lAppend ) }
   local oBrw, tbcTemp

   /*--------------------------
   INIT SYSTEM
   --------------------------*/

   oBrw = DbfMgr( "Clients", bEditRec )
   
   // Modify specific columns of the browse
   tbcTemp = oBrw:oBrw:GetColumn( 5 )            // Priority Field
   tbcTemp:block = PriorityBlock( tbcTemp:block )
   tbcTemp:width = 8
   oBrw:oBrw:Configure()

   /*--------------------------
   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

return nil

//-----------------------------------------------------------------------//

static function EditClient( aTemp, lAppend )

   local wndEdit, ;
         lModify := .F.

   MChgCrs( MS_CRS_SAND_CLOCK )

   CREATE WINDOW wndEdit FROM  4,15 TO 18,63           ;
          TITLE "Editing Record " + PadL( Recno(), 4 ) ;
          AUTOSCROLL                                   ;
          ON CLOSE ( App():oServer:EndModal(), .F. )

   @  1, 1 GET      aTemp[ 1 ]  PROMPT "Compa&ny " ;
           HELPLINE "Enter the name of the company"

   @  3, 1 GET      aTemp[ 2 ]  PROMPT "&Address " ;
           HELPLINE "Enter the adress of the company"

   @  5, 1 GET      aTemp[ 3 ]  PROMPT "&Phone   " ;
           HELPLINE "Enter company phone number"

   @  5,27 GET      aTemp[ 4 ]  PROMPT "&Fax  " ;
           HELPLINE "Enter company fax number"

   @  7,25 CHECKBOX aTemp[ 6 ]  PROMPT "&Dealer company " ;
           HELPLINE "Is this client a dealer of us ?"

   @  7, 1 RADIO    aTemp[ 5 ]                         ;
           ITEMS    "&High   ", "&Medium ", "Lo&w    " ;
           PROMPT   " Priority "                       ;
           HELPLINE "Very important client",           ;
                    "Important client",                ;
                    "Defenitly, hes not a good client"

   @ 10,17 BUTTON   "    &Ok    "                             ;
           ACTION   ( lModify := .T. , WND_CLOSE( wndEdit ) ) ;
           HELPLINE "Close window saving changes"

   @ 10,32 BUTTON   "  &Cancel  "        ;
           ACTION   WND_CLOSE( wndEdit ) ;
           HELPLINE "Close window discarding changes"

   OPEN WINDOW wndEdit MODAL           // you have to do it MODAL to avoid
                                       // a new open while editing
   MChgCrs( MS_CRS_ARROW )

   App():oServer:BeginModal()

return lModify

//-----------------------------------------------------------------------//

static function SearchClient( oDbfBrw, oWnd )

   veAlert( If( lEsp(), "Aqu ira su rutina de bsqueda", ;
                        "Here goes your searching rountine" ) )

return nil

//-----------------------------------------------------------------------//
//                      GENERIC DATA BASE MANAGER
//-----------------------------------------------------------------------//

function DbfMgr( cAlias, bEditRec )

   local cBrwClr := ",,,,W+/B,N/W,GR+/BG,,"
   local wndDbf, oBrw
   local bDelete := { |oBrw|  If( (cAlias)->( Deleted() ),    ;
                                  (cAlias)->( DbRecall() ),   ;
                                  (cAlias)->( DbDelete() ) ), ;
                                  oBrw:oBrw:RefreshAll() }

   USE (cAlias) NEW

   CREATE WINDOW wndDbf FROM  1, 5 TO 14,73                     ;
          VIRTUAL 22,79                                         ;
          TITLE cAlias + " Manager"   NO HELPLINE               ;
          ON CLOSE ( (cAlias)->(DbCloseArea()), .F. )

   //------------------------------------------------------------------//

   DEFINE POPUP MENU OF wndDbf
      ADD ITEM   LABEL   "  &Edit  "

      DEFINE MENU
         ADD ITEM   LABEL    " &Modify  F2"             ;
                    SHORTCUT K_F2                       ;
                    ACTION   Edit( oBrw, bEditRec )

         ADD ITEM   LABEL    " &Search  F3"             ;
                    SHORTCUT K_F3                       ;
                    ACTION   SearchClient( oBrw, wndDbf )

         ADD ITEM   LABEL    " &Add     F4 "              ;
                    SHORTCUT K_ALT_F3                     ;
                    ACTION   Append( cAlias, bEditRec, oBrw )

         ADD ITEM   LABEL    " &Delete  Ctrl-F4 "             ;
                    SHORTCUT K_CTRL_F4                        ;
                    ACTION  Eval( bDelete, oBrw )
      END MENU

      ADD ITEM   LABEL  "  &Move  "

      DEFINE MENU
         ADD ITEM   LABEL    " &First    F5 "       ;
                    SHORTCUT K_F5                   ;
                    ACTION   oBrw:oBrw:GoTop()

         ADD ITEM   LABEL    " &Last     F6 "       ;
                    SHORTCUT K_F6                   ;
                    ACTION   oBrw:oBrw:GoBottom()
      END MENU

      ADD ITEM LABEL    "  &Utilities  "

          DEFINE MENU
             ADD ITEM LABEL    " &Reindex "                ;
                      ACTION   (cAlias)->( DbReindex() )

             ADD ITEM LABEL    " &Pack "                  ;
                      ACTION   ( (cAlias)->( __DbPack() ),;
                                 oBrw:oBrw:RefreshAll() )
          END MENU
   END MENU

   //------------------------------------------------------------------//

   BROWSE oBrw USING DATABASE (cAlias)                            ;
               LOAD COLUMNS                                       ; 
               ON KEY { |oDbfBrw, nKey|                           ;
                        KeyStrokes( oDbfBrw, nKey,                ; 
                                 { |oDbfBrw| Append( cAlias,      ;
                                                     bEditRec,    ;
                                                     oDbfBrw ) }, ;
                                 { |oDbfBrw| Edit( oBrw,          ;
                                                   bEditRec ) },  ;
                                 bDelete ) }                      ;
               ON EDIT { |oDbfBrw, oWnd| Edit( oBrw, bEditRec ) } ;
               COLOR cBrwClr                                      ;
               STATLINE                                           ;
               ACTION RefStatLine( oBrw, cAlias )                 ;
               OF wndDbf
   
   OPEN WINDOW wndDbf

   //------------------------------------------------------------------//

   LessonWnd( wndDbf )                   // For internal tutor use only

return oBrw

//-------------------------------------------------------------------------//

static func PriorityBlock( bBlock )

   local aPriority := { "High",   ;
                        "Medium", ; 
                        "Low" } 
                        
return { || If( Eval( bBlock ) == 0, " ", aPriority[ Eval( bBlock ) ] ) }

//-------------------------------------------------------------------------//

static func RefStatLine( oBrw, cAlias )
   
   @ oBrw:oBrw:nBottom + 1, 1 veSAY If( (cAlias)->(Deleted()), ;
                                                 "<Deleted>",  ;
                                                 "         " ) ;
                              COLOR oBrw:wndParent:COLOR_HIGH
                                                      
return nil

//-------------------------------------------------------------------------//

func KeyStrokes( oDbfBrw, nKey, bAppend, bEdit, bDelete )

   DEFAULT bDelete := { || nil }

   do case
      case nKey == K_INS    ;  Eval( bAppend, oDbfBrw )
      case nKey == K_ENTER  ;  Eval( bEdit,   oDbfBrw )
      case nKey == K_DEL    ;  Eval( bDelete, oDbfBrw )
   otherwise
      return .F.                                   // key not processed
   endcase

return .T.                                         // key processed

//----------------------------------------------------------------------------//

func BlankRecord( cAlias )

   local aStruct := (cAlias)->(DBStruct())
   local aBlank := {}
   local i

   for i = 1 to (cAlias)->(FCount())
      do case
         case aStruct[ i, DBS_TYPE ] == "C"
              AAdd( aBlank, Space( aStruct[ i, DBS_LEN ] ) )
         case aStruct[ i, DBS_TYPE ] == "N"
              AAdd( aBlank, 0 )
         case aStruct[ i, DBS_TYPE ] == "L"
              AAdd( aBlank, .F. )
         case aStruct[ i, DBS_TYPE ] == "D"
              AAdd( aBlank, CtoD( "" ) )
      endcase
   next

return aBlank

//----------------------------------------------------------------------------//

func Append( cAlias, bEdit, oBrw, aIni )

   local aTemp := BlankRecord( cAlias )
   local i

   if aIni != nil
      AEval( aIni, { |aItem| aTemp[ aItem[ 1 ] ] := aItem[ 2 ] } )
   endif

   if Eval( bEdit, aTemp, .T. )
      (cAlias)->(DbAppend())
      AEval( aTemp, { |xItem, i| (cAlias)->(FieldPut( i, xItem ) ) } )
      if oBrw != nil
         oBrw:oBrw:RefreshAll()
      endif
      return .T.
   endif

return .F.

//----------------------------------------------------------------------------//

func Edit( oBrw, bEdit, lRefresh )

   local aTemp := Array( (oBrw:cAlias)->( FCount() ) )

   AEval( aTemp, { |xItem, i| aTemp[ i ] := (oBrw:cAlias)->( FieldGet( i ) ) } )

   if Eval( bEdit, aTemp, .F. )
      AEval( aTemp, { |xItem, i| (oBrw:cAlias)->(FieldPut( i, xItem ) ) } )
      if lRefresh == nil .or. lRefresh
         oBrw:oBrw:RefreshAll()
      endif
      return .T.
   endif

return .F.

//-------------------------------------------------------------------------//
