//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//                VISUAL ENGINE FOR CLIPPER TUTOR (CUA CONTROLS)
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"
#include "veShapes.ch"

//-----------------------------------------------------------------------//

func Controls()

   local wndCtrl

   /*------------------------
     See previous chapters to know why this part is REM

     INIT SYSTEM
   ------------------------*/

   CREATE WINDOW wndCtrl FROM  0,6 TO 17,74 ;
          TITLE "CUA Controls"              ;
          AUTOSCROLL      // Controls will be made visible automatically

   LoadCtrl( wndCtrl )                                // Loads wnd ctrls

   OPEN WINDOW wndCtrl

   /*---------------------------
     See previous chapters to know why this part is REM

   ACTIVATE WINDOWS

   DEINIT SYSTEM
   --------------------------*/

   LessonWnd( wndCtrl )                   // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
// Now we attach controls to the window
// It isn't necessary to specify the clause <OF wndCtrl> at the end of
// each control, but if we do, the code is clearer.

static func LoadCtrl( wndCtrl )

   local lCase, lColor
   local cName, cPhone
   local nCombo, nOption, nOp, nRow
   local acList := Array( 20 )
   local oBrowse
   local aOther := { { "One  ", 1 }, { "Two  ", 2 }, { "Three", 3 }, ;
                     { "Four ", 4 }, { "Five ", 5 }, { "Six  ", 6 } }


   AEval( acList, { |x,i| acList[ i ] := " Item " + Str( i, 2 ) + " " } )

   @  1,2  LISTBOX  nOption             ;
           ITEMS    acList              ;
           PROMPT   " &ListBox "        ;
           INITIAL  1                   ;
           SIZE     8, 13               ;
           HELPLINE "This is a listbox" ;
           OF       wndCtrl

   @  1,19 RADIO    nOp                                ;
           ITEMS    "&Super  ", "&Medium ", "Lo&w    " ;
           PROMPT   " Radio "                          ;
           HELPLINE "That's super !",                  ;
                    "Not so bad, man ...",             ;
                    "Not enough for me, sorry"         ;
           OF       wndCtrl

   @  2,34 SPINNER  nRow                 ;
           RANGE    0, 99 STEP 1         ;
           INITIAL  0                    ;
           PROMPT   "Spinne&r "          ;
           PICTURE  "99"                 ;
           HELPLINE "Set the screen row" ;
           OF       wndCtrl

   @  1,50 GET          cPhone                    ;
           INITIAL      Space( 14 )               ;
           PROMPT ABOVE "&Phone: "                ;
           HELPLINE     "Enter your phone number" ;
           OF           wndCtrl

   @  4,34 GET      cName             ;
           INITIAL  Space( 41 )       ;
           PROMPT   "&Name "          ;
           PICTURE  "@S23"            ;
           HELPLINE "Enter your name" ;
           OF wndCtrl

   @  6,19 COMBO        nCombo                 ;
           ITEMS        acList                 ;
           PROMPT ABOVE "C&ombo box"           ;
           SIZE         7,14                   ;
           HELPLINE     "This is a combo box " ;
           OF           wndCtrl


   @  6,49 BROWSE     oBrowse ARRAY aOther               ;
           SIZE       6,15                               ;
           PROMPT     " &Browse "                        ;
           SEPARATORS { "", " ", "" }                   ;
           HELPLINE   "Browsing a two dimensional array" ;
           OF         wndCtrl

           ADD COLUMN 1 PICTURE "XXXXX" WIDTH 5 TO BROWSE oBrowse
           ADD COLUMN 2 PICTURE "99"    WIDTH 2 TO BROWSE oBrowse


   @ 10, 2 CHECKBOX lCase                      ;
           INITIAL  .T.                        ;
           PROMPT   "&Ignore case "            ;
           HELPLINE "Ignore Upper/Low case ? " ;
           OF       wndCtrl

   @ 10,22 CHECKBOX lColor                  ;
           INITIAL  .F.                     ;
           PROMPT   "&Color or B&W "        ;
           HELPLINE "Chosse a monitor type" ;
           OF       wndCtrl

   @ 13, 2 BUTTON   " " + cFLOPPY + "  S&ave  " ;
           ACTION   veAlert( "Saving" )          ;
           HELPLINE "Store info to file"         ;
           OF       wndCtrl

   @ 13,19 BUTTON   " " + cMAGNIFY + " Searc&h " ;
           ACTION   veAlert( "Searching" )       ;
           HELPLINE "Search text in file"        ;
           OF       wndCtrl

   @ 13,35 BUTTON   " " + cPRINTER + " &Print " ;
           ACTION   veAlert( "Printing" )       ;
           HELPLINE "Send file to printer"      ;
           OF       wndCtrl

   @ 13,50 BUTTON   " " + cEXIT_DOOR + " &Exit  " ;
           ACTION   WND_KILL( wndCtrl )           ;
           HELPLINE "Exit without saving changes" ;
           OF       wndCtrl

return nil

//-----------------------------------------------------------------------//
