//------------------------------------------------------------------------//
//  VISUAL ENGINE FOR CLIPPER - Ver 1.0
//  (c) 1993-4 Peyrona Soft
//  Authors: Manolo Caracuel Urbano
//           Francisco Morero Peyrona
//
//                VISUAL ENGINE FOR CLIPPER TUTOR (FIRST WINDOW)
//------------------------------------------------------------------------//

#include "veSystem.ch"
#include "veMsg.ch"
#include "veCtrl.ch"
#include "veWindow.ch"

//-----------------------------------------------------------------------//

function FirstWnd()

   local wndFirst

   /*----------------------
     Refer to chapter 2 to know about this command.
     It is in a REM area because VEC Tutor made it at start up

   INIT SYSTEM
   -----------------------*/


   CREATE WINDOW wndFirst FROM 1,24 TO 9,56 ;       // Creating the window
                 TITLE "First Window"       ;
                 ICON TITLE "1st Window"


   @ 4,10 BUTTON   "   &Ok   "                    ;         // Creating a
          HELPLINE "Press button to close window" ;         // PushButton
          ACTION   WND_CLOSE( wndFirst )          ;         // attached
          OF wndFirst                                       // to the wnd


   OPEN WINDOW wndFirst                 // First to write, open the window

   SetPos( 1, 10 )                      // Even pure Clipper functions will
   DevOut( "Hello world", "GR+/B" )     // work in relative wnd positions


   /*---------------------------
     Now the Event System will work until all the windows that have been
     created and opened (in any part of the program) will be closed.

   ACTIVATE WINDOWS          This command activates all wnds that have been
                             previously opened, and the event system.
                             This command is used once only.

   DEINIT SYSTEM             Program will araise here when all windows
                             have been closed.

     Both commands are in a REM area to avoid crashes with the "VEC Tutor"
   --------------------------*/

   LessonWnd( wndFirst )                // For internal tutor use only

return nil

//-----------------------------------------------------------------------//
