**********************************************************************
* Name:		VCAL.PRG
*		Versatile Calendar
* Desc:		A popup calendar program.  Parameters specify position,
*		month to display, and number of dates to wait for.
*		+,- change the year
*		PGUP, PGDN change the month 
*		ARROW KEYS will move calendar through days
*		RETURN will select a day
*		CTRL-END will select a day and return to calling program.
*		ESC will abort 
* Author:	Landon R. Prieur
* Created:	5/1/91
* BORBBS ID:	Reedrock (comments welcome)
*
* Inspired by and modified from CALNDAR1.PRG by Todd W. Lindley as modified
* by Steven L. Baker, Data Design Services, 11/28/91
*
*
* Usage:      DO VCAL WITH x,y,date,rettype
*
*		x = X Coordinate (0-5, if > 5, set to 5)
*		y = Y Coordinate (0-39, if > 39, set to 39)
*		date = Date to show
*		rettype = Number of dates to return (up to 99)
*
* Normal exit:	Returns dates in DRET1, DRET2, DRET3, ...
* CTRL+END:	Returns only dates selected in DRET1, DRET2, DRET3, ...
* ESC:		Returns empty DRET1, DRET2, DRET3, ...
**********************************************************************



PROCEDURE VCAL
	PARAMETERS XC,YC,TDATE,RETTYPE
	SET TALK OFF
	*SET STATUS OFF
	SET ESCAPE OFF
	SET COLOR OF NORMAL TO W+/R    && Calendar will be white on red
	PUBLIC New_date,XT
	STORE 0 TO MONTH,YEAR,DAY,FIRSTDAY,LASTDAY,SKIP_COLS,LAST_COL,COL,ROW,S_COL
	STORE 0 TO NEXT,X,MONTHN,LAST_ROW,INFO_ROW,S_ROW,E_ROW,S1_COL
	STORE 0 TO RC
	STORE 1 TO YY
	IF RETTYPE>99
		RETTYPE=99
	ENDIF
	X=1
	DO WHILE X<=RETTYPE
		XT="DRET"+LTRIM(RTRIM(STR(X)))
		PUBLIC &XT
		&XT=CTOD("  /  /  ")
		X=X+1
	ENDDO
	IF XC > 5
		XC=5
	ENDIF
	IF YC > 39
		YC=39
	ENDIF
	DX=XC+19
	DY=YC+40
	DEFINE WINDOW CALENDAR FROM XC,YC TO DX,DY
	START_ROW=1
	START_COL=1
	DO init
	ACTIVATE WINDOW CALENDAR
	DO grid
	DO calc
	DO refresh
	S_ROW = START_ROW+ 3
	
	* ---- MAIN LOOP - READS KEYBOARD ----------------------------
	@ S_ROW,S_COL SAY " 1"  COLOR GR+/R
	YY = 1
	DO WHILE .T.
		KEY=INKEY()
		DO CASE
		*  ----- up arrow ------------------
		CASE key=5
			* ---  Rewrite old day with regular colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0)
			
			IF YY-7 <= 0
				MONTH=MONTH-1
				IF MONTH<1
					MONTH=12
					YEAR=YEAR-1
				ENDIF
				YY=YY-7
				DO calc
				DO refresh
			ELSE
				YY=YY-7
				S_ROW = S_ROW-2
			ENDIF
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- down arrow ----------------
		CASE key=24
			* ---  Rewrite old day with regular colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0)
			IF YY+7>LASTDAY
				MONTH=MONTH+1
				IF MONTH>12
					MONTH=1
					YEAR=YEAR+1
				ENDIF
				YY=7-(LASTDAY-YY)+100
				DO calc
				DO refresh
			ELSE
				YY=YY+7
				S_ROW=S_ROW+2
			ENDIF
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- left arrow ----------------
		CASE key=19
			* ---  Rewrite old day with regular colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0)
			YY = YY-1
			S_COL=S_COL-SKIP_COLS
			IF S_COL<START_COL+3
				S_COL=START_COL+3+(6*SKIP_COLS)
				S_ROW=S_ROW-2
			ENDIF
			IF YY < 1
				MONTH=MONTH-1
				IF MONTH<1
					MONTH=12
					YEAR=YEAR-1
				ENDIF
				DO calc
				DO refresh
			ENDIF
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
			*FIX BUG IN ABOVE LINE, OCCAISONALLY POSITION OUT OF WINDOW
		*  ----- right arrow---------------
		CASE key=4
			* ---  Rewrite old day with regular colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0)
			S_COL = S_COL+ SKIP_COLS
			YY = YY+1
			IF YY > LASTDAY
				MONTH=MONTH+1
				IF MONTH>12
					MONTH=1
					YEAR=YEAR+1
				ENDIF
				DO calc
				DO refresh
			ENDIF
			IF S_COL > LAST_COL
				S_COL = START_COL+3
				S_ROW = S_ROW+2
				IF S_ROW > E_ROW
					S_ROW = START_ROW + 3
					S_COL = S1_COL
					YY = 1
				ENDIF
			ENDIF
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- page up next MONTH----------
		CASE key=18
			MONTH=MONTH+1
			IF MONTH>12
				MONTH=1
				YEAR=YEAR+1
			ENDIF
			YY=YY+200
			DO calc
			DO refresh
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- page down previous MONTH---------------
		CASE key=3
			MONTH=MONTH-1
			IF MONTH<1
				MONTH=12
				YEAR=YEAR-1
			ENDIF
			YY=YY+300
			DO calc
			DO refresh
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- + key next year ---------------
		CASE key=43
			YEAR=YEAR+1
			IF YEAR<0
				YEAR=1
			ENDIF
			YY=YY+400
			DO calc
			DO refresh
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- - key previous year ---------------
		CASE key=45
			YEAR=YEAR-1
			IF YEAR<0
				YEAR=1
			ENDIF
			YY=YY+500
			DO calc
			DO refresh
			*---  Write indicated day with bold colors
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
		*  ----- escape --------------------
		CASE key=27
			EXIT
		*  ----- return --------------------
		CASE key=13
			IF RC<RETTYPE
				RC=RC+1
				XT="DRET"+LTRIM(RTRIM(STR(RC)))
				&XT=NEW_DATE
				IF RC=RETTYPE
					EXIT
				ENDIF
				@start_row+13,34 SAY STR((RETTYPE-RC),2,0) COLOR GR+/B
				@S_ROW,S_COL SAY STR(YY,2,0) COLOR GR+/R
			ELSE
				EXIT
			ENDIF
		*  ----- CTRL-END -----------------
		CASE key=23
			EXIT
		ENDCASE
	ENDDO
	IF LASTKEY()=27
		X=1
		DO WHILE X<=RETTYPE
			XT="DRET"+LTRIM(RTRIM(STR(X)))
			&XT=CTOD("  /  /  ")
			X=X+1
		ENDDO
	ENDIF
	*  Tdate = New_date
	DEACTIVATE WINDOW CALENDAR
	SET COLOR OF NORMAL TO W+/B      && Reset normal color
	RELEASE New_date
RETURN 
*-- EOM: Calndar1


* --- procedure to refresh screen -------------
PROCEDURE refresh  
	x=1
	row=start_row+3
	@info_row,start_col+1 CLEAR TO info_row,start_col+skip_cols*6
	@info_row,start_col SAY monthn
	@info_row,last_col-3 SAY STR(year,4,0)
	@start_row+13,34 SAY STR((RETTYPE-RC),2,0) COLOR GR+/B
	DO clear_grid
	S_ROW = ROW
	S1_COL = COL
	*enters day numbers in grid boxes
	DO WHILE x <= lastday
		NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(x,2,0)+"/"+STR(YEAR,4,0))
		@ ROW,COL SAY STR(x,2,0)
		COL=COL+SKIP_COLS
		IF COL > LAST_COL .and. X<> lastday
			COL=START_COL+3
			ROW=ROW+2
		ENDIF
		X=X+1
	ENDDO
	E_ROW  = ROW
	DO CASE
		CASE YY=0			&&LEFT ARROW WAS PRESSED
			YY=lastday		&&set to last day of month
			S_ROW=ROW		&&SET TO ROW OF LAST DAY
			S_COL=COL-SKIP_COLS	&&SET TO COLUMN OF LAST DAY
			IF S_COL<START_COL+3
				S_COL=START_COL+3+(6*SKIP_COLS)
			ENDIF
		CASE YY<0	&&UP ARROW WAS PRESSED
			YY=lastday+yy
			S_COL=COL-SKIP_COLS
			S_ROW=E_ROW
			DO COUNTUP
		CASE YY>500 .AND. YY<600	&& - key was pressed
			YY=YY-500
			DO COUNTUP
		CASE YY>400 .AND. YY<500	&& + key was pressed
			YY=YY-400
			DO COUNTUP
		CASE YY>300 .AND. YY<400	&&page down was pressed
			YY=YY-300
			DO COUNTUP
		CASE YY>200 .AND. YY<300	&&page up was pressed
			YY=YY-200
			DO COUNTUP
		CASE YY>100 .AND. YY<200	&&down arrow was pressed
			YY=YY-100
			DO COUNTUP
		OTHERWISE
			yy = 1
			*prints first day in yellow
			NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(1,2,0)+"/"+STR(YEAR,4,0))
			@ S_ROW,S_COL SAY " 1" COLOR GR+/R
	ENDCASE
RETURN
*-- EOP: Refresh


* --- initial set up procedure  -------------
PROCEDURE init
	month=month(tdate)
	year=YEAR(tdate)
	day=DAY(tdate)
RETURN
*- EOP: Init


* --- procedure to calculate days of the month ---------
PROCEDURE calc
	** GET MONTH NAME
	monthn=CMONTH(CTOD(STR(month,2,0)+"/01/91"))
	** CALCULATE 1ST OF MONTH AND BEGINNING OF NEXT MONTH
	beg=CTOD(STR(month,2,0)+"/"+"01/"+STR(year,4,0))
	next=CTOD(STR(month+1,2,0)+"/"+"01/"+STR(year,4,0))
	** CALCULATE # OF DAYS IN MONTH
	firstday=DOW(beg)
	lastday=next-beg
	** STARTING DISPLAY COLUMN OF 1ST DAY OF MONTH
	col=skip_cols*(firstday-1)+start_col+3
	s_col = col
RETURN
*-- EOP: Calc


* --- procedure to rebuild grid -------------
PROCEDURE grid
	** EACH @ SAY WAS HARD CODED FOR SPEED IN DRAWING THE GRID.
	** A DO WHILE COULD HAVE BEEN USED BUT WOULD HAVE BEEN TOO SLOW.
	skip_cols=5
	last_col=start_col+skip_cols*6+5
	last_row=start_row+14
	info_row=start_row-1
	@start_row+1,start_col+2 SAY "Sun  Mon  Tue  Wed  Thu  Fri  Sat"
	@start_row,start_col TO last_row,last_col
	@start_row+2,start_col TO start_row+2,last_col
	@start_row,start_col+skip_cols TO last_row,start_col+skip_cols*6
	@start_row,start_col+skip_cols*2 TO last_row,start_col+skip_cols*5
	@start_row,start_col+skip_cols*3 TO last_row,start_col+skip_cols*4
	@start_row,start_col+skip_cols SAY CHR(194)
	@start_row,start_col+skip_cols*2 SAY CHR(194)
	@start_row,start_col+skip_cols*3 SAY CHR(194)
	@start_row,start_col+skip_cols*4 SAY CHR(194)
	@start_row,start_col+skip_cols*5 SAY CHR(194)
	@start_row,start_col+skip_cols*6 SAY CHR(194)
	@start_row+2,start_col SAY CHR(195)
	@start_row+2,start_col+skip_cols SAY CHR(197)
	@start_row+2,start_col+skip_cols*2 SAY CHR(197)
	@start_row+2,start_col+skip_cols*3 SAY CHR(197)
	@start_row+2,start_col+skip_cols*4 SAY CHR(197)
	@start_row+2,start_col+skip_cols*5 SAY CHR(197)
	@start_row+2,start_col+skip_cols*6 SAY CHR(197)
	@start_row+2,last_col SAY CHR(180)
	@start_row+4,start_col TO last_row-2,last_col
	@start_row+6,start_col TO last_row-4,last_col
	@start_row+8,start_col TO last_row-6,last_col
	@start_row+4,start_col SAY CHR(195)
	@start_row+4,start_col+skip_cols SAY CHR(197)
	@start_row+4,start_col+skip_cols*2 SAY CHR(197)
	@start_row+4,start_col+skip_cols*3 SAY CHR(197)
	@start_row+4,start_col+skip_cols*4 SAY CHR(197)
	@start_row+4,start_col+skip_cols*5 SAY CHR(197)
	@start_row+4,start_col+skip_cols*6 SAY CHR(197)
	@start_row+4,last_col SAY CHR(180)
	@start_row+6,start_col SAY CHR(195)
	@start_row+6,start_col+skip_cols SAY CHR(197)
	@start_row+6,start_col+skip_cols*2 SAY CHR(197)
	@start_row+6,start_col+skip_cols*3 SAY CHR(197)
	@start_row+6,start_col+skip_cols*4 SAY CHR(197)
	@start_row+6,start_col+skip_cols*5 SAY CHR(197)
	@start_row+6,start_col+skip_cols*6 SAY CHR(197)
	@start_row+6,last_col SAY CHR(180)
	@start_row+8,start_col SAY CHR(195)
	@start_row+8,start_col+skip_cols SAY CHR(197)
	@start_row+8,start_col+skip_cols*2 SAY CHR(197)
	@start_row+8,start_col+skip_cols*3 SAY CHR(197)
	@start_row+8,start_col+skip_cols*4 SAY CHR(197)
	@start_row+8,start_col+skip_cols*5 SAY CHR(197)
	@start_row+8,start_col+skip_cols*6 SAY CHR(197)
	@start_row+8,last_col SAY CHR(180)
	@start_row+10,start_col SAY CHR(195)
	@start_row+10,start_col+skip_cols SAY CHR(197)
	@start_row+10,start_col+skip_cols*2 SAY CHR(197)
	@start_row+10,start_col+skip_cols*3 SAY CHR(197)
	@start_row+10,start_col+skip_cols*4 SAY CHR(197)
	@start_row+10,start_col+skip_cols*5 SAY CHR(197)
	@start_row+10,start_col+skip_cols*6 SAY CHR(197)
	@start_row+10,last_col SAY CHR(180)
	@start_row+12,start_col SAY CHR(195)
	@start_row+12,start_col+skip_cols SAY CHR(197)
	@start_row+12,start_col+skip_cols*2 SAY CHR(197)
	@start_row+12,start_col+skip_cols*3 SAY CHR(197)
	@start_row+12,start_col+skip_cols*4 SAY CHR(197)
	@start_row+12,start_col+skip_cols*5 SAY CHR(197)
	@start_row+12,start_col+skip_cols*6 SAY CHR(197)
	@start_row+12,last_col SAY CHR(180)
	@last_row,start_col SAY CHR(192)
	@last_row,start_col+skip_cols SAY CHR(193)
	@last_row,start_col+skip_cols*2 SAY CHR(193)
	@last_row,start_col+skip_cols*3 SAY CHR(193)
	@last_row,start_col+skip_cols*4 SAY CHR(193)
	@last_row,start_col+skip_cols*5 SAY CHR(193)
	@last_row,start_col+skip_cols*6 SAY CHR(193)
	@last_row,last_col SAY CHR(217)
	*-- User help information at bottom of calendar
	@last_row+1,start_col+1 SAY "Day:"
	@last_row+1,start_col+6 SAY CHR(26) COLOR GR+/R
	@last_row+1,start_col+7 SAY CHR(27) COLOR GR+/R
	@last_row+1,start_col+8 SAY CHR(24) COLOR GR+/R
	@last_row+1,start_col+9 SAY CHR(25) COLOR GR+/R
	@last_row+1,start_col+11 SAY "Month:"
	@last_row+1,start_col+18 SAY "PGUP/PGDN" COLOR GR+/R
	@last_row+1,start_col+28 SAY "Year:"
	@last_row+1,start_col+34 SAY CHR(241) COLOR GR+/R
	@last_row+2,start_col+1 SAY "Select:"
	@last_row+2,start_col+9 SAY CHR(27) COLOR GR+/R
	@last_row+2,start_col+10 SAY CHR(217) COLOR GR+/R
	@last_row+2,start_col+13 SAY "End/Quit:"
	@last_row+2,start_col+23 SAY "CTRL-END/ESC" COLOR GR+/R
RETURN
*-- EOP: Grid


* --- procedure to clear grid -------------
PROCEDURE clear_grid
	@row,start_col+skip_cols-2 SAY "  "
	@row,start_col+skip_cols*2-2 SAY "  "
	@row,start_col+skip_cols*3-2 SAY "  "
	@row,start_col+skip_cols*4-2 SAY "  "
	@row,start_col+skip_cols*5-2 SAY "  "
	@row,start_col+skip_cols*6-2 SAY "  "
	@row,start_col+skip_cols*7-2 SAY "  "
	@last_row-1,start_col+skip_cols-2 SAY "  "
	@last_row-1,start_col+skip_cols*2-2 SAY "  "
	@last_row-1,start_col+skip_cols*3-2 SAY "  "
	@last_row-1,start_col+skip_cols*4-2 SAY "  "
	@last_row-1,start_col+skip_cols*5-2 SAY "  "
	@last_row-1,start_col+skip_cols*6-2 SAY "  "
	@last_row-3,start_col+skip_cols-2 SAY "  "
	@last_row-3,start_col+skip_cols*2-2 SAY "  "
	@last_row-3,start_col+skip_cols*3-2 SAY "  "
	@last_row-3,start_col+skip_cols*4-2 SAY "  "
	@last_row-3,start_col+skip_cols*5-2 SAY "  "
	@last_row-3,start_col+skip_cols*6-2 SAY "  "
	@last_row-3,start_col+skip_cols*7-2 SAY "  "
RETURN
*-- EOP: Clear_grid

PROCEDURE COUNTUP	&&counts up to current date
	IF YY>LASTDAY
		DO WHILE YY>LASTDAY
			YY=YY-1
		ENDDO
	ENDIF
	S_COL=SKIP_COLS*(FIRSTDAY-1)+START_COL+3
	S_ROW=START_ROW+3
	X=1
	do while x<YY
		s_col=s_col+5
		if s_col>last_col
			s_col=start_col+3
			s_row=s_row+2
		endif
		x=x+1
	enddo
RETURN
*-- EOP: Countup

