/***
 * Program : NTHAT.PRG
 * Notice  : Copyright (c) BITwise Computer Services, 1991-1992
 * Date    : 09/17/92
 * Author  : David Christian
 * Purpose :
 * Notes   : Compile with /n /w
 *
 * Revised :
 *
*/

#include"txt2dbf.ch"

FUNCTION B_NTHAT(cSearch,cTarget,nTh)
   // SYNTAX: <expN1>:=B_NthAT(<expC1>,<expC2>,[<expN2>])
   //         - RETURNS POS OF THE nTh OCCURANCE OF cSearch IN cTarget
   //         - SEARCHES LEFT TO RIGHT
   //         - RETURNS 0 IF nTh OCCURANCE NOT FOUND
   //
   LOCAL nPos:=0, nAt:=0, nX:=0
   DEFAULT nTh TO 1
   WHILE nX<nTh .AND. ( nAt:=AT(cSearch,SUBSTR(cTarget,nPos+1)) ) >0
      nX++
      nPos+=nAt
   END
RETURN( IIF(nAt==0,0,nPos) )


FUNCTION B_NTHRAT(cSearch,cTarget,nTh)
   // SYNTAX: <expN1>:=B_NthRAT(<expC1>,<expC2>,[<expN2>])
   //         - RETURNS POS OF THE nTh OCCURANCE OF cSearch IN cTarget
   //         - SEARCHES RIGHT TO LEFT
   //         - RETURNS 0 IF nTh OCCURANCE NOT FOUND
   //
   //
   LOCAL nAt:=LEN(cTarget)+1, nX:=0
   DEFAULT nTh TO 1
   WHILE nX<nTh .AND. ( nAt:=RAT(cSearch,SUBSTR(cTarget,1,nAt-1)) ) >0
      nX++
   END
RETURN(nAt)


//EOF
