// Program "TBARSYS.PRG"
// Copyright (c) 1995 Bryan Duchesne    76511,1036
// This program is the "sys" driver to handle toolbars

#include "toolbar.ch"
#include "llibg.ch"
#include "inkey.ch"
#include "button.ch"
#include "setcurs.ch"

STATIC aTBarSave := {}
STATIC cMsg, nMsgRow, nMsgCol, nMsgWidth, cSave, lMsgOn

FUNCTION TbarModal(oBar, cMsgColor, nMsgPos)
   LOCAL nCol := Col(), nRow := Row(), lMsgFlag := .T.
   LOCAL nSelection, nKey
   LOCAL nOldCursor := SetCursor(SC_NONE)
      SaveTbar()              // Save Statics in stack

      cMsg   := Space(1)
      IF ! (  ValType( cMsgColor ) == "C" )
        lMsgFlag := .F.
      ELSEIF ! (  ValType( nMsgPos ) == "N" )
        lMsgFlag := .F.
      ELSE
        lMsgFlag := .T.
        lMsgOn   := .F.
      ENDIF
      oBar:Display()
      WHILE !( oBar:exitstate == TBAR_EXIT )
        nSelection := 0
        WHILE ( nSelection == 0 )
           nKey := Inkey( 0 )
           IF nKey = K_MOUSEMOVE
             IF ( oBar:ScanTest( MRow(), MCol() ) = HTCLIENT)
               IF !( Empty(oBar:currbutton:message) )
                 ShowMsg(lMsgFlag, cMsgColor,oBar:currbutton,nMsgPos)
               ELSE
                 cMsg   := Space(1)
                 IF lMsgFlag .AND. lMsgOn
                   RestScreen(nMsgRow-1,nMsgCol-1,nMsgRow+1,nMsgCol+nMsgWidth+1,cSave)
                   lMsgOn := .F.
                 ENDIF
               ENDIF
             ELSE
               cMsg   := Space(1)
               IF lMsgFlag .AND. lMsgOn
                 RestScreen(nMsgRow-1,nMsgCol-1,nMsgRow+1,nMsgCol+nMsgWidth+1,cSave)
                 lMsgOn := .F.
               ENDIF
             ENDIF
           ELSEIF ( nKey == K_LBUTTONDOWN )
              nSelection := oBar:HitTest( MRow(), MCol() )
           ENDIF
        ENDDO
        IF lMsgFlag .AND. lMsgOn
          RestScreen(nMsgRow-1,nMsgCol-1,nMsgRow+1,nMsgCol+nMsgWidth+1,cSave)
          lMsgOn := .F.
        ENDIF
        Eval( oBar:pushBlock )
      ENDDO
      oBar:close()
      RestoreTBar()
      SetCursor(nOldCursor)
   RETURN ( NIL )

STATIC FUNCTION ShowMsg( lMsgFlag, cMsgColor,oButton, nMsgPos )
   LOCAL  nAt, mOldState
   LOCAL  nForeColor, nBackColor, nOffset

      IF ( lMsgFlag )
         nAt        := At("/", cMsgColor)
         nForeColor := _GETNUMCOLOR ( cMsgColor )
         nBackColor := _GETNUMCOLOR( Substr( cMsgColor, nAt + 1, len( cMsgColor ) - nAt) )
         mOldState  := MSetCursor(.F.)

         IF !( cMsg = oButton:message )
           // Restore screen area of old message
           IF lMsgOn
             RestScreen(nMsgRow-1,nMsgCol-1,nMsgRow+1,nMsgCol+nMsgWidth+1,cSave)
           ENDIF

           // Set up for new message
           cMsg := oButton:message
           nMsgWidth := Len(cMsg)
           lMsgOn := .T.

           // Determine positioning of message
           IF nMsgPos = TBAR_MSG_TOP
             nMsgRow   := oButton:row - 2
             nMsgCol   := oButton:col
             nOffset   := 12
           ELSEIF nMsgPos = TBAR_MSG_BOTTOM
             nMsgRow   := oButton:row + 2
             nMsgCol   := oButton:col
             nOffset   := 4
           ELSEIF nMsgPos = TBAR_MSG_LEFT
             nMsgRow   := oButton:row
             nMsgCol   := oButton:col - nMsgWidth - 1
             nOffset   := 0
           ELSEIF nMsgPos = TBAR_MSG_RIGHT
             nMsgRow   := oButton:row
             nMsgCol   := oButton:col + 5
             nOffset   := 0
           ENDIF

           // Save screen area for new message
           cSave := SaveScreen(nMsgRow-1,nMsgCol-1,nMsgRow+1, nMsgCol+nMsgWidth+1)

           // Display new message
           gRect( Col2Pxl(nMsgCol)   - 2 ,;
                  Row2Pxl(nMsgRow)   + nOffset ,;
                  Col2Pxl(nMsgCol+nMsgWidth) + 2, ;
                  Row2Pxl(nMsgRow+1) + nOffset ,;
                  LLG_FILL, nBackColor, LLG_MODE_SET)
           gRect( Col2Pxl(nMsgCol)   - 2 ,;
                  Row2Pxl(nMsgRow)   + nOffset ,;
                  Col2Pxl(nMsgCol+nMsgWidth) + 2, ;
                  Row2Pxl(nMsgRow+1) + nOffset ,;
                  LLG_FRAME, nForeColor, LLG_MODE_SET)
           gWriteAt( Col2Pxl(nMsgCol) ,;
                     Row2Pxl(nMsgRow) + nOffset+1 ,;
                     cMsg, nForeColor, LLG_MODE_SET )
         ENDIF
         MSetCursor(mOldState)
      ENDIF
   RETURN ( NIL )

STATIC PROCEDURE SaveTbar()
      AAdd( aTBarSave, { cMsg, nMsgRow, nMsgCol, nMsgWidth, cSave, lMsgOn})
   RETURN

STATIC PROCEDURE RestoreTBar()
   LOCAL nLastIn := Len( aTBarSave )
      cMsg      := aTBarSave[nLastIn, 1]
      nMsgRow   := aTBarSave[nLastIn, 2]
      nMsgCol   := aTBarSave[nLastIn, 3]
      nMsgWidth := aTBarSave[nLastIn, 4]
      cSave     := aTBarSave[nLastIn, 5]
      lMsgOn    := aTBarSave[nLastIn, 6]
      ASize ( aTBarSave, nLastIn - 1)
   RETURN
