#include "inkey.ch"
#include "llibg.ch"            // Must be included
#include "toolbar.ch"          // Must be included
#include "box.ch"


PROCEDURE TbarDemo
   LOCAL oToolBar
      SET VIDEOMODE TO LLG_VIDEO_VGA_640_480_16
      SET( _SET_EVENTMASK, INKEY_ALL )
      MSetCursor(.T.)

      SetColor("N/W")
      CLS
      SetColor("W/B")
      @ 0, 0
      @ 0, 0 SAY Padc("ToolBar Demonstration Program",MaxCol())
      SetColor("N/W")
      DispBox(1,0,MaxRow(),MaxCol(), LLG_BOX_GRAY_STD)

      // Define the tool bar row and column
      oToolBar := ToolBar():New( 3,74, TBAR_VERTICAL )

      // Define buttons to place in Tool Bar
      //---------------Button....  Code Block.... ID  Message.....
      oToolBar:addItem("EXIT.BMP", {|| Button1(), oToolBar:exitState := TBAR_EXIT }, "Exit Program" )

      oToolBar:addItem( TBAR_SEPARATOR )

      oToolBar:addItem("NEW.BMP", {|| Button2()} ,  "New Document" )
      oToolBar:addItem("FIND.BMP", {|| Button3()},  "Find Text" )

      oToolBar:addItem( TBAR_SEPARATOR )

      oToolBar:addItem("PRINT.BMP", {|| Button4()}, "Print File" )

      oToolBar:addItem( TBAR_SEPARATOR )

      oToolBar:addItem("TBAR.BMP", {|| Button5()}, "File ToolBar" )

      // Define Frame type to place around the Toolbar
      oToolBar:frame := LLG_BOX_GRAY_STD

      // Execute until button number 1 is pushed
      TbarModal( oToolBar, "W+/B", TBAR_MSG_LEFT )

   RETURN

FUNCTION Button1()
  @ 24, 1
  @ 24, 1 say "Button 1 Hit"
  RETURN NIL

FUNCTION Button2()
  @ 24, 1
  @ 24, 1 say "Button 2 Hit"
  RETURN NIL

FUNCTION Button3()
  @ 24, 1
  @ 24, 1 say "Button 3 Hit"
  RETURN NIL

FUNCTION Button4()
  @ 24, 1
  @ 24, 1 say "Button 4 Hit"
  RETURN NIL

FUNCTION Button5()
   LOCAL oToolBar, nButton
      oToolBar := ToolBar():New( 3, 2, TBAR_HORIZONTAL )
      oToolBar:addItem("EXIT.BMP", {|| Button1a(), oToolBar:exitstate := TBAR_EXIT }, "Exit Select" )
      oToolBar:addItem("OPEN.BMP", {|| Button2a()}, "Open a File" )
      oToolBar:addItem("CLOSE.BMP",{|| Button3a()}, "Close file" )
      oToolBar:frame := LLG_BOX_GRAY_STD
      TbarModal( oToolBar, "GR+/R", TBAR_MSG_TOP )
  RETURN NIL

FUNCTION Button1a()
  @ 24, 1
  @ 24, 1 say "Button 1a Hit"
  RETURN NIL

FUNCTION Button2a()
  @ 24, 1
  @ 24, 1 say "Button 2a Hit"
  RETURN NIL

FUNCTION Button3a()
  @ 24, 1
  @ 24, 1 say "Button 3a Hit"
  RETURN NIL
