*ͻ*
*   Module Name:   TBSEPS.PRG                                      *
*   Description:   An explanation of the behaviour of TBrowse      *
*                  separators.                                     *
*   Notes......:   COMPILE with the /n switch.                     *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   June 13, 1991                                   *
*   History....:   Just decided it was something I had to do.      *
*                                                                  *
*   Copyright..:   (c) The people at Nantucket Canada, 1991        *
*ͼ*
#include "inkey.ch"

FUNCTION MAIN()
    	LOCAL nI, nKey
	LOCAL oBrowse := TBROWSEDB( 4, 0, 23, 79 )

	CLS

	USE ATC

	@24, 57 SAY 'F2 - Change Separators'

	FOR nI := 1 TO FCOUNT()
		oBrowse:addColumn( TBCOLUMNNEW( FIELD( nI ),;
			FIELDBLOCK( FIELD( nI ) ) ) )
	NEXT nI

	oBrowse:headSep := ''
	oBrowse:colSep := '  '
	oBrowse:footSep := ''

	DO WHILE nKey != K_ESC

		DO WHILE ! oBrowse:stabilize()
		ENDDO

		nKey := INKEY( 0 )

		DO CASE
		CASE nKey == K_F2
			DisplaySeps( oBrowse )
		CASE nKey == K_DOWN
			oBrowse:down()
		CASE nKey == K_UP
			oBrowse:up()
		CASE nKey == K_LEFT
			oBrowse:left()
		CASE nKey == K_RIGHT
			oBrowse:right()
		ENDCASE

	ENDDO

RETURN Nil


FUNCTION DisplaySeps( oBrowse )
       STATIC aHeadSeps := { '', '', '', '', '***', '', '', '' },;
              aColSeps  := { '  ', '', '', ' ', ' * ', '  ', '', '  ' },;
              aFootSeps := { '', '', '', '', '***', '', '', '' }
       STATIC nArrPos := 1

	nArrPos := IF( nArrPos == LEN( aHeadSeps ), 1,;
		nArrPos + 1 )
	oBrowse:headSep := aHeadSeps[ nArrPos ]
	oBrowse:colSep := aColSeps[ nArrPos ]
	oBrowse:footSep := aFootSeps[ nArrPos ]

	@0, 0 SAY 'TBrowse:headSep: "' + oBrowse:headSep + '"   ' COLOR 'w+/n'
	@1, 1 SAY 'TBrowse:colSep: "' + oBrowse:colSep + '"    ' COLOR 'w+/n'
	@2, 0 SAY 'TBrowse:footSep: "' + oBrowse:footSep + '"   ' COLOR 'w+/n'

	oBrowse:configure()
	oBrowse:refreshall()

RETURN Nil
/******************************************************************************
The program TBSIMPLE.PRG should be studied before taking a look at this program
as this program builds upon it.  Only lines that are different from those in
TBSIMPLE.PRG will be explained.

        ͸
Line 29   oBrowse:headSep := ''                                          
Line 30   oBrowse:colSep := '  '                                           
Line 31   oBrowse:footSep := ''                                          
        ;
There are three TBrowse separators in Clipper 5.01.  The heading separator
(TBrowse:headSep), the column separator (TBrowse:colSep) and the footing
separator (TBrowse:footSep).  These instance variables contain the characters
that are used to separate their respective elements of the TBrowse.

The column separator (TBrowse:colSep) determines the amount of space between
the columns of the TBrowse.  In the above example there are 3 screen columns
separating each column of data in the TBrowse.

The heading separator (TBrowse:headSep) and the footing separator
(TBrowse:footSep) behave the same.  Both will display their characters starting
from the leftmost position of the column separator (TBrowse:colSep). If there
is anymore room across the column of data, the rightmost character in each of
the instance variables will be repeated to fill that gap.

The defaults for the TBrowse separators are:
		TBrowse:headSep := ''   - no heading separator
		TBrowse:colSep := ' '   - one space between data columns
		TBrowse:footSep := ''   - no footing separator

The DisplaySeps() function is just added to display some of the different kinds
of TBrowse separators that are possible.  It therefore will not be commented.
It will only confuse the issue.
******************************************************************************/
