*ͻ*
*   Module Name:   TBCOLOR.PRG                                     *
*   Description:   An example of adding color to a TBrowse on a    *
*                  cell by cell basis.                             *
*   Notes......:   COMPILE with the /n switch.                     *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   June 13, 1991                                   *
*   History....:   Just decided it was something I had to do.      *
*                                                                  *
*   Copyright..:   (c) The people at Nantucket Canada, 1991        *
*ͼ*
#include "inkey.ch"

FUNCTION MAIN()
	LOCAL nI, nKey
	LOCAL oBrowse := TBROWSEDB( 1, 5, 24, 75 ), oColumn

	CLS

	USE ATC

	oBrowse:colorSpec := 'w+/n, n/w, n+/n, n+/w'

	FOR nI := 1 TO FCOUNT()
		oColumn := TBCOLUMNNEW( FIELD( nI ), FIELDBLOCK( FIELD( nI ) ) )
		oColumn:colorBlock := { || IF( DELETED(), { 3, 4 }, { 1, 2 } ) }
		oBrowse:addColumn( oColumn )
	NEXT nI

        DO WHILE nKey != K_ESC

		DO WHILE ! oBrowse:stabilize()
		ENDDO

		nKey := INKEY( 0 )

		DO CASE
		CASE nKey == K_DOWN
			oBrowse:down()
		CASE nKey == K_UP
			oBrowse:up()
		CASE nKey == K_LEFT
			oBrowse:left()
		CASE nKey == K_RIGHT
			oBrowse:right()

		CASE nKey == K_DEL
			IF DELETED()
				DBRECALL()
			ELSE
				DBDELETE()
			ENDIF
			oBrowse:refreshCurrent()

		ENDCASE

	ENDDO

RETURN Nil
/******************************************************************************
The program TBSIMPLE.PRG should be studied before taking a look at this program
as this program builds upon it.  Only lines that are different from those in
TBSIMPLE.PRG will be explained.

        ͸
Line 22   oBrowse:colorSpec := 'w+/n, n/w, n+/n, n+/w'                      
        ;
The line above will store a color table in the instance variable
oBrowse:colorSpec.  Each of the colors can be accessed by specifying their
position in the color string.
                 ͻ
                   Position    1     2    3     4   
                   Color      w+/n  n/w  n+/n  n+/w 
                 ͼ

        ͸
Line 25   oColumn := TBCOLUMNNEW( FIELD( nI ), FIELDBLOCK( FIELD( nI ) ) )  
Line 26   oColumn:colorBlock := { || IF( DELETED(), { 3, 4 }, { 1, 2 } ) }  
Line 27   oBrowse:addColumn( oColumn )                                      
        ;
In TBSIMPLE.PRG the creation and storing of the column object was performed in
one line.  In the program we add an intermediate step in order to store a
code block into the instance variable oColumn:colorBlock.  On line 25 the
column object is created and the column object's reference is stored in the
variable oColumn.  On line 26 the code block which determines the color of the
current cell is stored within the column object.  Finally, on line 27 the
TBColumn object referenced by the variable oColumn is stored in the TBrowse
object referenced by oBrowse.

The TBrowse will evaluate the code block as it comes to the data to be
displayed.  In this case, when the TBrowse tries to display a record that is
deleted, each column will be evaluated and return the first array from the
IF() function, which will be returned from the evaluated code block.  The
array will point to locations within the oBrowse:colorSpec string.

        ͸
Line 47   CASE nKey == K_DEL                                                
Line 48   	IF DELETED()                                                 
Line 49   		DBRECALL()                                           
Line 50   	ELSE                                                         
Line 51   		DBDELETE()                                           
Line 52   	ENDIF                                                        
Line 53   	oBrowse:refreshCurrent()                                     
        ;
If the Delete key is pressed, the record is checked to see if it is deleted.
If it is deleted, the record will be recalled.  If the record is not deleted,
it will be deleted.

Line 53 marks the current row as changed which will cause the next
stabilization loop to evaluate each column's TBColumn:colorBlock instance
variable.
                                  *******

The TBColumn:colorBlock instance variable can be used to color individual cells
for many circumstances.  Since this is a TBColumn instance variable, the
columns to be colored must be individually assigned a code block.  In the above
example, the entire row was colored so each column was assigned the same code
block to its TBColumn:colorBlock instance variable.

In the case where cells in only one column are to be colored, say for a
negative number, only that column need have a code block assigned to its
TBColumn:colorBlock.  The code block will be evaluated for every cell in that
column and the appropriate color array will be returned from it.  The other
columns will use the default color to display their data.
*******************************************************************************/
