*ͻ*
*   Module Name:   TBARRAY.PRG                                     *
*   Description:   An example of browsing an array.                *
*   Notes......:   COMPILE with the /n switch.                     *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   June 13, 1991                                   *
*   History....:   Just decided it was something I had to do.      *
*                                                                  *
*   Copyright..:   (c) The people at Nantucket Canada, 1991        *
*ͼ*
#include "inkey.ch"

FUNCTION Main()
        LOCAL aTest := { { " Bob   ", 12, .T. }, { " Mary  ", 11, .F. },;
                         { " John  ", 34, .T. }, { " Bill  ", 10, .T. },;
			 { " Tony  ", 25, .F. }, { " Kelly ", 23, .F. },;
			 { " Fred  ", 29, .T. }, { " Paul  ", 31, .T. },;
			 { " Harv  ", 32, .T. }, { " Mark  ", 42, .T. },;
			 { " Nancy ", 27, .F. }, { " Ferd  ", 20, .F. },;
			 { " Mona  ", 26, .T. }, { " Cathy ", 29, .T. },;
			 { " Lori  ", 24, .F. } }
        LOCAL nArrPos := 1, nKey
        LOCAL oBrowse := TBROWSENEW( 4, 18, 16, 62 )

        CLS

	oBrowse:headSep := ''
	oBrowse:colSep := '  '
	oBrowse:footSep := ''

        oBrowse:addColumn( TBCOLUMNNEW( '', { || aTest[ nArrPos, 1 ] } ) )
        oBrowse:addColumn( TBCOLUMNNEW( '', { || aTest[ nArrPos, 2 ] } ) )
        oBrowse:addColumn( TBCOLUMNNEW( '', { || aTest[ nArrPos, 3 ] } ) )

        oBrowse:skipBlock :=;
		{ | nMove | SkipArray( nMove, @nArrPos, LEN( aTest ) ) }
        oBrowse:goTopBlock := { || nArrPos := 1 }
        oBrowse:goBottomBlock := { || nArrPos := LEN( aTest ) }


        DO WHILE nKey != K_ESC

                DO WHILE ! ( oBrowse:stabilize() )
                ENDDO

                nKey := INKEY( 0 )

                DO CASE
                CASE nKey == K_DOWN
                        oBrowse:down()
                CASE nKey == K_UP
                        oBrowse:up()
                CASE nKey == K_RIGHT
                        oBrowse:right()
                CASE nKey == K_LEFT
                        oBrowse:left()
                ENDCASE
        ENDDO

RETURN Nil



* * * *
*
*	Function SkipArray()
*
FUNCTION SkipArray( nMove, nArrPos, nArrayLength )

	IF nMove > 0
		IF ( nArrPos + nMove ) > nArrayLength
			nMove := nArrayLength - nArrPos
		ENDIF
	ELSE
		IF ( nArrPos + nMove ) < 1
			nMove := 1 - nArrPos
		ENDIF
	ENDIF

	nArrPos += nMove

RETURN nMove

/******************************************************************************
If you don't have the basic understanding of TBROWSEs or of Multi-Dimensional
arrays, you most likely would not understand the rest of this discussion.

        ͸
Line 14   LOCAL aTest := { { " Bob   ", 12, .T. }, { " Mary  ", 11, .F. },; 
Line 15                    { " John  ", 34, .T. }, { " Bill  ", 10, .T. },; 
Line 16   		    { " Tony  ", 25, .F. }, { " Kelly ", 23, .F. },; 
Line 17   		    { " Fred  ", 29, .T. }, { " Paul  ", 31, .T. },; 
Line 18   		    { " Harv  ", 32, .T. }, { " Mark  ", 42, .T. },; 
Line 19   		    { " Nancy ", 27, .F. }, { " Ferd  ", 20, .F. },; 
Line 20   		    { " Mona  ", 26, .T. }, { " Cathy ", 29, .T. },; 
Line 21   		    { " Lori  ", 24, .F. } }                         
        ;
Above a multi-dimensional array is created with information to be browsed.
The reference to that array is stored in the variable "aTest".

        ͸
Line 22   LOCAL nArrPos := 1, nKey                                          
        ;
The variable "nArrPos" is initialized to the value of 1 in order to control the
array position.  This variable will hold the current array position for the
TBrowse.

        ͸
Line 23   LOCAL oBrowse := TBROWSENEW( 4, 18, 16, 62 )                      
        ;
The function TBROWSENEW() is used instead of the TBROWSEDB() function because
it will default to an object without a movement mechanism stored in it.  This
is essential as a special movement mechanism must be created to move through an
array.

        ͸
Line 31   oBrowse:ADDCOLUMN( TBCOLUMNNEW( '', { || aTest[ nArrPos, 1 ] } ) )
Line 32   oBrowse:ADDCOLUMN( TBCOLUMNNEW( '', { || aTest[ nArrPos, 2 ] } ) )
Line 33   oBrowse:ADDCOLUMN( TBCOLUMNNEW( '', { || aTest[ nArrPos, 3 ] } ) )
        ;
The columns of the TBROWSE are created and added individually to the TBROWSE.
In the data display code block, the array elements are accessed by the variable
"nArrPos".  This variable will provide the index for the array element to be
displayed.

        ͸
Line 35   oBrowse:SKIPBLOCK :=;                                             
Line 36           { | nMove | SkipArray( nMove, @nArrPos, LEN( aTest ) ) }  
        ;
The above code block is created and stored to provide a mechanism for movement
through the array being browsed.  In the code block the SkipArray() function is
called and passes the variable nMove which is the number of rows that the
TBROWSE is requesting to move.

The "nArrPos" variable, as explained earlier, holds the current position in the
array.  This variable is passed down into the SkipArray() function in order for
the function to process the movement request.  The variable "nArrPos" is passed
into the SkipArray() function by reference so that array position can be
updated within the SkipArray() function.

The length of the array itself is passed down in order for the SkipArray()
to be able to tell where the end of the array is.

        ͸
Line 37   oBrowse:goTopBlock := { || nArrPos := 1 }                         
Line 38   oBrowse:goBottomBlock := { || nArrPos := LEN( aTest ) }           
        ;
The block stored in the instance variable "oBrowse:goTopBlock" will be
evaluated if the method "TBrowse:goTop()" is sent to the object referenced by
the variable "oBrowse". The block stored in the instance variable
"oBrowse:goBottomBlock" will be evaluated if the method "TBrowse:goBottom()"
is sent to the object referenced by the variable "oBrowse".

As you can see the "top" of the array is the first element, hence assigning 1
to the array position variable for the TBrowse:goTopBlock instance variable.
The "bottom" of the array is the last element which is why we assign the length
of the array to the array position variable for the TBrowse:goBottomBlock
instance variable.

*******************************************************************************
FUNCTION SkipArray
*******************************************************************************

        ͸
Line 70   IF nMove > 0                                                      
Line 71             IF ( nArrPos + nMove ) > nArrayLength                   
Line 72                  nMove := nArrayLength - nArrPos                    
Line 73             ENDIF                                                   
        ;
In the above code the nMove variable holds the number of rows that the TBROWSE
has requested to move.  If the request is greater than 0 another IF statement
checks to see if the current array position plus the number requested will take
the TBROWSE pass the number of elements in the array.  If the TBROWSE is
requesting to move past the end of the array, the "nMove" variable will be
assigned the array length minus the current array position.  This new value
would bring the TBROWSE to the end of the array.

        ͸
Line 74   ELSE                                                              
Line 75           IF ( nArrPos + nMove ) < 1                                
Line 76                   nMove := 1 - nArrPos                              
Line 77           ENDIF                                                     
        ;
If the TBROWSE request is less than 0 (moving up the TBROWSE) the IF
statement checks to see if the current array position plus the number requested
will take the TBROWSE pass the beginning of the array.  If the TBROWSE
is requesting to move past the beginning of the array, the "nMove" variable
will be assigned 1 minus the current array position.  This new value would bring
the TBROWSE to the beginning of the array.

        ͸
Line 80           nArrPos += nMove                                          
                                                                            
Line 82    RETURN nMove                                                     
        ;
The "nMove" variable, at this point, holds the amount of rows that the
SkipArray() function has determined the number of rows TBROWSE can move.  This
value is added to the array position variable "nArrPos".  This value is also
returned to the TBROWSE so that the TBROWSE can process it.
********************************************************************************

Just a little extra to explain that when a TBROWSE requests a certain number of
rows to move, it doesn't always get what it wants.  If the TBROWSE were to
request a move of 12 rows and there were only 7 elements left in the array, 
the SkipArray() function would return the value of 7 to the TBROWSE.  The
TBROWSE seeing that it did not get back what it requested, then assumes that it
has reached the end.

*******************************************************************************/
