*****************************************************************************
*  File Name:  TIMEUDFS.PRG                                                 *
* Written by:  Amy Silverman          or c/o   Coopers & Lybrand            *
*              2029 Rosemount Ave NW           1800 M Street, NW            *
*              Washington, DC  20010           Washington, DC  20036        *
*              202/265-7392                                                 *
*                                                                           *
*       Date:  11/11/86                                                     *
*Description:  TATIME/ETC/DECTIME/SIXTIME                                   *
*                                                                           *
*      Notes:  While writing a dispatch & assignment module for a Naval     *
*              base, I found Tom Rettig's "time functions" to be extremely  *
*              useful; however, they didn't go far enough, particularly     *
*              because the user wanted to enter data in both "time string"  *
*              format and "decimal" format.  I wrote these four functions,  *
*              which make use of the Tom Rettig UDFs found in EXTENDDB,     *
*              to avoid cluttering up my code with calculations.            *
*                                                                           *
*  IMPORTANT:  These functions aren't "standalones" ... you must also link  *
*              EXTENDDB.PRG with your application for them to work.  ALSO,  *
*              please be sure to read the note on public variables used     *
*              with TATIME and ETC.                                         *
*                                                                           *
*      I hope you find these useful! I've very much appreciated some        *
*      of the public domain programs I've downloaded, especially BROWSE.PRG *
*      Since I have a 15-month old baby, I don't have much time to sit      *
*      and fool around with Clipper and be creative (or even to browse      *
*      through bulletin boards).  However, since these were written while   *
*      I was "billable", I'm happy to contribute them to you real           *
*      programmers out there who work late into the night writing stuff     *
*      that makes my life easier.                                           *
*                                           Cheers!                         *
*                                                                           *
*****************************************************************************

* CONTENTS:

*         DECTIME = Converts a time string ("99:99") into a decimal (99.9)
*         SIXTIME = reverses the above process
*         TATIME  = turnaround time from start date/time, end date/time
*         ETC     = estimated time of completion from start date/time, hours
*
*
*
*         For the following two functions to work, the public variables
*                   tbeg_work  [99.0] = time workday starts
*                   tbeg_lunch [99.0] = time lunch starts
*                   tend_lunch [99.0] = time lunch ends
*                   tend_work  [99.0] = time workday ends
*                   thrs_work  [99.0] = (tbeg_lunch-tbeg_work)+(tend_work-tend_lunch)
*                   thrs_lunch [99.0] = tend_lunch-tbeg_lunch
*
*         must be available in the system.  I didn't include them as parameters
*         in order to keep the function format simple.  I keep them in
*         a .mem file and let the user change them in a utility.  I've
*         included this utility at the end of this file, commented out.
*

FUNCTION TATIME
* Syntax: TATIME( <start date>, <end date>, <start time>, <end time> )
* Return: A decimal showing number of hours
* Note:   Written by Amy Silverman 9/29/86.
*         SEE ABOVE NOTE on public variables
*         start time and end time should be in time string "99:99" format;
*         dates should be in date format
*         THIS FUNCTION WILL HANDLE ONE WEEKEND

PARAMETERS cl_sdate, cl_edate, cl_stime, cl_etime
RETURN IF( cl_sdate<cl_edate, thrs_work*(cl_edate-cl_sdate), 0) + (DECTIME(cl_etime) - DECTIME(cl_stime))+;
       IF( DECTIME(cl_stime) < tbeg_lunch .AND. DECTIME(cl_etime) > tend_lunch, -thrs_lunch, 0)+;
       IF( DECTIME(cl_stime) > tend_lunch .AND. DECTIME(cl_etime) < tbeg_lunch, thrs_lunch, 0)+;
       IF(dow(cl_sdate)>dow(cl_edate), -(thrs_work*2), 0)



FUNCTION ETC
* Syntax: ETC( <start date>, <start time>, <hours> )
* Return: Estimated Time of Completion -- string MM/DD/YY00:00
* Note:   written by Amy Silverman 10/22/86.
*         SEE ABOVE NOTE on public variables
*         date should be in date format; time in time string format "99:99"
*         THIS FUNCTION WILL HANDLE WEEKENDS

PARAMETERS cl_sdate, cl_stime, cl_hours
IF cl_hours<thrs_work .AND. DECTIME(cl_stime)+cl_hours+IF(DECTIME(cl_stime)<tbeg_lunch,thrs_lunch,0)<= tend_work
   * job will start and finish on the same day
   cl_etc = DTOC(cl_sdate)+;
   SIXTIME( DECTIME(cl_stime)+cl_hours+IF(DECTIME(cl_stime)<tbeg_lunch .AND. DECTIME(cl_stime)+cl_hours>tbeg_lunch, thrs_lunch, 0))
ELSE
   cl_remain = cl_hours
   cl_stoday = DECTIME(cl_stime)
   cl_edate = cl_sdate
   DO WHILE cl_stoday+cl_remain+IF(cl_stoday<tbeg_lunch,thrs_lunch,0) > tend_work
      cl_remain = cl_remain - (tend_work - (cl_stoday + IF(cl_stoday<tbeg_lunch,thrs_lunch,0)))
      cl_edate = cl_edate+1
      cl_stoday = tbeg_work
   ENDDO
   IF DOW(cl_edate)=1 .OR. DOW(cl_edate)=7
      * if etc falls on saturday or sunday, roll over to monday
      cl_edate = IF(DOW(cl_edate)=7, cl_edate+2, cl_edate+1)
   ENDIF
   cl_etc = DTOC(cl_edate)+;
   SIXTIME( cl_stoday + cl_remain + IF( cl_stoday + cl_remain > tbeg_lunch, thrs_lunch, 0))
ENDIF
RETURN cl_etc


FUNCTION DECTIME
* Syntax: DECTIME( <time string> )
* Return: A numeric time in hours + tenths of hours, ie 22.7
* Note:   written by Amy Silverman 9/15/86

PARAMETERS cl_time
RETURN ROUND(VAL(cl_time)+(VAL(SUBSTR(cl_time,4,2))*.0167),1)


FUNCTION SIXTIME
* Syntax: SIXTIME ( <numeric in hours+tenths of hours>  )
* Return: A time string "99:99"
* Note:   written by Amy Silverman 9/15/86

PARAMETERS cl_time
RETURN SUBSTR(STRZERO(cl_time,4,1),1,2)+":"+;
       STRZERO(VAL(SUBSTR(STR(cl_time,4,1),4,1))/.166,2)



* This is an example of a command file to let the user define working/lunch hours
*
*
*MTITLE = [  Define Working Hours  ]
*SET COLOR TO <inverse video>
*@ 3,((80 - LEN(MTITLE))/2)-1 SAY MTITLE
*SET COLOR TO <normal>
*@ 5,0 CLEAR
*
* work_hrs.mem includes variables Tbeg_work,Tbeg_lunch,Tend_lunch,Tend_work,Thrs_work,Thrs_lunch
* in decimal format
*
*RESTORE FROM WORK_HRS ADDITIVE
*
** convert decimal times to time strings
*TBEG_WORK  =  SIXTIME(TBEG_WORK)
*TBEG_LUNCH =  SIXTIME(TBEG_LUNCH)
*TEND_LUNCH =  SIXTIME(TEND_LUNCH)
*TEND_WORK  =  SIXTIME(TEND_WORK)
*
*@ 10,15,15,62 BOX <frame characters>
*
*DO WHILE .T.
*
*   @ 11,16,14,61 BOX ''
*   @ 11,20 SAY [  Begin Work:] GET TBEG_WORK PICT [99:99] VALID VAL(TBEG_WORK)<24 .AND. VAL(SUBSTR(TBEG_WORK,4))<60
*   @ 12,20 SAY [ Begin Lunch:] GET TBEG_LUNCH PICT [99:99] VALID VAL(TBEG_LUNCH)<24 .AND. VAL(SUBSTR(TBEG_LUNCH,4))<60
*   @ 13,20 SAY [   End Lunch:] GET TEND_LUNCH PICT [99:99] VALID VAL(TEND_LUNCH)<24 .AND. VAL(SUBSTR(TEND_LUNCH,4))<60
*   @ 14,20 SAY [    End Work:] GET TEND_WORK PICT [99:99] VALID VAL(TEND_WORK)<24 .AND. VAL(SUBSTR(TEND_WORK,4))<60
*   @ 23,0 CLEAR
*   @ 24,0 SAY [ If no time for lunch to be calculated, enter the same begin & end lunch times ]
*   READ
*   IF SECS(TBEG_WORK)>SECS(TBEG_LUNCH) .OR. SECS(TBEG_LUNCH)>SECS(TEND_LUNCH) .OR. SECS(TEND_LUNCH)>SECS(TEND_WORK)
*      @ 24,0 CLEAR
*      @ 24,0 SAY [       ERROR ... Begin times are greater than End times ... please retry   ]
*   ELSE
*      TBEG_WORK  =  DECTIME(TBEG_WORK)
*      TBEG_LUNCH =  DECTIME(TBEG_LUNCH)
*      TEND_LUNCH =  DECTIME(TEND_LUNCH)
*      TEND_WORK  =  DECTIME(TEND_WORK)
*      THRS_WORK  =  (TBEG_LUNCH-TBEG_WORK) + (TEND_WORK-TEND_LUNCH)
*      THRS_LUNCH =  TEND_LUNCH - TBEG_LUNCH
*
*      EXIT
*   ENDIF
*ENDDO
*
** save new values to work_hrs.mem file
*
*SAVE ALL LIKE T* TO WORK_HRS
*
**
*RETURN


******************************** EOF TIMEUDFS.PRG *******************************
LL LIKE T* TO WORK_HRS
*
**
*RETURN


*************************