******************************************************************************
*  THOUGHTS.prg
*  Copyright 1993 by Ian Thurston, Barrie, Ont. - but (ab)use this as you will
*  Demonstration of a CLIPPER UDF to pop up "thoughts for the day"
*
*  To compile the demo
*        CLIPPER thoughts
*
*  To link the demo
*        TLINK thoughts,,,CLIPPER.LIB EXTEND.LIB
*    or  PLINK86 FI thoughts LIB CLIPPER, EXTEND
*
**** DEMO OF THOUGHT() function ***********************************************

SETCOLOR( IIF( ISCOLOR(), "W/B,B/W","W/N,N/W"))
@ 1,0 SAY REPLICATE(CHR(176),1840)  && tiling
DO WHILE .T.    && pretty shoddy, I know
SETCOLOR( "N/W,W/N")
@ 0,0 CLEAR TO 0,79
@ 24,0 CLEAR TO 24,79
@ 24,10 say "A Demonstration of THOUGHT(), Copyright 1993 by Ian Thurston"
@ 0, 5 PROMPT "Demonstration"
@ 0,25 PROMPT "Source Code"
@ 0,45 PROMPT "Documentation"
@ 0,65 PROMPT "Exit to DOS"
MENU TO h_choice
SETCOLOR( IIF( ISCOLOR(), "W/B,B/W","W/N,N/W"))
SAVE SCREEN TO s_thought
DO CASE
CASE h_choice = 1   && Do The Demo
    SET CURSOR OFF
    Thought()                             && actual function call
    SET CURSOR ON
CASE h_choice = 2   && check out the program
    DO scanfile WITH "THOUGHTS.PRG"
    IF yes_no("Do you want to extract the function to a file ?")
        a = memoread("THOUGHTS.PRG")
        IF MEMOWRIT("THOUGHT.FUN",substr(a, AT(CHR(42)+ " Copyright",a)))
            @ 12,20 SAY "Function extracted to file THOUGHT.FUN"
        ELSE
            @ 12,10 SAY "Sorry, unable to write to file at this time."
        ENDIF
        INKEY(5)
    ENDIF
CASE h_choice = 3   && read the documentation
    DO scanfile WITH "WHATSUP.DOC"
CASE h_choice = 0 .OR. h_choice = 4     && Exit
    @ 20,10 SAY "Thanks for trying 'THOUGHT()' (a.k.a. 'Rodin the Destroyer')"
    INKEY(3)
    QUIT
ENDCASE
RESTORE SCREEN FROM s_thought
ENDDO

****
PROC scanfile   && Support routine ... THOUGHT() is at the bottom
****
PARAMETERS what2scan
PRIVATE a
IF FILE(what2scan)
    PRIVATE s_scanfile, tempcolor
    SAVE SCREEN TO s_scanfile
    @  2 ,15 SAY "Browse ASCII File: Use cursor keys to move, ESC to Exit"
    @  3,0 SAY REPLICATE( CHR(220), 80)
    @ 23,0 SAY REPLICATE( CHR(223), 80)
    tempcolor=SETCOLOR( SUBSTR(SETCOLOR(), AT(",",SETCOLOR())+1))
    a = MEMOREAD(what2scan)
    MEMOEDIT( substr(a, AT(CHR(42)+ " Copyright",a)), 4, 0, 22, 79, .F.)
    RESTORE SCREEN FROM s_scanfile
    SETCOLOR( tempcolor)
    RELEASE s_scanfile, tempcolor
ENDIF
RETURN

****
FUNC yes_no
****
PARAMETERS what2ask
PRIVATE rval, s_yn
s_yn = SAVESCREEN(10,3,14,76)
@ 10,3,14,76 BOX " "
@ 12,5 SAY what2ask
@ ROW(),COL()+2 PROMPT "YES"
@ ROW(),COL()+2 PROMPT "NO"
MENU TO rval
RESTSCREEN(10,3,14,76,s_yn)
RETURN rval = 1

* Here's the meat:


* Copyright 1993 by Ian Thurston, Barrie, Ontario
********
FUNCTION Thought          && generate "thought for the day"
********
*  Calling sequence: [mvar =] thought()
*
*  Assumes: File THOUGHTS.DAT is in EXE's working directory
*
*  Examples:
*   Thought()                   displays box in centre of screen with
*                               thought for day. Waits for key-press
*
*  Keys:
*   any key exits

PRIVATE t_file, t_title
t_title = "Thought for the day"
t_file = "QUOTE.DAT"
* Or any file with the following structure:
* a. each line is <= 254 characters line
* b. each line contains a quotation
* c. embedded minus signs ("-") are expanded with CR/LF + spaces,
*    to identify the author if specified

IF FILE(t_file)                             && gotta have the file to do it
        PRIVATE t_color, t_screen
        t_color=SETCOLOR("N/W")
        t_screen=SAVESCREEN(7,2,17,78)
        Box3d(7,2,17,78)                    && draw a box that looks 3d-ish
        Box3d( 8, 3, 16, 77)                && nest another one inside it
        SET CURSOR OFF
        @  9, 40 - len(t_title)/2 say t_title
        @  15, 30 say " Press ANY KEY to go on "
        KEYBOARD CHR(27)                    && gets us out of following edit
        memoedit(strtran( memoline(memoread(t_file), 254,;
                 mod(100*seconds(), ;
                 mlcount(memoread(t_file),254) )+1),;
                 " - ", chr(13)+chr(10) + "    - "),11,5,14,75,.F.)


        * whew ! Here's what the previous mess does, from the inside out
        * 1. Read the file we specified and count the # of lines
        * 2. Use the SECONDS() function to sorta generate a random number
        * 3. re-read the file, to the line corresponding the random number
        * 4. expand " - " by adding CR / LF and some spaces
        * 5. display the result in a memoedit window
        * 6. since we stuffed an ESC into the keyboard, exit the edit


        INKEY( 30)                          && leave on the screen a while
        SETCOLOR( t_color)
        RESTSCREEN( 7 , 2, 17, 78,t_screen)
        RELEASE t_color, t_screen
        SET CURSOR ON
ENDIF
RETURN .T.

FUNCTION Box3d
* In a dim light, might be confused with graphics mode, we hope
PARAMETERS tr, tc, br, bc               && pass the corners;
PRIVATE TempColor, Ro, Co               && preserve color and cursor position
Ro = ROW()
Co = COL()
TempColor = SETCOLOR( "N/W")            && first, draw a normal box
@ tr, tc,  br, bc BOX "Ŀ "       && in black on white
SETCOLOR( "W+/W")
@ br, tc + 1 TO br, bc - 1              && then we brighten bottom ...
@ tr + 1, bc TO br - 1, bc              && and right side ...
@ tr, bc SAY ""                        && top right corner ...
@ br, bc SAY ""                        && and bottom right corner
SETCOLOR( TempColor)                    && "All things are as they were then,
@ Ro, Co SAY ""                         && " ... only, you are there !"
RETURN .T.

